/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import com.geoxp.oss.CryptoHelper;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.functions.SNAPSHOT;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import org.apache.commons.codec.binary.Hex;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.interfaces.ECPrivateKey;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.math.ec.ECCurve;

public class ECGEN
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public static final BouncyCastleProvider BCProvider = new BouncyCastleProvider();

    public ECGEN(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof String)) {
            throw new WarpScriptException(this.getName() + " expects a curve name.");
        }
        String name = (String)top;
        ECKeyPairGenerator gen = new ECKeyPairGenerator();
        ECNamedCurveParameterSpec spec = ECNamedCurveTable.getParameterSpec((String)name);
        if (null == spec) {
            throw new WarpScriptException(this.getName() + " only supports the following curves: " + ECGEN.getCurves() + ".");
        }
        ECCurve curve = spec.getCurve();
        ECDomainParameters domainParams = new ECDomainParameters(curve, spec.getG(), spec.getN(), spec.getH(), spec.getSeed());
        ECKeyGenerationParameters params = new ECKeyGenerationParameters(domainParams, CryptoHelper.getSecureRandom());
        gen.init((KeyGenerationParameters)params);
        AsymmetricCipherKeyPair keypair = gen.generateKeyPair();
        ECPrivateKeyParameters privateKey = (ECPrivateKeyParameters)keypair.getPrivate();
        ECPublicKeyParameters publicKey = (ECPublicKeyParameters)keypair.getPublic();
        LinkedHashMap<String, String> keyparams = new LinkedHashMap<String, String>();
        keyparams.put("curve", name);
        keyparams.put("d", privateKey.getD().toString());
        stack.push(keyparams);
        keyparams = new LinkedHashMap();
        keyparams.put("curve", name);
        keyparams.put("Q", Hex.encodeHexString((byte[])publicKey.getQ().getEncoded(false)));
        stack.push(keyparams);
        return stack;
    }

    public static String getCurves() {
        StringBuilder sb = new StringBuilder();
        Enumeration names = ECNamedCurveTable.getNames();
        while (names.hasMoreElements()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append((String)names.nextElement());
        }
        return sb.toString();
    }

    static {
        SNAPSHOT.addEncoder(new ECSnapshotEncoder());
    }

    private static class ECSnapshotEncoder
    implements SNAPSHOT.SnapshotEncoder {
        private ECSnapshotEncoder() {
        }

        @Override
        public boolean addElement(SNAPSHOT snapshot, StringBuilder sb, Object o, boolean readable) throws WarpScriptException {
            if (o instanceof ECPrivateKey) {
                sb.append("{ '");
                sb.append("curve");
                sb.append("' '");
                ECNamedCurveParameterSpec curve = (ECNamedCurveParameterSpec)((ECPrivateKey)o).getParameters();
                sb.append(curve.getName());
                sb.append("' '");
                sb.append("d");
                sb.append("' '");
                sb.append(((ECPrivateKey)o).getD());
                sb.append("' } ");
                sb.append("ECPRIVATE");
                sb.append(" ");
                return true;
            }
            if (o instanceof ECPublicKey) {
                sb.append("{ '");
                sb.append("curve");
                sb.append("' '");
                ECNamedCurveParameterSpec curve = (ECNamedCurveParameterSpec)((ECPublicKey)o).getParameters();
                sb.append(curve.getName());
                sb.append("' '");
                sb.append("Q");
                sb.append("' '");
                sb.append(Hex.encodeHex((byte[])((ECPublicKey)o).getQ().getEncoded(false)));
                sb.append("' } ");
                sb.append("ECPUBLIC");
                sb.append(" ");
                return true;
            }
            return false;
        }
    }
}

