/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.gts.UnsafeString;
import io.warp10.continuum.store.Constants;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.Locale;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.MutablePeriod;
import org.joda.time.Period;
import org.joda.time.ReadWritablePeriod;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISOPeriodFormat;

public class DURATION
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private static final Double STU = new Double(Constants.TIME_UNITS_PER_S);

    public DURATION(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object o = stack.pop();
        if (!(o instanceof String)) {
            throw new WarpScriptException(this.getName() + " expects an ISO8601 duration (a string) on top of the stack. See http://en.wikipedia.org/wiki/ISO_8601#Durations");
        }
        String duration_string = o.toString();
        String[] tokens = UnsafeString.split(duration_string, '.');
        long offset = 0L;
        if (tokens.length > 2) {
            throw new WarpScriptException(this.getName() + "received an invalid ISO8601 duration.");
        }
        if (2 == tokens.length) {
            duration_string = tokens[0].concat("S");
            String tmp = tokens[1].substring(0, tokens[1].length() - 1);
            Double d_offset = Double.valueOf("0." + tmp) * STU;
            offset = d_offset.longValue();
        }
        MutablePeriod period = new MutablePeriod();
        ISOPeriodFormat.standard().getParser().parseInto((ReadWritablePeriod)period, duration_string, 0, Locale.US);
        Period p = period.toPeriod();
        if (p.getMonths() != 0 || p.getYears() != 0) {
            throw new WarpScriptException(this.getName() + " doesn't support ambiguous durations containing years or months, please convert those to days.");
        }
        Duration duration = p.toDurationFrom((ReadableInstant)new Instant());
        if (p.getSeconds() < 0) {
            offset = -offset;
        }
        stack.push(duration.getMillis() * Constants.TIME_UNITS_PER_MS + offset);
        return stack;
    }
}

