/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.WarpConfig;
import io.warp10.WarpURLEncoder;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;

public class CALL
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private static int maxCapacity = Integer.parseInt(WarpConfig.getProperty("warpscript.call.maxcapacity", "1"));
    private Map<String, ProcessPool> subprograms = new HashMap<String, ProcessPool>();

    public CALL(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object subprogram = stack.pop();
        Object args = stack.pop();
        if (!(subprogram instanceof String) || !(args instanceof String)) {
            throw new WarpScriptException(this.getName() + " expects a subprogram name on top of an argument string.");
        }
        this.init(subprogram.toString());
        int attempts = 2;
        while (attempts > 0) {
            Process proc = null;
            try {
                --attempts;
                proc = this.subprograms.get(subprogram).get();
                if (null == proc) {
                    throw new WarpScriptException(this.getName() + " unable to acquire subprogram.");
                }
                proc.getOutputStream().write(WarpURLEncoder.encode(args.toString(), StandardCharsets.UTF_8).getBytes(StandardCharsets.UTF_8));
                proc.getOutputStream().write(10);
                proc.getOutputStream().flush();
                BufferedReader br = this.subprograms.get(subprogram).getReader(proc);
                String ret = br.readLine();
                if (null == ret) {
                    throw new WarpScriptException(this.getName() + " subprogram died unexpectedly.");
                }
                if (ret.startsWith(" ")) {
                    throw new WarpScriptException(URLDecoder.decode(ret.substring(1), StandardCharsets.UTF_8.name()));
                }
                stack.push(URLDecoder.decode(ret, StandardCharsets.UTF_8.name()));
                break;
            }
            catch (IOException ioe) {
                if (attempts > 0) continue;
                throw new WarpScriptException(ioe);
            }
            finally {
                if (null == proc) continue;
                this.subprograms.get(subprogram).release(proc);
            }
        }
        return stack;
    }

    private synchronized void init(String subprogram) throws WarpScriptException {
        if (this.subprograms.containsKey(subprogram)) {
            return;
        }
        String dir = WarpConfig.getProperty("warpscript.call.directory");
        if (null == dir) {
            throw new WarpScriptException(this.getName() + " configuration key '" + "warpscript.call.directory" + "' not set, " + this.getName() + " disabled.");
        }
        File root = new File(dir);
        File f = new File(root, subprogram);
        if (!f.exists() || !f.canExecute()) {
            throw new WarpScriptException(this.getName() + " invalid subprogram '" + subprogram + "'.");
        }
        if (!f.getAbsolutePath().startsWith(root.getAbsolutePath())) {
            throw new WarpScriptException(this.getName() + " invalid subprogram, not in the correct directory.");
        }
        this.subprograms.put(subprogram, new ProcessPool(f.getAbsolutePath()));
    }

    private static final boolean isAlive(Process proc) {
        try {
            proc.exitValue();
            return false;
        }
        catch (IllegalThreadStateException e) {
            return true;
        }
    }

    private static class ProcessPool {
        private List<Process> processes = new ArrayList<Process>();
        private Map<Process, BufferedReader> readers = new HashMap<Process, BufferedReader>();
        private AtomicInteger loaned = new AtomicInteger(0);
        private ProcessBuilder builder;
        private int capacity = 0;

        public ProcessPool(String path) {
            this.builder = new ProcessBuilder(path);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void provision() throws IOException {
            List<Process> list = this.processes;
            synchronized (list) {
                if (this.capacity > 0 && this.processes.size() + this.loaned.get() >= this.capacity) {
                    return;
                }
                Process proc = this.builder.start();
                BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                String cap = br.readLine();
                if (null == cap) {
                    throw new RuntimeException("Subprogram '" + this.builder.command().toString() + "' did not return its configured capacity.");
                }
                this.capacity = Integer.parseInt(cap);
                if (this.capacity > maxCapacity || this.capacity < 0) {
                    this.capacity = maxCapacity;
                }
                this.processes.add(proc);
                this.readers.put(proc, br);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Process get() throws IOException {
            Process proc = null;
            while (null == proc) {
                List<Process> list = this.processes;
                synchronized (list) {
                    if (this.processes.isEmpty()) {
                        this.provision();
                    }
                    if (!this.processes.isEmpty()) {
                        proc = this.processes.remove(0);
                        if (CALL.isAlive(proc)) {
                            this.loaned.addAndGet(1);
                            return proc;
                        }
                        this.readers.remove(proc);
                        proc = null;
                    }
                }
                LockSupport.parkNanos(100000L);
            }
            return proc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release(Process proc) {
            List<Process> list = this.processes;
            synchronized (list) {
                if (CALL.isAlive(proc)) {
                    this.processes.add(proc);
                } else {
                    this.readers.remove(proc);
                }
                this.loaned.addAndGet(-1);
            }
        }

        public BufferedReader getReader(Process proc) {
            return this.readers.get(proc);
        }
    }
}

