/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.binary;

import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GTSOpsHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;

public class SUB
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private final String typeCheckErrorMsg = this.getName() + " can only operate on numeric values, vectors, matrices and numeric Geo Time Series.";

    public SUB(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object op2 = stack.pop();
        Object op1 = stack.pop();
        if (op2 instanceof Number && op1 instanceof Number) {
            if (op1 instanceof Double || op2 instanceof Double) {
                stack.push(((Number)op1).doubleValue() - ((Number)op2).doubleValue());
            } else {
                stack.push(((Number)op1).longValue() - ((Number)op2).longValue());
            }
        } else if (op1 instanceof RealMatrix && op2 instanceof RealMatrix) {
            stack.push(((RealMatrix)op1).subtract((RealMatrix)op2));
        } else if (op1 instanceof RealVector && op2 instanceof RealVector) {
            stack.push(((RealVector)op1).subtract((RealVector)op2));
        } else if (op1 instanceof GeoTimeSerie && op2 instanceof GeoTimeSerie) {
            GeoTimeSerie gts1 = (GeoTimeSerie)op1;
            GeoTimeSerie gts2 = (GeoTimeSerie)op2;
            if (gts1.getType() != GeoTimeSerie.TYPE.DOUBLE && gts1.getType() != GeoTimeSerie.TYPE.LONG && 0 != GTSHelper.nvalues(gts1) || gts2.getType() != GeoTimeSerie.TYPE.DOUBLE && gts2.getType() != GeoTimeSerie.TYPE.LONG && 0 != GTSHelper.nvalues(gts2)) {
                throw new WarpScriptException(this.typeCheckErrorMsg);
            }
            GeoTimeSerie result = new GeoTimeSerie(Math.max(GTSHelper.nvalues(gts1), GTSHelper.nvalues(gts2)));
            result.setType(gts1.getType() == GeoTimeSerie.TYPE.LONG && gts2.getType() == GeoTimeSerie.TYPE.LONG ? GeoTimeSerie.TYPE.LONG : GeoTimeSerie.TYPE.DOUBLE);
            GTSOpsHelper.GTSBinaryOp op = new GTSOpsHelper.GTSBinaryOp(){

                @Override
                public Object op(GeoTimeSerie gtsa, GeoTimeSerie gtsb, int idxa, int idxb) {
                    return ((Number)GTSHelper.valueAtIndex(gtsa, idxa)).doubleValue() - ((Number)GTSHelper.valueAtIndex(gtsb, idxb)).doubleValue();
                }
            };
            GTSOpsHelper.applyBinaryOp(result, gts1, gts2, op);
            if (0 == result.size()) {
                result = result.cloneEmpty();
            }
            stack.push(result);
        } else if (op1 instanceof GeoTimeSerie && op2 instanceof Number || op1 instanceof Number && op2 instanceof GeoTimeSerie) {
            Number op;
            GeoTimeSerie gts;
            boolean op1gts = op1 instanceof GeoTimeSerie;
            int n = op1gts ? GTSHelper.nvalues((GeoTimeSerie)op1) : GTSHelper.nvalues((GeoTimeSerie)op2);
            GeoTimeSerie result = op1gts ? ((GeoTimeSerie)op1).cloneEmpty(n) : ((GeoTimeSerie)op2).cloneEmpty();
            GeoTimeSerie geoTimeSerie = gts = op1gts ? (GeoTimeSerie)op1 : (GeoTimeSerie)op2;
            if (0 == n) {
                stack.push(result);
                return stack;
            }
            if (gts.getType() != GeoTimeSerie.TYPE.LONG && gts.getType() != GeoTimeSerie.TYPE.DOUBLE) {
                throw new WarpScriptException(this.typeCheckErrorMsg);
            }
            Number number = op = op1gts ? (Number)((Number)op2) : (Number)((Number)op1);
            if (op instanceof Double || gts.getType() == GeoTimeSerie.TYPE.DOUBLE) {
                double opDouble = op.doubleValue();
                for (int i = 0; i < n; ++i) {
                    double value = op1gts ? ((Number)GTSHelper.valueAtIndex(gts, i)).doubleValue() - opDouble : opDouble - ((Number)GTSHelper.valueAtIndex(gts, i)).doubleValue();
                    GTSHelper.setValue(result, GTSHelper.tickAtIndex(gts, i), GTSHelper.locationAtIndex(gts, i), GTSHelper.elevationAtIndex(gts, i), value, false);
                }
            } else {
                long opLong = op.longValue();
                for (int i = 0; i < n; ++i) {
                    long value = op1gts ? ((Number)GTSHelper.valueAtIndex(gts, i)).longValue() - opLong : opLong - ((Number)GTSHelper.valueAtIndex(gts, i)).longValue();
                    GTSHelper.setValue(result, GTSHelper.tickAtIndex(gts, i), GTSHelper.locationAtIndex(gts, i), GTSHelper.elevationAtIndex(gts, i), value, false);
                }
            }
            stack.push(result);
        } else {
            throw new WarpScriptException(this.typeCheckErrorMsg);
        }
        return stack;
    }
}

