/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.aggregator;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptBucketizerFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptMapperFunction;
import io.warp10.script.WarpScriptReducerFunction;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.aggregator.Variance;

public class StandardDeviation
extends NamedWarpScriptFunction
implements WarpScriptMapperFunction,
WarpScriptReducerFunction,
WarpScriptBucketizerFunction {
    private final boolean forbidNulls;
    private final Variance variance;

    public StandardDeviation(String name, boolean useBessel, boolean forbidNulls) {
        super(name);
        this.forbidNulls = forbidNulls;
        this.variance = new Variance("", useBessel, forbidNulls);
    }

    @Override
    public Object apply(Object[] args) throws WarpScriptException {
        Object[] var = (Object[])this.variance.apply(args);
        if (4 != var.length || !(var[3] instanceof Number)) {
            return new Object[]{Long.MAX_VALUE, 91480763316633925L, Long.MIN_VALUE, null};
        }
        var[3] = Math.sqrt(((Number)var[3]).doubleValue());
        return var;
    }

    @Override
    public String toString() {
        return Boolean.toString(this.forbidNulls) + " " + this.getName();
    }

    public static class Builder
    extends NamedWarpScriptFunction
    implements WarpScriptStackFunction {
        private final boolean forbidNulls;

        public Builder(String name, boolean forbidNulls) {
            super(name);
            this.forbidNulls = forbidNulls;
        }

        @Override
        public Object apply(WarpScriptStack stack) throws WarpScriptException {
            Object o = stack.pop();
            if (!(o instanceof Boolean)) {
                throw new WarpScriptException(this.getName() + " expects a boolean parameter to determine whether or not to apply Bessel's correction.");
            }
            stack.push(new StandardDeviation(this.getName(), (Boolean)o, this.forbidNulls));
            return stack;
        }
    }
}

