/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.aggregator;

import com.geoxp.GeoXPLib;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.StackUtils;
import io.warp10.script.WarpScriptBucketizerFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptMapperFunction;
import io.warp10.script.WarpScriptReducerFunction;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.binary.EQ;
import java.util.Arrays;
import java.util.Comparator;

public class Percentile
extends NamedWarpScriptFunction
implements WarpScriptMapperFunction,
WarpScriptBucketizerFunction,
WarpScriptReducerFunction {
    private static final double EPSILON = 1.0E-6;
    private final int type;
    private final double percentile;
    private final boolean forbidNulls;

    public Percentile(String name, double percentile, int type, boolean forbidNulls) {
        super(name);
        this.percentile = Math.min(100.0, Math.max(0.0, percentile));
        this.type = type;
        this.forbidNulls = forbidNulls;
    }

    @Override
    public Object apply(Object[] args) throws WarpScriptException {
        double m;
        long[] ticks = (long[])args[3];
        long[] locations = (long[])args[4];
        long[] elevations = (long[])args[5];
        final Object[] values = (Object[])args[6];
        if (0 == ticks.length) {
            return new Object[]{Long.MAX_VALUE, 91480763316633925L, Long.MIN_VALUE, null};
        }
        int nullCounter = 0;
        for (Object v : values) {
            if (null != v) continue;
            ++nullCounter;
        }
        if (nullCounter != 0 && this.forbidNulls) {
            throw new WarpScriptException(this.getName() + " cannot compute median of null values.");
        }
        if (values.length == nullCounter) {
            return new Object[]{0, 91480763316633925L, Long.MIN_VALUE, null};
        }
        Integer[] indices = new Integer[values.length];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = i;
        }
        final String functionName = this.getName();
        try {
            Arrays.sort(indices, new Comparator<Integer>(){

                @Override
                public int compare(Integer idx1, Integer idx2) {
                    if (null == values[idx1] && null == values[idx2]) {
                        return 0;
                    }
                    if (null == values[idx1] || null == values[idx2]) {
                        return null == values[idx1] ? 1 : -1;
                    }
                    if (values[idx1] instanceof Number && values[idx2] instanceof Number) {
                        return EQ.compare((Number)values[idx1], (Number)values[idx2]);
                    }
                    throw new RuntimeException(functionName + " can only operate on numeric Geo Time Series.");
                }
            });
        }
        catch (RuntimeException re) {
            throw new WarpScriptException(re);
        }
        int nonNullLength = values.length - nullCounter;
        double p = this.percentile / 100.0;
        double pn = p * (double)nonNullLength;
        if (1 == this.type) {
            int j = (int)Math.ceil(pn);
            if (j > 0) {
                --j;
            }
            return new Object[]{ticks[indices[j]], locations[indices[j]], elevations[indices[j]], values[indices[j]]};
        }
        if (2 >= this.type) {
            int j = (int)Math.floor(pn);
            double g = pn - (double)j;
            double gamma = 1.0;
            if (Math.abs(g) < 1.0E-6) {
                gamma = 0.5;
            }
            return this.interpolate(nonNullLength, --j, gamma, indices, ticks, locations, elevations, values);
        }
        if (3 >= this.type) {
            double m2 = -0.5;
            int j = (int)Math.floor(pn + m2);
            double g = pn + m2 - (double)j;
            int gamma = 1;
            if (Math.abs(g) < 1.0E-6 && 0 == j % 2) {
                gamma = 0;
            }
            if (j + gamma > 0) {
                --j;
            }
            return new Object[]{ticks[indices[j + gamma]], locations[indices[j + gamma]], elevations[indices[j + gamma]], values[indices[j + gamma]]};
        }
        switch (this.type) {
            case 4: {
                m = 0.0;
                break;
            }
            case 5: {
                m = 0.5;
                break;
            }
            case 6: {
                m = p;
                break;
            }
            case 7: {
                m = 1.0 - p;
                break;
            }
            case 8: {
                m = (p + 1.0) / 3.0;
                break;
            }
            case 9: {
                m = p / 4.0 + 0.375;
                break;
            }
            default: {
                throw new WarpScriptException(this.getName() + " given invalid type.");
            }
        }
        int j = (int)Math.floor(pn + m);
        double gamma = pn + m - (double)j;
        return this.interpolate(nonNullLength, --j, gamma, indices, ticks, locations, elevations, values);
    }

    private Object[] interpolate(int nonNullLength, int j, double gamma, Integer[] indices, long[] ticks, long[] locations, long[] elevations, Object[] values) throws WarpScriptException {
        long location;
        if (j < 0) {
            return new Object[]{ticks[indices[0]], locations[indices[0]], elevations[indices[0]], ((Number)values[indices[0]]).doubleValue()};
        }
        if (j >= nonNullLength - 1) {
            return new Object[]{ticks[indices[nonNullLength - 1]], locations[indices[nonNullLength - 1]], elevations[indices[nonNullLength - 1]], ((Number)values[indices[nonNullLength - 1]]).doubleValue()};
        }
        if (j + 1 == nonNullLength || Math.abs(gamma) < 1.0E-6) {
            return new Object[]{ticks[indices[j]], locations[indices[j]], elevations[indices[j]], ((Number)values[indices[j]]).doubleValue()};
        }
        if (Math.abs(gamma - 1.0) < 1.0E-6) {
            return new Object[]{ticks[indices[j + 1]], locations[indices[j + 1]], elevations[indices[j + 1]], ((Number)values[indices[j + 1]]).doubleValue()};
        }
        if (!(values[0] instanceof Number)) {
            throw new WarpScriptException(this.getName() + " can only interpolate on numeric values");
        }
        long tick = Math.round((1.0 - gamma) * (double)ticks[indices[j]] + gamma * (double)ticks[indices[j + 1]]);
        if (91480763316633925L == locations[indices[j]]) {
            location = 91480763316633925L == locations[indices[j + 1]] ? 91480763316633925L : locations[indices[j + 1]];
        } else if (91480763316633925L == locations[indices[j + 1]]) {
            location = locations[indices[j]];
        } else {
            double[] latlonj = GeoXPLib.fromGeoXPPoint((long)locations[indices[j]]);
            double[] latlonjp1 = GeoXPLib.fromGeoXPPoint((long)locations[indices[j + 1]]);
            double lat = (1.0 - gamma) * latlonj[0] + gamma * latlonjp1[0];
            double lon = (1.0 - gamma) * latlonj[1] + gamma * latlonjp1[1];
            location = GeoXPLib.toGeoXPPoint((double)lat, (double)lon);
        }
        long elevation = Long.MIN_VALUE == elevations[indices[j]] ? (Long.MIN_VALUE == elevations[indices[j + 1]] ? Long.MIN_VALUE : elevations[indices[j + 1]]) : (Long.MIN_VALUE == elevations[indices[j + 1]] ? elevations[indices[j]] : Math.round((1.0 - gamma) * (double)elevations[indices[j]] + gamma * (double)elevations[indices[j + 1]]));
        double value = (1.0 - gamma) * ((Number)values[indices[j]]).doubleValue() + gamma * ((Number)values[indices[j + 1]]).doubleValue();
        return new Object[]{tick, location, elevation, value};
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(StackUtils.toString(this.percentile));
        sb.append(" ");
        sb.append("'type" + this.type + "'");
        sb.append(" ");
        sb.append(this.getName());
        return sb.toString();
    }

    public static class Builder
    extends NamedWarpScriptFunction
    implements WarpScriptStackFunction {
        private final boolean forbidNulls;

        public Builder(String name, boolean forbidNulls) {
            super(name);
            this.forbidNulls = forbidNulls;
        }

        @Override
        public Object apply(WarpScriptStack stack) throws WarpScriptException {
            Object top = stack.pop();
            int type = 1;
            if (top instanceof String) {
                String typeStr = ((String)top).toLowerCase();
                if (5 != typeStr.length() || !typeStr.startsWith("type")) {
                    throw new WarpScriptException(this.getName() + " expect percentile type to be 'typeX' where 0<X<10.");
                }
                type = typeStr.charAt(4) - 48;
                if (type < 1 || 9 < type) {
                    throw new WarpScriptException(this.getName() + " expect percentile type to be 'typeX' where X is a integer and 0<X<10.");
                }
                top = stack.pop();
            }
            if (!(top instanceof Number)) {
                throw new WarpScriptException("Invalid parameter for " + this.getName());
            }
            double percentile = ((Number)top).doubleValue();
            if (percentile < 0.0 || percentile > 100.0) {
                throw new WarpScriptException("Invalid percentile for " + this.getName() + ", MUST be between 0 and 100.");
            }
            stack.push(new Percentile(this.getName(), percentile, type, this.forbidNulls));
            return stack;
        }
    }
}

