/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.aggregator;

import com.geoxp.GeoXPLib;
import io.warp10.DoubleUtils;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.StackUtils;
import io.warp10.script.WarpScriptBucketizerFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptMapperFunction;
import io.warp10.script.WarpScriptReducerFunction;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;

public class CircularMean
extends NamedWarpScriptFunction
implements WarpScriptMapperFunction,
WarpScriptReducerFunction,
WarpScriptBucketizerFunction {
    private final double period;
    private final boolean forbidNulls;

    public CircularMean(String name, double period, boolean forbidNulls) {
        super(name);
        this.period = period;
        this.forbidNulls = forbidNulls;
    }

    @Override
    public Object apply(Object[] args) throws WarpScriptException {
        double circularmean;
        long[] ticks = (long[])args[3];
        long[] locations = (long[])args[4];
        long[] elevations = (long[])args[5];
        Object[] values = (Object[])args[6];
        if (0 == ticks.length) {
            return new Object[]{Long.MAX_VALUE, 91480763316633925L, Long.MIN_VALUE, null};
        }
        double sinSum = 0.0;
        double cosSum = 0.0;
        GeoTimeSerie.TYPE type = null;
        long latitudes = 0L;
        long longitudes = 0L;
        int locationcount = 0;
        long elev = 0L;
        int elevationcount = 0;
        long location = 91480763316633925L;
        long elevation = Long.MIN_VALUE;
        int nticks = 0;
        for (int i = 0; i < values.length; ++i) {
            double v;
            Object value = values[i];
            if (null == value && this.forbidNulls) {
                return new Object[]{Long.MAX_VALUE, 91480763316633925L, Long.MIN_VALUE, null};
            }
            if (null == value) continue;
            ++nticks;
            if (91480763316633925L != locations[i]) {
                long[] xy = GeoXPLib.xyFromGeoXPPoint((long)locations[i]);
                latitudes += xy[0];
                longitudes += xy[1];
                ++locationcount;
            }
            if (Long.MIN_VALUE != elevations[i]) {
                elev += elevations[i];
                ++elevationcount;
            }
            if (null == type) {
                if (value instanceof Number) {
                    type = GeoTimeSerie.TYPE.DOUBLE;
                    v = ((Number)value).doubleValue();
                    v = Math.PI * 2 * (v / this.period);
                    sinSum = Math.sin(v);
                    cosSum = Math.cos(v);
                    continue;
                }
                return new Object[]{Long.MAX_VALUE, 91480763316633925L, Long.MIN_VALUE, null};
            }
            v = ((Number)value).doubleValue();
            v = Math.PI * 2 * (v / this.period);
            sinSum += Math.sin(v);
            cosSum += Math.cos(v);
        }
        double d = circularmean = 0 == nticks ? Double.NaN : Math.atan2(sinSum, cosSum);
        if (!Double.isNaN(circularmean)) {
            circularmean = circularmean * this.period / (Math.PI * 2);
        }
        if (locationcount > 0) {
            location = GeoXPLib.toGeoXPPoint((long)(latitudes /= (long)locationcount), (long)(longitudes /= (long)locationcount));
        }
        if (elevationcount > 0) {
            elevation = elev / (long)elevationcount;
        }
        return new Object[]{0L, location, elevation, circularmean};
    }

    @Override
    public String toString() {
        return StackUtils.toString(this.period) + " " + this.getName();
    }

    public static class Builder
    extends NamedWarpScriptFunction
    implements WarpScriptStackFunction {
        private final boolean forbidNulls;

        public Builder(String name, boolean forbidNulls) {
            super(name);
            this.forbidNulls = forbidNulls;
        }

        @Override
        public Object apply(WarpScriptStack stack) throws WarpScriptException {
            Object o = stack.pop();
            if (!(o instanceof Number)) {
                throw new WarpScriptException(this.getName() + " expects a finite, strictly positive, numeric 'period' parameter.");
            }
            double period = ((Number)o).doubleValue();
            if (!DoubleUtils.isFinite(period) || period <= 0.0) {
                throw new WarpScriptException(this.getName() + " expects a finite, strictly positive, numeric 'period' parameter.");
            }
            stack.push(new CircularMean(this.getName(), period, this.forbidNulls));
            return stack;
        }
    }
}

