/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script;

import io.warp10.WarpConfig;
import io.warp10.script.MemoryWarpScriptStack;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptLib;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackRegistry;
import io.warp10.script.WarpScriptStopException;
import io.warp10.script.functions.EVAL;
import io.warp10.script.functions.SNAPSHOT;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Semaphore;
import org.apache.hadoop.util.Progressable;

public class WarpScriptExecutor
implements Serializable {
    private Progressable progressable;
    private WarpScriptStack.StackContext bootstrapContext = null;
    private String bootstrapCode = null;
    private WarpScriptStack.Macro macro;
    private String macroCode = null;
    private WarpScriptStack stack;
    private Semaphore sem;
    private StackSemantics semantics;
    private Map<String, Object> symbolTable;
    private static Properties properties;
    private ThreadLocal<WarpScriptStack> perThreadStack = null;

    public WarpScriptExecutor() {
    }

    public WarpScriptExecutor(StackSemantics semantics, String script) throws WarpScriptException {
        this(semantics, script, null);
    }

    public WarpScriptExecutor(StackSemantics semantics, String script, Map<String, Object> symbols) throws WarpScriptException {
        this(semantics, script, symbols, null);
    }

    public WarpScriptExecutor(StackSemantics semantics, String script, Map<String, Object> symbols, Progressable progressable) throws WarpScriptException {
        this(semantics, script, symbols, progressable, true);
    }

    public WarpScriptExecutor(StackSemantics semantics, String script, Map<String, Object> symbols, Progressable progressable, boolean wrapInMacro) throws WarpScriptException {
        WarpScriptStack.Macro macro;
        this.semantics = semantics;
        this.progressable = progressable;
        this.loadBootstrap(null);
        this.initStack();
        MemoryWarpScriptStack stack = new MemoryWarpScriptStack(null, null, new Properties());
        stack.maxLimits();
        if (null != this.progressable) {
            stack.setAttribute("hadoop.progressable", this.progressable);
        }
        try {
            stack.exec("BOOTSTRAP");
        }
        catch (WarpScriptException wse) {
            throw new RuntimeException(wse);
        }
        this.symbolTable = new HashMap<String, Object>();
        if (null != symbols) {
            this.symbolTable.putAll(symbols);
        }
        StringBuilder sb = new StringBuilder();
        if (wrapInMacro) {
            sb.append("<%");
            sb.append("\n");
        }
        sb.append(script);
        if (wrapInMacro) {
            sb.append("\n");
            sb.append("%>");
        }
        stack.save();
        MemoryWarpScriptStack.StackContext context = (MemoryWarpScriptStack.StackContext)stack.peek();
        context.symbolTable.putAll(this.symbolTable);
        stack.restore();
        stack.execMulti(sb.toString());
        if (1 != stack.depth()) {
            throw new WarpScriptException("Stack depth was not 1 after the code execution.");
        }
        if (!(stack.peek() instanceof WarpScriptStack.Macro)) {
            throw new WarpScriptException("No macro was found on top of the stack.");
        }
        this.macro = macro = (WarpScriptStack.Macro)stack.pop();
        this.macroCode = sb.toString();
    }

    private void initStack() {
        this.perThreadStack = new ThreadLocal<WarpScriptStack>(){

            @Override
            protected WarpScriptStack initialValue() {
                MemoryWarpScriptStack stack = new MemoryWarpScriptStack(null, null, properties);
                stack.setAttribute("stack.name", "[WarpScriptExecutor " + WarpScriptExecutor.this.semantics.name() + "]");
                stack.maxLimits();
                if (null != WarpScriptExecutor.this.progressable) {
                    stack.setAttribute("hadoop.progressable", WarpScriptExecutor.this.progressable);
                }
                try {
                    WarpScriptExecutor.this.loadBootstrap(stack);
                    stack.exec("BOOTSTRAP");
                }
                catch (WarpScriptException e) {
                    throw new RuntimeException(e);
                }
                return stack;
            }
        };
        if (StackSemantics.SYNCHRONIZED.equals((Object)this.semantics)) {
            this.stack = this.perThreadStack.get();
            if (null != this.progressable) {
                this.stack.setAttribute("hadoop.progressable", this.progressable);
            }
            this.sem = new Semaphore(1);
        } else {
            this.stack = null;
            this.sem = new Semaphore(Integer.MAX_VALUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object> exec(List<Object> input) throws WarpScriptException {
        try {
            this.sem.acquire();
        }
        catch (InterruptedException ie) {
            throw new WarpScriptException("Got interrupted while attempting to acquire semaphore.", ie);
        }
        WarpScriptStack stack = this.stack;
        try {
            if (null == stack) {
                stack = this.getStack();
            }
            if (null != this.symbolTable) {
                stack.save();
                MemoryWarpScriptStack.StackContext context = (MemoryWarpScriptStack.StackContext)stack.peek();
                context.symbolTable.putAll(this.symbolTable);
                stack.restore();
            }
            for (int i = input.size() - 1; i >= 0; --i) {
                stack.push(input.get(i));
            }
            try {
                stack.exec(this.macro);
            }
            catch (WarpScriptStopException i) {
                // empty catch block
            }
            ArrayList<Object> output = new ArrayList<Object>();
            while (stack.depth() > 0) {
                output.add(stack.pop());
            }
            ArrayList<Object> arrayList = output;
            return arrayList;
        }
        finally {
            if (null != stack) {
                stack.clear();
            }
            if (StackSemantics.NEW.equals((Object)this.semantics)) {
                WarpScriptStackRegistry.unregister(stack);
            }
            this.sem.release();
        }
    }

    private WarpScriptStack getStack() throws WarpScriptException {
        WarpScriptStack stack = null;
        if (null != this.stack) {
            return this.stack;
        }
        if (StackSemantics.PERTHREAD.equals((Object)this.semantics)) {
            stack = this.perThreadStack.get();
        } else if (StackSemantics.NEW.equals((Object)this.semantics)) {
            stack = new MemoryWarpScriptStack(null, null, properties);
            stack.setAttribute("stack.name", "[WarpScriptExecutor NEW]");
            ((MemoryWarpScriptStack)stack).maxLimits();
            if (null != this.progressable) {
                stack.setAttribute("hadoop.progressable", this.progressable);
            }
            try {
                stack.exec("BOOTSTRAP");
            }
            catch (WarpScriptException e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new WarpScriptException("Invalid stack semantics.");
        }
        return stack;
    }

    public WarpScriptExecutor store(String key, Object value) {
        this.symbolTable.put(key, value);
        return this;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        try {
            stream.writeUTF(this.semantics.name());
            if (null != this.bootstrapCode) {
                stream.writeUTF(this.bootstrapCode);
            } else {
                stream.writeUTF("");
            }
            SNAPSHOT snapshot = new SNAPSHOT("SNAPSHOTALL", true, false, true, false);
            if (null != this.stack) {
                snapshot.apply(this.stack);
                String stackSnapshot = this.stack.pop().toString();
                stream.writeUTF(stackSnapshot);
            } else {
                stream.writeUTF("");
            }
            MemoryWarpScriptStack tmpstack = new MemoryWarpScriptStack(null, null, new Properties());
            tmpstack.maxLimits();
            tmpstack.save();
            MemoryWarpScriptStack.StackContext context = (MemoryWarpScriptStack.StackContext)tmpstack.peek();
            context.symbolTable.putAll(this.symbolTable);
            tmpstack.restore();
            snapshot.apply(tmpstack);
            stream.writeUTF(tmpstack.pop().toString());
            stream.writeUTF(this.macroCode);
        }
        catch (WarpScriptException wse) {
            throw new IOException(wse);
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.semantics = StackSemantics.valueOf(stream.readUTF());
        String bootstrap = stream.readUTF();
        if (!"".equals(bootstrap)) {
            int lineno = 0;
            try {
                WarpScriptStack.StackContext context;
                String line;
                BufferedReader br = new BufferedReader(new StringReader(bootstrap));
                MemoryWarpScriptStack stck = new MemoryWarpScriptStack(null, null, new Properties());
                stck.maxLimits();
                while (null != (line = br.readLine())) {
                    ++lineno;
                    stck.exec(line);
                }
                br.close();
                stck.save();
                this.bootstrapContext = context = (WarpScriptStack.StackContext)stck.pop();
                this.bootstrapCode = bootstrap;
            }
            catch (Exception e) {
                throw new IOException("Exception while loading bootstrap code at line " + lineno, e);
            }
        }
        this.initStack();
        String state = stream.readUTF();
        EVAL eval = new EVAL("EVAL");
        if (!"".equals(state) && null != this.stack) {
            try {
                this.stack.push(state);
                eval.apply(this.stack);
            }
            catch (WarpScriptException wse) {
                throw new IOException(wse);
            }
        }
        String st = stream.readUTF();
        try {
            MemoryWarpScriptStack tmpstack = new MemoryWarpScriptStack(null, null, new Properties());
            tmpstack.maxLimits();
            tmpstack.push(st);
            eval.apply(tmpstack);
            tmpstack.save();
            MemoryWarpScriptStack.StackContext context = (MemoryWarpScriptStack.StackContext)tmpstack.peek();
            this.symbolTable = context.symbolTable;
        }
        catch (WarpScriptException wse) {
            throw new IOException(wse);
        }
        String macro = stream.readUTF();
        try {
            MemoryWarpScriptStack tmpstack = new MemoryWarpScriptStack(null, null, new Properties());
            tmpstack.maxLimits();
            tmpstack.save();
            MemoryWarpScriptStack.StackContext context = (MemoryWarpScriptStack.StackContext)tmpstack.peek();
            context.symbolTable.putAll(this.symbolTable);
            tmpstack.restore();
            tmpstack.push(macro);
            eval.apply(tmpstack);
            this.macro = (WarpScriptStack.Macro)tmpstack.pop();
        }
        catch (WarpScriptException wse) {
            throw new IOException(wse);
        }
    }

    private void loadBootstrap(WarpScriptStack stack) throws WarpScriptException {
        if (null != this.bootstrapContext) {
            if (null != stack) {
                stack.push(this.bootstrapContext);
                stack.restore();
            }
            return;
        }
        String bootstrap = System.getProperty("warpscript.bootstrap");
        if (null == bootstrap) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        if (bootstrap.startsWith("@")) {
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream(bootstrap.substring(1))));
                while (null != (line = reader.readLine())) {
                    sb.append(line);
                    sb.append("\n");
                }
                reader.close();
            }
            catch (IOException ioe) {
                throw new WarpScriptException(ioe);
            }
        } else {
            sb.append(bootstrap);
        }
        String code = sb.toString();
        int lineno = 0;
        try {
            WarpScriptStack.StackContext context;
            String line;
            BufferedReader br = new BufferedReader(new StringReader(code));
            MemoryWarpScriptStack stck = new MemoryWarpScriptStack(null, null, new Properties());
            stck.maxLimits();
            while (null != (line = br.readLine())) {
                ++lineno;
                stck.exec(line);
            }
            br.close();
            stck.save();
            this.bootstrapContext = context = (WarpScriptStack.StackContext)stck.pop();
            this.bootstrapCode = code;
            if (null != stack) {
                stack.push(this.bootstrapContext);
                stack.restore();
            }
        }
        catch (Exception e) {
            throw new WarpScriptException("Exception while loading bootstrap code at line " + lineno, e);
        }
    }

    static {
        try {
            String config = System.getProperty("warp10.config");
            if (null == config) {
                config = System.getenv("WARP10_CONFIG");
            }
            WarpConfig.safeSetProperties(config);
            properties = WarpConfig.getProperties();
            WarpScriptLib.registerExtensions();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static enum StackSemantics {
        SYNCHRONIZED,
        PERTHREAD,
        NEW;

    }
}

