/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script;

import io.warp10.WarpConfig;
import io.warp10.WarpURLDecoder;
import io.warp10.WarpURLEncoder;
import io.warp10.continuum.gts.UnsafeString;
import io.warp10.continuum.store.DirectoryClient;
import io.warp10.continuum.store.StoreClient;
import io.warp10.script.InformativeEmptyStackException;
import io.warp10.script.MacroHelper;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.StackUtils;
import io.warp10.script.WarpFleetMacroRepository;
import io.warp10.script.WarpScriptATCException;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptKillException;
import io.warp10.script.WarpScriptLib;
import io.warp10.script.WarpScriptMacroLibrary;
import io.warp10.script.WarpScriptMacroRepository;
import io.warp10.script.WarpScriptReturnException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.WarpScriptStackRegistry;
import io.warp10.script.WarpScriptStopException;
import io.warp10.script.functions.MSGFAIL;
import io.warp10.script.functions.SECURE;
import io.warp10.sensision.Sensision;
import io.warp10.warp.sdk.MacroResolver;
import io.warp10.warp.sdk.WarpScriptJavaFunction;
import io.warp10.warp.sdk.WarpScriptJavaFunctionException;
import io.warp10.warp.sdk.WarpScriptRawJavaFunction;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.util.Progressable;

public class MemoryWarpScriptStack
implements WarpScriptStack,
Progressable {
    private static final Properties DEFAULT_PROPERTIES = WarpConfig.getProperties();
    private boolean functionMetrics = true;
    private WarpScriptStack.Signal signal = null;
    private boolean signaled = false;
    private final boolean allowLooseBlockComments;
    private AtomicLong[] counters;
    private final Object[] registers;
    private int maxdepth = 0;
    private long maxops = 0L;
    private int maxsymbols = 0;
    private long maxrecurse = 0L;
    private long currentops = 0L;
    private String sectionName = null;
    private String macroName = null;
    private boolean inSecureMacro = false;
    private int size = 0;
    private int offset = 0;
    private Object[] elements = new Object[32];
    private final Map<String, Object> symbolTable = new HashMap<String, Object>();
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private StoreClient storeClient;
    private DirectoryClient directoryClient;
    private final String uuid = UUID.randomUUID().toString();
    private final List<WarpScriptStack.Macro> macros = new ArrayList<WarpScriptStack.Macro>();
    private StringBuilder secureScript = null;
    private AtomicBoolean inComment = new AtomicBoolean(false);
    private AtomicBoolean inMultiline = new AtomicBoolean(false);
    private StringBuilder multiline;
    private Map<String, WarpScriptStackFunction> defined = new HashMap<String, WarpScriptStackFunction>();
    private Progressable progressable = null;
    private Properties properties;
    private final boolean unshadow;
    private final long creationTime = System.currentTimeMillis();
    private long reclevel = 0L;

    @Override
    public StoreClient getStoreClient() {
        return this.storeClient;
    }

    @Override
    public DirectoryClient getDirectoryClient() {
        return this.directoryClient;
    }

    public MemoryWarpScriptStack(StoreClient storeClient, DirectoryClient directoryClient) {
        this(storeClient, directoryClient, DEFAULT_PROPERTIES);
    }

    public MemoryWarpScriptStack(StoreClient storeClient, DirectoryClient directoryClient, Properties properties) {
        this(storeClient, directoryClient, properties, true);
    }

    public MemoryWarpScriptStack(StoreClient storeClient, DirectoryClient directoryClient, Properties properties, boolean init) {
        this.storeClient = storeClient;
        this.directoryClient = directoryClient;
        if (null == properties) {
            throw new RuntimeException("Warp 10 configuration not set.");
        }
        this.unshadow = "true".equals(properties.getProperty("warpscript.def.unshadow"));
        if (init) {
            this.setAttribute("debug.depth", 0);
            this.setAttribute("json.strict", false);
            this.setAttribute("fetch.count", new AtomicLong(0L));
            this.setAttribute("gts.count", new AtomicLong(0L));
            this.setAttribute("fetch.limit", Long.parseLong(properties.getProperty("warpscript.maxfetch", Long.toString(100000L))));
            this.setAttribute("gts.limit", Long.parseLong(properties.getProperty("warpscript.maxgts", Long.toString(100000L))));
            this.setAttribute("elapsed", new ArrayList());
            this.setAttribute("loop.maxduration", Long.parseLong(properties.getProperty("warpscript.maxloop", Long.toString(5000L))));
            this.setAttribute("recursion.maxdepth", Integer.parseInt(properties.getProperty("warpscript.maxrecursion", Integer.toString(16))));
            this.setAttribute("stack.maxops", Long.parseLong(properties.getProperty("warpscript.maxops", Long.toString(1000L))));
            this.setAttribute("stack.symbols", Integer.parseInt(properties.getProperty("warpscript.maxsymbols", Integer.toString(64))));
            this.setAttribute("stack.maxdepth", Integer.parseInt(properties.getProperty("warpscript.maxdepth", Integer.toString(1000))));
            this.setAttribute("stack.maxwebcalls", new AtomicLong(Long.parseLong(properties.getProperty("warpscript.maxwebcalls", Integer.toString(4)))));
            this.setAttribute("stack.maxbuckets", Long.parseLong(properties.getProperty("warpscript.maxbuckets", Integer.toString(1000000))));
            this.setAttribute("stack.maxpixels", Long.parseLong(properties.getProperty("warpscript.maxpixels", Long.toString(1000000L))));
            this.setAttribute("stack.maxgeocells", Long.parseLong(properties.getProperty("warpscript.maxgeocells", Integer.toString(10000))));
            this.setAttribute("json.size.max", Long.parseLong(properties.getProperty("warpscript.maxjson", Long.toString(0x1400000L))));
            this.setAttribute("loop.maxduration.hard", Long.parseLong(properties.getProperty("warpscript.maxloop.hard", Long.toString(5000L))));
            this.setAttribute("recursion.maxdepth.hard", Integer.parseInt(properties.getProperty("warpscript.maxrecursion.hard", Integer.toString(16))));
            this.setAttribute("stack.maxdepth.hard", Integer.parseInt(properties.getProperty("warpscript.maxdepth.hard", Integer.toString(1000))));
            this.setAttribute("stack.maxops.hard", Long.parseLong(properties.getProperty("warpscript.maxops.hard", Long.toString(1000L))));
            this.setAttribute("stack.symbols.hard", Integer.parseInt(properties.getProperty("warpscript.maxsymbols.hard", Integer.toString(64))));
            this.setAttribute("stack.maxbuckets.hard", Long.parseLong(properties.getProperty("warpscript.maxbuckets.hard", Long.toString(1000000L))));
            this.setAttribute("stack.maxpixels.hard", Long.parseLong(properties.getProperty("warpscript.maxpixels.hard", Long.toString(1000000L))));
            this.setAttribute("fetch.limit.hard", Long.parseLong(properties.getProperty("warpscript.maxfetch.hard", Long.toString(100000L))));
            this.setAttribute("gts.limit.hard", Long.parseLong(properties.getProperty("warpscript.maxgts.hard", Long.toString(100000L))));
            this.setAttribute("stack.maxgeocells.hard", Long.parseLong(properties.getProperty("warpscript.maxgeocells.hard", Long.toString(10000L))));
            this.setAttribute("json.size.max.hard", Long.parseLong(properties.getProperty("warpscript.maxjson.hard", Long.toString(0x1400000L))));
            this.setAttribute("section.name", "[TOP]");
            this.counters = new AtomicLong[1];
            for (int i = 0; i < this.counters.length; ++i) {
                this.counters[i] = new AtomicLong(0L);
            }
        }
        this.properties = properties;
        int nregs = Integer.parseInt(this.properties.getProperty("warpscript.registers", String.valueOf(256L)));
        this.allowLooseBlockComments = "true".equals(properties.getProperty("warpscript.comments.loose", "false"));
        this.registers = new Object[nregs];
    }

    protected void finalize() throws Throwable {
        WarpScriptStackRegistry.unregister(this);
    }

    public void maxLimits() {
        this.setAttribute("fetch.limit", 0x7FFFFFFFFFFFFFFEL);
        this.setAttribute("gts.limit", 0x7FFFFFFFFFFFFFFEL);
        this.setAttribute("loop.maxduration", Long.MAX_VALUE);
        this.setAttribute("recursion.maxdepth", Integer.MAX_VALUE);
        this.setAttribute("stack.maxops", 0x7FFFFFFFFFFFFFFEL);
        this.setAttribute("stack.symbols", 0x7FFFFFFE);
        this.setAttribute("stack.maxdepth", 0x7FFFFFFE);
        this.setAttribute("stack.maxwebcalls", new AtomicLong(0x7FFFFFFFFFFFFFFEL));
        this.setAttribute("stack.maxbuckets", 0x7FFFFFFFFFFFFFFEL);
        this.setAttribute("stack.maxpixels", 0x7FFFFFFFFFFFFFFEL);
        this.setAttribute("stack.maxgeocells", 0x7FFFFFFE);
        this.setAttribute("json.size.max", Long.MAX_VALUE);
    }

    @Override
    public int depth() {
        return this.size;
    }

    @Override
    public void reset(int depth) throws WarpScriptException {
        if (depth < 0) {
            throw new IndexOutOfBoundsException("Index out of bound.");
        }
        if (this.size > depth) {
            this.size = depth;
        }
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public void drop() throws EmptyStackException {
        if (0 == this.size) {
            throw new InformativeEmptyStackException();
        }
        --this.size;
    }

    @Override
    public void dropn() throws EmptyStackException, IndexOutOfBoundsException {
        int n = this.getn();
        if (this.size < n || n < 0) {
            throw new IndexOutOfBoundsException("Index out of bound.");
        }
        this.size -= n;
    }

    @Override
    public void dup() throws EmptyStackException, WarpScriptException {
        if (0 == this.size) {
            throw new InformativeEmptyStackException();
        }
        Object element = this.elements[this.offset + this.size - 1];
        this.ensureCapacity(1);
        this.elements[this.offset + this.size++] = element;
    }

    @Override
    public void dupn() throws EmptyStackException, IndexOutOfBoundsException, WarpScriptException {
        int n = this.getn();
        if (this.size < n || n < 0) {
            throw new IndexOutOfBoundsException("Index out of bound.");
        }
        this.ensureCapacity(n);
        for (int count = n; count > 0; --count) {
            Object o = this.elements[this.offset + this.size - 1 - (n - 1)];
            this.elements[this.offset + this.size++] = o;
        }
    }

    @Override
    public Object pop() throws EmptyStackException {
        if (0 == this.size) {
            throw new InformativeEmptyStackException();
        }
        Object element = this.elements[this.offset + this.size - 1];
        --this.size;
        return element;
    }

    @Override
    public Object[] popn() throws EmptyStackException, IndexOutOfBoundsException {
        int n = this.getn();
        return this.popn(n);
    }

    @Override
    public Object[] popn(int n) throws EmptyStackException, IndexOutOfBoundsException {
        if (this.size < n || n < 0) {
            throw new IndexOutOfBoundsException("Index out of bound.");
        }
        Object[] objects = new Object[n];
        System.arraycopy(this.elements, this.offset + this.size - n, objects, 0, n);
        this.size -= n;
        return objects;
    }

    @Override
    public void push(Object o) throws WarpScriptException {
        this.ensureCapacity(1);
        this.elements[this.offset + this.size++] = o;
    }

    @Override
    public void swap() throws WarpScriptException, EmptyStackException, IndexOutOfBoundsException {
        Object top2;
        if (0 == this.size) {
            throw new InformativeEmptyStackException();
        }
        if (this.size < 2) {
            throw new IndexOutOfBoundsException("Index out of bound.");
        }
        Object top = this.elements[this.offset + this.size - 1];
        this.elements[this.offset + this.size - 1] = top2 = this.elements[this.offset + this.size - 2];
        this.elements[this.offset + this.size - 2] = top;
    }

    @Override
    public Object peek() throws EmptyStackException {
        if (0 == this.size) {
            throw new InformativeEmptyStackException();
        }
        return this.elements[this.offset + this.size - 1];
    }

    @Override
    public void rot() throws EmptyStackException, IndexOutOfBoundsException {
        if (0 == this.size) {
            throw new InformativeEmptyStackException();
        }
        if (this.size < 3) {
            throw new IndexOutOfBoundsException("Index out of bound.");
        }
        Object tmp = this.elements[this.offset + this.size - 1 - 2];
        for (int i = 0; i < 2; ++i) {
            this.elements[this.offset + this.size - 1 - 2 + i] = this.elements[this.offset + this.size - 1 - 2 + i + 1];
        }
        this.elements[this.offset + this.size - 1] = tmp;
    }

    @Override
    public void roll() throws EmptyStackException, IndexOutOfBoundsException {
        int n = this.getn();
        if (this.size < n || n < 0) {
            throw new IndexOutOfBoundsException("Index out of bound.");
        }
        Object tmp = this.elements[this.offset + this.size - 1 - (n - 1)];
        for (int i = 0; i < n - 1; ++i) {
            this.elements[this.offset + this.size - 1 - (n - 1) + i] = this.elements[this.offset + this.size - 1 - (n - 1) + i + 1];
        }
        this.elements[this.offset + this.size - 1] = tmp;
    }

    @Override
    public Object peekn() throws WarpScriptException {
        int n = this.getn();
        return this.get(n);
    }

    @Override
    public Object get(int n) throws WarpScriptException {
        if (this.size - 1 < n || n < 0) {
            throw new WarpScriptException("Invalid level.");
        }
        return this.elements[this.offset + this.size - 1 - n];
    }

    private int getn() throws EmptyStackException, IndexOutOfBoundsException {
        if (0 == this.size) {
            throw new InformativeEmptyStackException();
        }
        Object o = this.pop();
        if (!(o instanceof Number)) {
            throw new IndexOutOfBoundsException("Unexpected type, expecting a numerical value.");
        }
        int n = ((Number)o).intValue();
        return n;
    }

    @Override
    public void execMulti(String script) throws WarpScriptException {
        BufferedReader br = new BufferedReader(new StringReader(script));
        int i = 1;
        try {
            String line;
            while (null != (line = br.readLine())) {
                this.exec(line);
                ++i;
            }
            br.close();
        }
        catch (IOException ioe) {
            throw new WarpScriptException(ioe);
        }
        catch (WarpScriptStopException wsse) {
            throw wsse;
        }
        catch (Exception e) {
            throw new WarpScriptException("Line #" + i, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exec(String line) throws WarpScriptException {
        String rawline = line;
        try {
            String[] statements;
            this.recurseIn();
            line = line.trim();
            line = UnsafeString.sanitizeStrings(line);
            if (-1 != UnsafeString.indexOf(line, ' ') && !this.inMultiline.get()) {
                statements = UnsafeString.split(line, ' ');
            } else {
                statements = new String[1];
                statements[0] = this.inMultiline.get() ? ("'>".equals(line) ? line : rawline) : line;
            }
            this.progress();
            for (int st = 0; st < statements.length; ++st) {
                String stmt;
                block72: {
                    this.handleSignal();
                    stmt = statements[st];
                    if (0 == stmt.length() && !this.inMultiline.get()) continue;
                    if (!this.inMultiline.get()) {
                        stmt = stmt.trim();
                    }
                    if (this.inMultiline.get() || stmt.length() <= 0 || stmt.charAt(0) != '#' && (stmt.charAt(0) != '/' || stmt.length() < 2 || stmt.charAt(1) != '/')) break block72;
                    return;
                }
                try {
                    Object o;
                    if ("'>".equals(stmt)) {
                        if (!this.inMultiline.get()) {
                            throw new WarpScriptException("Not inside a multiline.");
                        }
                        this.inMultiline.set(false);
                        String mlcontent = this.multiline.toString();
                        if (null != this.secureScript) {
                            this.secureScript.append(" ");
                            this.secureScript.append("'");
                            try {
                                this.secureScript.append(WarpURLEncoder.encode(mlcontent, StandardCharsets.UTF_8));
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {
                                // empty catch block
                            }
                            this.secureScript.append("'");
                        } else if (this.macros.isEmpty()) {
                            this.push(mlcontent);
                        } else {
                            this.macros.get(0).add(mlcontent);
                        }
                        this.multiline.setLength(0);
                        continue;
                    }
                    if (this.inMultiline.get()) {
                        if (this.multiline.length() > 0) {
                            this.multiline.append("\n");
                        }
                        this.multiline.append(stmt);
                        continue;
                    }
                    if (!this.allowLooseBlockComments && "*/".equals(stmt)) {
                        if (!this.inComment.get()) {
                            throw new WarpScriptException("Not inside a comment.");
                        }
                        this.inComment.set(false);
                        continue;
                    }
                    if (this.allowLooseBlockComments && stmt.startsWith("/*") && stmt.endsWith("*/")) continue;
                    if (this.allowLooseBlockComments && this.inComment.get() && stmt.endsWith("*/")) {
                        this.inComment.set(false);
                        continue;
                    }
                    if (this.inComment.get()) continue;
                    if (!this.allowLooseBlockComments && "/*".equals(stmt)) {
                        this.inComment.set(true);
                        continue;
                    }
                    if (this.allowLooseBlockComments && stmt.startsWith("/*")) {
                        this.inComment.set(true);
                        continue;
                    }
                    if ("<'".equals(stmt)) {
                        if (1 != statements.length) {
                            throw new WarpScriptException("Can only start multiline strings by using <' on a line by itself.");
                        }
                        this.inMultiline.set(true);
                        this.multiline = new StringBuilder();
                        continue;
                    }
                    this.incOps();
                    this.checkOps();
                    if ("S>".equals(stmt)) {
                        if (null == this.secureScript) {
                            throw new WarpScriptException("Not inside a secure script definition.");
                        }
                        this.push(this.secureScript.toString());
                        this.secureScript = null;
                        new SECURE("SECURESCRIPT").apply(this);
                        continue;
                    }
                    if ("<S".equals(stmt)) {
                        if (null == this.secureScript) {
                            this.secureScript = new StringBuilder();
                            continue;
                        }
                        throw new WarpScriptException("Already inside a secure script definition.");
                    }
                    if (null != this.secureScript) {
                        this.secureScript.append(" ");
                        this.secureScript.append(stmt);
                        continue;
                    }
                    if ("%>".equals(stmt)) {
                        if (this.macros.isEmpty()) {
                            throw new WarpScriptException("Not inside a macro definition.");
                        }
                        WarpScriptStack.Macro lastmacro = this.macros.remove(0);
                        boolean secure = Boolean.TRUE.equals(this.getAttribute("in.secure.macro"));
                        lastmacro.setSecure(secure);
                        if (this.macros.isEmpty()) {
                            this.push(lastmacro);
                            continue;
                        }
                        this.macros.get(0).add(lastmacro);
                        continue;
                    }
                    if ("<%".equals(stmt)) {
                        this.macros.add(0, new WarpScriptStack.Macro());
                        continue;
                    }
                    if (stmt.charAt(0) == '\'' && stmt.charAt(stmt.length() - 1) == '\'' || stmt.charAt(0) == '\"' && stmt.charAt(stmt.length() - 1) == '\"') {
                        try {
                            String str = stmt.substring(1, stmt.length() - 1);
                            str = WarpURLDecoder.decode(str, StandardCharsets.UTF_8);
                            if (this.macros.isEmpty()) {
                                this.push(str);
                                continue;
                            }
                            this.macros.get(0).add(str);
                            continue;
                        }
                        catch (UnsupportedEncodingException uee) {
                            throw new WarpScriptException(uee);
                        }
                    }
                    if (stmt.length() > 2 && stmt.charAt(1) == 'x' && stmt.charAt(0) == '0') {
                        long hexl;
                        long l = hexl = stmt.length() < 18 ? Long.parseLong(stmt.substring(2), 16) : new BigInteger(stmt.substring(2), 16).longValue();
                        if (this.macros.isEmpty()) {
                            this.push(hexl);
                            continue;
                        }
                        this.macros.get(0).add(hexl);
                        continue;
                    }
                    if (stmt.length() > 2 && stmt.charAt(1) == 'b' && stmt.charAt(0) == '0') {
                        long binl;
                        long l = binl = stmt.length() < 66 ? Long.parseLong(stmt.substring(2), 2) : new BigInteger(stmt.substring(2), 2).longValue();
                        if (this.macros.isEmpty()) {
                            this.push(binl);
                            continue;
                        }
                        this.macros.get(0).add(binl);
                        continue;
                    }
                    if (UnsafeString.isLong(stmt)) {
                        if (this.macros.isEmpty()) {
                            this.push(Long.valueOf(stmt));
                            continue;
                        }
                        this.macros.get(0).add(Long.valueOf(stmt));
                        continue;
                    }
                    if (UnsafeString.isDouble(stmt)) {
                        if (this.macros.isEmpty()) {
                            this.push(Double.valueOf(stmt));
                            continue;
                        }
                        this.macros.get(0).add(Double.valueOf(stmt));
                        continue;
                    }
                    if (stmt.equalsIgnoreCase("T") || stmt.equalsIgnoreCase("F") || stmt.equalsIgnoreCase("true") || stmt.equalsIgnoreCase("false")) {
                        if (stmt.startsWith("T") || stmt.startsWith("t")) {
                            if (this.macros.isEmpty()) {
                                this.push(true);
                                continue;
                            }
                            this.macros.get(0).add(true);
                            continue;
                        }
                        if (this.macros.isEmpty()) {
                            this.push(false);
                            continue;
                        }
                        this.macros.get(0).add(false);
                        continue;
                    }
                    if (stmt.startsWith("$")) {
                        if (this.macros.isEmpty()) {
                            o = this.load(stmt.substring(1));
                            if (null == o && !this.getSymbolTable().containsKey(stmt.substring(1))) {
                                throw new WarpScriptException("Unknown symbol '" + stmt.substring(1) + "'");
                            }
                            this.push(o);
                            continue;
                        }
                        this.macros.get(0).add(stmt.substring(1));
                        this.macros.get(0).add(WarpScriptLib.getFunction("LOAD"));
                        continue;
                    }
                    if (stmt.startsWith("!$")) {
                        o = this.load(stmt.substring(2));
                        if (null == o && !this.getSymbolTable().containsKey(stmt.substring(2))) {
                            throw new WarpScriptException("Unknown symbol '" + stmt.substring(2) + "'");
                        }
                        if (this.macros.isEmpty()) {
                            this.push(o);
                            continue;
                        }
                        this.macros.get(0).add(o);
                        continue;
                    }
                    if (stmt.startsWith("@")) {
                        if (this.macros.isEmpty()) {
                            String symbol = stmt.substring(1);
                            this.run(symbol);
                            continue;
                        }
                        this.macros.get(0).add(stmt.substring(1));
                        this.macros.get(0).add(WarpScriptLib.getFunction("RUN"));
                        continue;
                    }
                    Object func = this.findFunction(stmt);
                    HashMap<String, String> labels = new HashMap<String, String>();
                    labels.put("function", stmt);
                    long nano = System.nanoTime();
                    try {
                        if (func instanceof WarpScriptStackFunction && this.macros.isEmpty()) {
                            WarpScriptStackFunction esf = (WarpScriptStackFunction)func;
                            esf.apply(this);
                            continue;
                        }
                        if (this.macros.isEmpty()) {
                            this.push(func);
                            continue;
                        }
                        this.macros.get(0).add(func);
                        continue;
                    }
                    finally {
                        if (this.functionMetrics) {
                            Sensision.update((String)"warp.script.function.count", labels, (Number)1);
                            Sensision.update((String)"warp.script.function.time.us", labels, (Number)((System.nanoTime() - nano) / 1000L));
                        }
                    }
                }
                catch (WarpScriptATCException e) {
                    throw e;
                }
                catch (Exception e) {
                    StringBuilder errorMessage = new StringBuilder("Exception at '");
                    boolean nextStatement = false;
                    for (int stc = Math.max(0, st - 3); stc < Math.min(statements.length, st + 4); ++stc) {
                        if (nextStatement) {
                            errorMessage.append(" ");
                        } else {
                            nextStatement = true;
                        }
                        if (st == stc) {
                            errorMessage.append("=>").append(StringUtils.abbreviateMiddle((String)statements[stc].trim(), (String)"...", (int)32)).append("<=");
                            continue;
                        }
                        errorMessage.append(StringUtils.abbreviateMiddle((String)statements[stc], (String)"...", (int)32));
                    }
                    errorMessage.append("' in section " + this.sectionName);
                    throw new WarpScriptException(errorMessage.toString(), e);
                }
            }
            return;
        }
        finally {
            this.recurseOut();
        }
    }

    @Override
    public void exec(WarpScriptStack.Macro macro) throws WarpScriptException {
        this.incOps();
        boolean secure = this.inSecureMacro;
        String sectionname = this.sectionName;
        this.inSecureMacro = this.inSecureMacro || macro.isSecure();
        int i = 0;
        int n = macro.size();
        String macroname = this.macroName;
        this.macroName = macro.getName();
        try {
            this.recurseIn();
            this.progress();
            for (i = 0; i < n; ++i) {
                this.handleSignal();
                Object stmt = macro.get(i);
                this.incOps();
                if (stmt instanceof WarpScriptStackFunction) {
                    WarpScriptStackFunction esf = (WarpScriptStackFunction)stmt;
                    esf.apply(this);
                    continue;
                }
                this.push(stmt);
            }
            this.checkOps();
        }
        catch (WarpScriptReturnException ere) {
            if (this.getCounter(0).decrementAndGet() > 0L) {
                throw ere;
            }
        }
        catch (WarpScriptATCException wsatce) {
            throw wsatce;
        }
        catch (Exception ee) {
            String funcName;
            if (this.inSecureMacro) {
                throw ee;
            }
            String name = macro.getName();
            String section = (String)this.getAttribute("section.name");
            Object statement = macro.get(i);
            String statementString = statement.toString();
            if (statement instanceof NamedWarpScriptFunction && null != (funcName = ((NamedWarpScriptFunction)statement).getName())) {
                statementString = funcName;
            }
            if (null == name) {
                throw new WarpScriptException("Exception" + (i < n ? " at '" + statementString + "'" : "") + " in section '" + section + "'", ee);
            }
            throw new WarpScriptException("Exception" + (i < n ? " at '" + statementString + "'" : "") + " in section '" + section + "' called from macro '" + name + "'", ee);
        }
        finally {
            this.inSecureMacro = secure;
            this.recurseOut();
            this.sectionName = sectionname;
            this.macroName = macroname;
        }
    }

    @Override
    public void exec(WarpScriptJavaFunction function) throws WarpScriptException {
        try {
            if (function.isProtected() && !Boolean.TRUE.equals(this.getAttribute("in.secure.macro"))) {
                throw new WarpScriptException("UDF is protected.");
            }
        }
        catch (Throwable t) {
            throw new WarpScriptException(t);
        }
        int levels = function.argDepth();
        if (this.size < levels) {
            throw new WarpScriptException("Stack does not contain sufficient elements.");
        }
        ArrayList<Object> args = new ArrayList<Object>(levels);
        if (function instanceof WarpScriptRawJavaFunction) {
            args.add(this);
        } else {
            for (int i = 0; i < levels; ++i) {
                args.add(StackUtils.toSDKObject(this.pop()));
            }
        }
        try {
            List<Object> results = function.apply(args);
            if (!(function instanceof WarpScriptRawJavaFunction)) {
                for (Object result : results) {
                    this.push(StackUtils.fromSDKObject(result));
                }
            }
        }
        catch (WarpScriptJavaFunctionException ejfe) {
            throw new WarpScriptException(ejfe);
        }
    }

    @Override
    public Object findFunction(String stmt) throws WarpScriptException {
        Object func = this.defined.get(stmt);
        if (null != func && Boolean.FALSE.equals(this.getAttribute("allow.redefined"))) {
            throw new WarpScriptException("Disallowed redefined function '" + stmt + "'.");
        }
        Object object = func = null != func ? func : WarpScriptLib.getFunction(stmt);
        if (null == func) {
            throw new WarpScriptException("Unknown function '" + stmt + "'");
        }
        return func;
    }

    @Override
    public void run(String symbol) throws WarpScriptException {
        WarpScriptStack.Macro macro = this.find(symbol);
        this.exec(macro);
    }

    @Override
    public WarpScriptStack.Macro find(String symbol) throws WarpScriptException {
        Object macro = this.load(symbol = this.rewriteMacroSymbol(symbol));
        if (null == macro) {
            macro = WarpScriptMacroRepository.find(symbol);
        }
        if (null == macro) {
            macro = WarpScriptMacroLibrary.find(symbol);
        }
        if (null == macro) {
            macro = WarpFleetMacroRepository.find(this, symbol);
        }
        if (null == macro) {
            macro = MacroResolver.find(this, symbol);
        }
        if (null == macro) {
            throw new WarpScriptException("Unknown macro '" + symbol + "'");
        }
        if (!(macro instanceof WarpScriptStack.Macro)) {
            throw new WarpScriptException("'" + symbol + "' is not a macro.");
        }
        return (WarpScriptStack.Macro)macro;
    }

    @Override
    public String dump(int n) {
        StringBuilder sb = new StringBuilder();
        if (n > this.size) {
            n = this.size;
        }
        for (int i = n - 1; i >= 0; --i) {
            if (i >= this.size) continue;
            sb.append(i + 1);
            sb.append(": ");
            Object elt = this.elements[this.offset + this.size - 1 - i];
            if (elt instanceof Object[]) {
                sb.append(Arrays.toString((Object[])elt));
            } else {
                sb.append(elt);
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public void pick() throws EmptyStackException, IndexOutOfBoundsException, WarpScriptException {
        int n = this.getn();
        if (this.size < n || n < 0) {
            throw new IndexOutOfBoundsException("Index out of bound.");
        }
        this.ensureCapacity(1);
        Object o = this.elements[this.offset + this.size - 1 - (n - 1)];
        this.elements[this.offset + this.size++] = o;
    }

    @Override
    public void rolld() throws EmptyStackException, IndexOutOfBoundsException {
        int n = this.getn();
        if (this.size < n || n < 0) {
            throw new IndexOutOfBoundsException("Index out of bound.");
        }
        Object tmp = this.elements[this.offset + this.size - 1];
        for (int i = 0; i < n - 1; ++i) {
            this.elements[this.offset + this.size - 1 - i] = this.elements[this.offset + this.size - 1 - (i + 1)];
        }
        this.elements[this.offset + this.size - 1 - (n - 1)] = tmp;
    }

    @Override
    public Object load(String symbol) {
        return this.symbolTable.get(symbol);
    }

    @Override
    public void store(String symbol, Object value) throws WarpScriptException {
        if (this.symbolTable.size() >= this.maxsymbols) {
            throw new WarpScriptException("Symbol table has reached its maximum number of entries: " + this.maxsymbols);
        }
        this.symbolTable.put(symbol, value);
    }

    @Override
    public Object load(int regidx) throws WarpScriptException {
        if (regidx >= 0 && regidx < this.registers.length) {
            return this.registers[regidx];
        }
        throw new WarpScriptException("Invalid register number, must be between 0 and " + (this.registers.length - 1));
    }

    @Override
    public void store(int regidx, Object value) throws WarpScriptException {
        if (regidx < 0 || regidx >= this.registers.length) {
            throw new WarpScriptException("Invalid register number, must be between 0 and " + (this.registers.length - 1));
        }
        this.registers[regidx] = value;
    }

    @Override
    public void forget(String symbol) {
        if (null == symbol) {
            this.symbolTable.clear();
        } else {
            this.symbolTable.remove(symbol);
        }
    }

    @Override
    public Map<String, Object> getSymbolTable() {
        return this.symbolTable;
    }

    @Override
    public Object[] getRegisters() {
        return this.registers;
    }

    @Override
    public Map<String, WarpScriptStackFunction> getDefined() {
        return this.defined;
    }

    @Override
    public String getUUID() {
        return this.uuid;
    }

    @Override
    public Object setAttribute(String key, Object value) {
        if (null == value) {
            return this.attributes.remove(key);
        }
        if ("in.secure.macro".equals(key)) {
            boolean old = this.inSecureMacro;
            this.inSecureMacro = Boolean.TRUE.equals(value);
            return old;
        }
        if ("stack.maxdepth".equals(key)) {
            this.maxdepth = ((Number)value).intValue();
            if (this.elements.length > this.maxdepth) {
                if (this.size + this.offset > this.maxdepth) {
                    throw new IndexOutOfBoundsException("The stack depth is over the requested maximum depth.");
                }
                this.elements = Arrays.copyOf(this.elements, this.maxdepth);
            }
        } else if ("stack.maxops".equals(key)) {
            this.maxops = ((Number)value).longValue();
        } else if ("recursion.maxdepth".equals(key)) {
            this.maxrecurse = ((Number)value).intValue();
        } else if ("stack.symbols".equals(key)) {
            this.maxsymbols = ((Number)value).intValue();
        } else if ("stack.ops".equals(key)) {
            this.currentops = ((Number)value).longValue();
        } else if ("section.name".equals(key)) {
            this.sectionName = value.toString();
        } else if ("macro.name".equals(key)) {
            this.macroName = value.toString();
        } else if ("hadoop.progressable".equals(key)) {
            this.progressable = (Progressable)value;
        } else if ("stack.name".equals(key)) {
            WarpScriptStackRegistry.register(this);
        }
        return this.attributes.put(key, value);
    }

    @Override
    public Object getAttribute(String key) {
        if ("in.secure.macro".equals(key)) {
            return this.inSecureMacro;
        }
        if ("stack.ops".equals(key)) {
            return this.currentops;
        }
        if ("section.name".equals(key)) {
            return this.sectionName;
        }
        if ("macro.name".equals(key)) {
            return this.macroName;
        }
        if ("creation.time".equals(key)) {
            return this.creationTime;
        }
        return this.attributes.get(key);
    }

    public void incOps() throws WarpScriptException {
        ++this.currentops;
    }

    public void checkOps() throws WarpScriptException {
        if (this.currentops > this.maxops) {
            Sensision.update((String)"warp.script.opscount.exceeded", (Map)Sensision.EMPTY_LABELS, (Number)1);
            throw new WarpScriptException("Operation count (" + this.currentops + ") exceeded maximum of " + this.maxops);
        }
    }

    @Override
    public AtomicLong getCounter(int i) throws WarpScriptException {
        if (i >= 0 && i <= this.counters.length) {
            return this.counters[i];
        }
        throw new WarpScriptException("Invalid counter.");
    }

    public void progress() {
        if (null != this.progressable) {
            this.progressable.progress();
        }
    }

    @Override
    public boolean isAuthenticated() {
        return null != this.getAttribute("stack.token");
    }

    @Override
    public void checkBalanced() throws WarpScriptException {
        if (this.inMultiline.get()) {
            throw new WarpScriptException("Unbalanced <' construct.");
        }
        if (this.inComment.get()) {
            throw new WarpScriptException("Unbalanced /* construct.");
        }
        if (null != this.secureScript) {
            throw new WarpScriptException("Unbalanced <S construct.");
        }
        if (!this.macros.isEmpty()) {
            throw new WarpScriptException("Unbalanced <% construct.");
        }
    }

    @Override
    public void define(String stmt, WarpScriptStack.Macro macro) {
        if (null == macro) {
            if (this.unshadow) {
                this.defined.remove(stmt);
            } else {
                WarpScriptStack.Macro undefMacro = new WarpScriptStack.Macro();
                undefMacro.add("is undefined.");
                undefMacro.add(new MSGFAIL(stmt));
                this.defined.put(stmt, MacroHelper.wrap(stmt, undefMacro));
            }
        } else {
            this.defined.put(stmt, MacroHelper.wrap(stmt, macro));
        }
    }

    @Override
    public void save() throws WarpScriptException {
        StackContext context = new StackContext();
        context.symbolTable = new HashMap<String, Object>(this.symbolTable.size());
        context.symbolTable.putAll(this.symbolTable);
        context.registers = Arrays.copyOf(this.registers, this.registers.length);
        context.defined = new HashMap<String, WarpScriptStackFunction>(this.defined.size());
        context.defined.putAll(this.defined);
        this.push(context);
    }

    @Override
    public void restore() throws WarpScriptException {
        Object top = this.pop();
        if (!(top instanceof StackContext)) {
            throw new WarpScriptException("Invalid stack context.");
        }
        StackContext context = (StackContext)top;
        this.symbolTable.clear();
        if (null != context.symbolTable) {
            this.symbolTable.putAll(context.symbolTable);
        }
        System.arraycopy(context.registers, 0, this.registers, 0, this.registers.length);
        this.defined.clear();
        if (null != context.defined) {
            this.defined.putAll(context.defined);
        }
    }

    protected void recurseIn() throws WarpScriptException {
        if (++this.reclevel > this.maxrecurse) {
            throw new WarpScriptException("Maximum recursion level reached (" + this.reclevel + ")");
        }
    }

    protected void recurseOut() {
        --this.reclevel;
    }

    public long getRecursionLevel() {
        return this.reclevel;
    }

    public int getMacroDepth() {
        return this.macros.size();
    }

    public boolean isInMultiline() {
        return this.inMultiline.get();
    }

    public boolean isInComment() {
        return this.inComment.get();
    }

    public boolean isInSecureScript() {
        return null != this.secureScript;
    }

    public MemoryWarpScriptStack getSubStack() {
        final MemoryWarpScriptStack parentStack = this;
        MemoryWarpScriptStack stack = new MemoryWarpScriptStack(this.getStoreClient(), this.getDirectoryClient(), this.properties, false){
            private final Map<String, Object> attributes;
            {
                super(storeClient, directoryClient, properties, init);
                this.attributes = new HashMap<String, Object>();
            }

            @Override
            public void incOps() throws WarpScriptException {
                parentStack.incOps();
            }

            @Override
            public void checkOps() throws WarpScriptException {
                parentStack.checkOps();
            }

            @Override
            public Object getAttribute(String key) {
                if ("in.secure.macro".equals(key)) {
                    if (Boolean.TRUE.equals(parentStack.getAttribute("in.secure.macro"))) {
                        return true;
                    }
                    return this.attributes.get("in.secure.macro");
                }
                return parentStack.getAttribute(key);
            }

            @Override
            public Object setAttribute(String key, Object value) {
                if ("in.secure.macro".equals(key)) {
                    if (!Boolean.TRUE.equals(parentStack.getAttribute("in.secure.macro"))) {
                        return this.attributes.put(key, value);
                    }
                    return parentStack.getAttribute(key);
                }
                return parentStack.setAttribute(key, value);
            }

            @Override
            protected void recurseIn() throws WarpScriptException {
                parentStack.recurseIn();
            }

            @Override
            protected void recurseOut() {
                parentStack.recurseOut();
            }
        };
        stack.maxdepth = this.maxdepth;
        stack.counters = this.counters;
        stack.maxops = this.maxops;
        stack.maxrecurse = this.maxrecurse;
        stack.maxsymbols = this.maxsymbols;
        return stack;
    }

    private void ensureCapacity(int n) throws WarpScriptException {
        if (this.offset + this.size + n < this.elements.length) {
            return;
        }
        if (this.offset + this.size + n > this.maxdepth) {
            Sensision.update((String)"warp.script.stackdepth.exceeded", (Map)Sensision.EMPTY_LABELS, (Number)1);
            throw new WarpScriptException("Stack depth would exceed set limit of " + this.maxdepth);
        }
        int newCapacity = Math.min(this.maxdepth, this.elements.length + (this.elements.length >> 1) + n);
        this.elements = Arrays.copyOf(this.elements, newCapacity);
    }

    private String rewriteMacroSymbol(String symbol) {
        Map rules = (Map)this.attributes.get("import.rules");
        if (null == rules) {
            return symbol;
        }
        for (Map.Entry prefixAndSubstitute : rules.entrySet()) {
            String prefix = (String)prefixAndSubstitute.getKey();
            String substitute = (String)prefixAndSubstitute.getValue();
            if (!symbol.startsWith(prefix)) continue;
            symbol = substitute + symbol.substring(prefix.length());
            break;
        }
        return symbol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void signal(WarpScriptStack.Signal signal) {
        MemoryWarpScriptStack memoryWarpScriptStack = this;
        synchronized (memoryWarpScriptStack) {
            if (!this.signaled || this.signal.ordinal() < signal.ordinal()) {
                this.signal = signal;
                this.signaled = true;
            }
        }
    }

    @Override
    public void handleSignal() throws WarpScriptATCException {
        if (this.signaled) {
            this.doSignal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSignal() throws WarpScriptATCException {
        MemoryWarpScriptStack memoryWarpScriptStack = this;
        synchronized (memoryWarpScriptStack) {
            switch (this.signal) {
                case STOP: {
                    this.signal = null;
                    this.signaled = false;
                    throw new WarpScriptStopException("Execution received STOP signal.");
                }
                case KILL: {
                    throw new WarpScriptKillException("Execution received KILL signal.");
                }
            }
        }
    }

    public void setFunctionMetrics(boolean state) {
        this.functionMetrics = state;
    }

    @Override
    public int hide() {
        int count = this.size;
        this.offset += count;
        this.size -= count;
        return count;
    }

    @Override
    public int hide(int count) {
        if (0 == count) {
            return 0;
        }
        if (count > this.size) {
            count = this.size;
        } else if (count < 0 && (count += this.size) < 0) {
            count = 0;
        }
        this.offset += count;
        this.size -= count;
        return count;
    }

    @Override
    public void show() {
        int count = this.offset;
        this.offset -= count;
        this.size += count;
    }

    @Override
    public void show(int count) {
        if (0 == count) {
            return;
        }
        if (count > this.offset) {
            count = this.offset;
        } else if (count < 0) {
            count = (count += this.size) > 0 ? 0 : (-count > this.offset ? this.offset : -count);
        }
        this.offset -= count;
        this.size += count;
    }

    public static class StackContext
    extends WarpScriptStack.StackContext {
        public Map<String, Object> symbolTable;
        public Map<String, WarpScriptStackFunction> defined;
        public Object[] registers;
    }
}

