/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.continuum.gts;

import java.lang.reflect.Field;
import sun.misc.Unsafe;

public class UnsafeString {
    private static final Unsafe unsafe;
    private static final long valueOffset;
    private static final long offsetOffset;
    private static final long countOffset;
    private static final long hashOffset;

    public static final char[] getChars(String s) {
        return (char[])unsafe.getObject(s, valueOffset);
    }

    public static final char charAt(String s, int idx) {
        char[] chars = (char[])unsafe.getObject(s, valueOffset);
        return chars[idx];
    }

    public static final int getOffset(String s) {
        if (-1L == offsetOffset) {
            return 0;
        }
        return unsafe.getInt(s, offsetOffset);
    }

    public static final String[] split(String s, char ch) {
        int off = 0;
        int next = 0;
        int n = 1;
        while ((next = UnsafeString.indexOf(s, ch, off)) != -1) {
            off = next + 1;
            ++n;
        }
        next = 0;
        off = 0;
        String[] tokens = new String[n];
        int idx = 0;
        while ((next = UnsafeString.indexOf(s, ch, off)) != -1) {
            tokens[idx++] = s.substring(off, next);
            off = next + 1;
        }
        if (off == 0) {
            return new String[]{s};
        }
        tokens[idx] = s.substring(off);
        return tokens;
    }

    public static final String substring(String s, int start, int end) {
        return UnsafeString.buildUnsafe(UnsafeString.getChars(s), start, end - start);
    }

    private static final String buildUnsafe(char[] chars, int offset, int count) {
        if (-1L != countOffset) {
            String mutable = new String();
            unsafe.putObject(mutable, valueOffset, chars);
            unsafe.putInt(mutable, countOffset, count);
            unsafe.putIntVolatile(mutable, offsetOffset, offset);
            return mutable;
        }
        return new String(chars, offset, count);
    }

    public static boolean isLong(String s) {
        int i;
        char[] c = UnsafeString.getChars(s);
        for (i = 0; i < c.length && ' ' == c[i]; ++i) {
        }
        if (i == c.length) {
            return false;
        }
        if ('+' != c[i] && '-' != c[i] && (c[i] < '0' || c[i] > '9')) {
            return false;
        }
        if ('-' == c[i] || '+' == c[i]) {
            ++i;
        }
        boolean hasDigits = false;
        while (i < c.length) {
            if (c[i] < '0' || c[i] > '9') {
                return false;
            }
            hasDigits = true;
            ++i;
        }
        return hasDigits;
    }

    public static boolean isDouble_LIGHT(String s) {
        int i;
        char[] c = UnsafeString.getChars(s);
        for (i = 0; i < c.length && ' ' == c[i]; ++i) {
        }
        if (i == c.length) {
            return false;
        }
        if (('-' == c[i] || '+' == c[i]) && ++i >= c.length) {
            return false;
        }
        if (3 == c.length - i && 'N' == c[i] && 'a' == c[i + 1] && 'N' == c[i + 2]) {
            return true;
        }
        if (8 == c.length - i && 'I' == c[i] && 'n' == c[i + 1] && 'f' == c[i + 2] && 'i' == c[i + 3] && 'n' == c[i + 4] && 'i' == c[i + 5] && 't' == c[i + 6] && 'y' == c[i + 7]) {
            return true;
        }
        while (i < c.length) {
            if ('.' == c[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isDouble(String s) {
        int i;
        char[] c = UnsafeString.getChars(s);
        for (i = 0; i < c.length && ' ' == c[i]; ++i) {
        }
        if (i == c.length) {
            return false;
        }
        if (('-' == c[i] || '+' == c[i]) && ++i >= c.length) {
            return false;
        }
        if (3 == c.length - i && 'N' == c[i] && 'a' == c[i + 1] && 'N' == c[i + 2]) {
            return true;
        }
        if (8 == c.length - i && 'I' == c[i] && 'n' == c[i + 1] && 'f' == c[i + 2] && 'i' == c[i + 3] && 'n' == c[i + 4] && 'i' == c[i + 5] && 't' == c[i + 6] && 'y' == c[i + 7]) {
            return true;
        }
        if (c[i] < '0' || c[i] > '9') {
            return false;
        }
        int ne = 0;
        int nsign = 0;
        int ndot = 0;
        while (i < c.length) {
            if (c[i] >= '0' && c[i] <= '9') {
                ++i;
                continue;
            }
            if ('e' == c[i] || 'E' == c[i]) {
                if (0 != nsign) {
                    return false;
                }
                ++ne;
                ++i;
                continue;
            }
            if ('-' == c[i] || '+' == c[i]) {
                if (0 == ne) {
                    return false;
                }
                ++nsign;
                ++i;
                continue;
            }
            if ('.' == c[i]) {
                if (0 != ne || 0 != nsign) {
                    return false;
                }
                ++ndot;
                ++i;
                continue;
            }
            return false;
        }
        if (ne > 1 || nsign > 1 || ndot > 1) {
            return false;
        }
        return false != ne || false != ndot;
    }

    public static boolean mayBeDecimalDouble(String s) {
        char[] c = UnsafeString.getChars(s);
        for (int i = 0; i < c.length; ++i) {
            if (c[i] >= '0' && c[i] <= '9' || '.' == c[i] || '+' == c[i] || '-' == c[i]) continue;
            return false;
        }
        return true;
    }

    public static int indexOf(String str, char ch) {
        return UnsafeString.indexOf(str, ch, 0);
    }

    public static int indexOf(String str, char ch, int idx) {
        char[] c = UnsafeString.getChars(str);
        for (int i = idx; i < c.length; ++i) {
            if (ch != c[i]) continue;
            return i;
        }
        return -1;
    }

    public static String sanitizeStrings(String str) {
        char[] c = UnsafeString.getChars(str);
        String newstr = str;
        StringBuilder sb = null;
        boolean instring = false;
        int stringsep = 0;
        int lastidx = 0;
        for (int idx = 0; idx < c.length; ++idx) {
            if (instring && stringsep == c[idx]) {
                instring = false;
                stringsep = 0;
            } else if (!instring) {
                if ('\'' == c[idx]) {
                    instring = true;
                    stringsep = 39;
                } else if ('\"' == c[idx]) {
                    instring = true;
                    stringsep = 34;
                }
            }
            if (!instring || ' ' != c[idx]) continue;
            if (null == sb) {
                sb = new StringBuilder();
            }
            sb.append(c, lastidx, idx - lastidx);
            sb.append("%20");
            lastidx = idx + 1;
        }
        if (null != sb) {
            if (lastidx < c.length) {
                sb.append(c, lastidx, c.length - lastidx);
            }
            newstr = sb.toString();
        }
        return newstr;
    }

    public static void resetHash(String s) {
        unsafe.getAndSetInt(s, hashOffset, 0);
    }

    static {
        try {
            Field declaredField;
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            unsafe = (Unsafe)field.get(null);
            valueOffset = unsafe.objectFieldOffset(String.class.getDeclaredField("value"));
            try {
                declaredField = String.class.getDeclaredField("count");
            }
            catch (NoSuchFieldException e) {
                declaredField = null;
            }
            countOffset = null != declaredField ? unsafe.objectFieldOffset(declaredField) : -1L;
            try {
                declaredField = String.class.getDeclaredField("offset");
            }
            catch (NoSuchFieldException e) {
                declaredField = null;
            }
            offsetOffset = null != declaredField ? unsafe.objectFieldOffset(declaredField) : -1L;
            try {
                declaredField = String.class.getDeclaredField("hash");
            }
            catch (NoSuchFieldException e) {
                declaredField = null;
            }
            hashOffset = null != declaredField ? unsafe.objectFieldOffset(declaredField) : -1L;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

