/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.continuum.gts;

import io.warp10.WarpURLDecoder;
import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.store.Constants;
import io.warp10.continuum.store.thrift.data.Metadata;
import io.warp10.script.WarpScriptException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MetadataSelectorMatcher {
    private final Matcher classnamePattern;
    private final Map<String, Matcher> labelsPatterns;
    private final Map<String, Matcher> attributesPatterns;
    private final List<String> missingLabels = new ArrayList<String>();
    private final List<String> missingAttributes = new ArrayList<String>();
    private static final Pattern EXPR_RE = Pattern.compile("^(?<classname>[^{]+)\\{(?<labels>[^}]*)\\}(\\{(?<attributes>[^}]*)\\})?$");

    public MetadataSelectorMatcher(String selector) throws WarpScriptException {
        Matcher m = EXPR_RE.matcher(selector);
        if (!m.matches()) {
            throw new WarpScriptException("invalid syntax for selector.");
        }
        String classSelector = null;
        try {
            classSelector = WarpURLDecoder.decode(m.group("classname"), StandardCharsets.UTF_8);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.classnamePattern = "~.*".equals(classSelector) ? null : ("=".equals(classSelector) || "~".equals(classSelector) ? Pattern.compile(Pattern.quote("")).matcher("") : (classSelector.startsWith("~") ? Pattern.compile(classSelector.substring(1)).matcher("") : (classSelector.startsWith("=") ? Pattern.compile(Pattern.quote(classSelector.substring(1))).matcher("") : Pattern.compile(Pattern.quote(classSelector)).matcher(""))));
        String labelsSelection = m.group("labels");
        LinkedHashMap<String, String> labelsSelectors = null;
        try {
            labelsSelectors = GTSHelper.parseLabelsSelectors(labelsSelection);
        }
        catch (ParseException pe) {
            throw new WarpScriptException(pe);
        }
        if (0 == labelsSelectors.size()) {
            this.labelsPatterns = null;
        } else {
            this.labelsPatterns = new HashMap<String, Matcher>(labelsSelectors.size());
            for (Map.Entry l : labelsSelectors.entrySet()) {
                if (Constants.ABSENT_LABEL_SUPPORT && ("".equals(l.getValue()) || "=".equals(l.getValue()))) {
                    this.missingLabels.add((String)l.getKey());
                    continue;
                }
                if (((String)l.getValue()).startsWith("=")) {
                    this.labelsPatterns.put((String)l.getKey(), Pattern.compile(Pattern.quote(((String)l.getValue()).substring(1))).matcher(""));
                    continue;
                }
                this.labelsPatterns.put((String)l.getKey(), Pattern.compile(((String)l.getValue()).substring(1)).matcher(""));
            }
        }
        LinkedHashMap<String, String> attributesSelectors = null;
        String attributesSelection = m.group("attributes");
        if (attributesSelection != null) {
            try {
                attributesSelectors = GTSHelper.parseLabelsSelectors(attributesSelection);
            }
            catch (ParseException pe) {
                throw new WarpScriptException(pe);
            }
            this.attributesPatterns = new HashMap<String, Matcher>(attributesSelectors.size());
            for (Map.Entry a : attributesSelectors.entrySet()) {
                if (Constants.ABSENT_LABEL_SUPPORT && ("".equals(a.getValue()) || "=".equals(a.getValue()))) {
                    this.missingAttributes.add((String)a.getKey());
                    continue;
                }
                if (((String)a.getValue()).startsWith("=")) {
                    this.attributesPatterns.put((String)a.getKey(), Pattern.compile(Pattern.quote(((String)a.getValue()).substring(1))).matcher(""));
                    continue;
                }
                this.attributesPatterns.put((String)a.getKey(), Pattern.compile(((String)a.getValue()).substring(1)).matcher(""));
            }
        } else {
            this.attributesPatterns = null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean matches(Metadata metadata) {
        if (null == metadata) return false;
        if (null == metadata.getName()) {
            return false;
        }
        if (null != this.classnamePattern) {
            if (!this.classnamePattern.reset(metadata.getName()).matches()) return false;
        }
        boolean bl = true;
        boolean classnameMatch = bl;
        if (!classnameMatch) {
            return false;
        }
        Map<String, String> inputLabels = metadata.getLabels();
        Map<String, String> inputAttributes = metadata.getAttributes();
        boolean labelAndAttributeMatch = true;
        if (null != this.attributesPatterns) {
            if (null != this.labelsPatterns && null != inputLabels) {
                for (String string : this.missingLabels) {
                    if (null == inputLabels.get(string)) continue;
                    labelAndAttributeMatch = false;
                    break;
                }
                for (Map.Entry entry : this.labelsPatterns.entrySet()) {
                    String inputLabel;
                    if (labelAndAttributeMatch && (labelAndAttributeMatch = null != (inputLabel = inputLabels.get(entry.getKey())) && ((Matcher)entry.getValue()).reset(inputLabel).matches())) continue;
                    break;
                }
            }
            if (null == inputAttributes) return labelAndAttributeMatch;
            for (String string : this.missingAttributes) {
                if (null == inputAttributes.get(string)) continue;
                labelAndAttributeMatch = false;
                break;
            }
            Iterator<Object> iterator = this.attributesPatterns.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                if (!labelAndAttributeMatch) return labelAndAttributeMatch;
                String inputAttribute = inputAttributes.get(entry.getKey());
                labelAndAttributeMatch = null != inputAttribute && ((Matcher)entry.getValue()).reset(inputAttribute).matches();
            }
            return labelAndAttributeMatch;
        }
        if (null == this.labelsPatterns) return labelAndAttributeMatch;
        for (String string : this.missingLabels) {
            if ((null == inputLabels || null == inputLabels.get(string)) && (null == inputAttributes || null == inputAttributes.get(string))) continue;
            labelAndAttributeMatch = false;
            break;
        }
        Iterator<Object> iterator = this.labelsPatterns.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            if (!labelAndAttributeMatch) return labelAndAttributeMatch;
            if (null == inputLabels) continue;
            String inputLabel = inputLabels.get(entry.getKey());
            if (null != inputLabel) {
                labelAndAttributeMatch = ((Matcher)entry.getValue()).reset(inputLabel).matches();
                continue;
            }
            if (null != inputAttributes) {
                String inputAttribute = inputAttributes.get(entry.getKey());
                labelAndAttributeMatch = null != inputAttribute && ((Matcher)entry.getValue()).reset(inputAttribute).matches();
                continue;
            }
            labelAndAttributeMatch = false;
        }
        return labelAndAttributeMatch;
    }
}

