/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.continuum.gts;

import io.warp10.continuum.gts.CustomBuffer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class FileBasedCustomBuffer
implements CustomBuffer {
    private final int bufsize;
    private ByteBuffer buffer = null;
    private long offset = 0L;
    private long position = 0L;
    private final long filelen;
    private final FileInputStream stream;

    public FileBasedCustomBuffer(String path, int bufsize) throws IOException {
        this.filelen = new File(path).length();
        this.stream = new FileInputStream(path);
        this.bufsize = bufsize;
        this.ensure(1);
    }

    public long getPosition() {
        if (null == this.buffer) {
            return 0L;
        }
        return this.offset + (long)this.buffer.position();
    }

    public void setPosition(long position) {
        if (position >= this.filelen) {
            throw new RuntimeException("Requested position is past the end of the file.");
        }
        this.buffer = null;
        try {
            this.stream.skip(position - this.offset);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        this.offset = position;
    }

    @Override
    public byte get() {
        this.ensure(1);
        return this.buffer.get();
    }

    @Override
    public CustomBuffer get(byte[] dst) {
        this.ensure(dst.length);
        this.buffer.get(dst);
        return this;
    }

    @Override
    public CustomBuffer get(byte[] dst, int offset, int length) {
        this.ensure(length);
        this.buffer.get(dst, offset, length);
        return this;
    }

    @Override
    public double getDouble() {
        this.ensure(8);
        return this.buffer.getDouble();
    }

    @Override
    public long getLong() {
        this.ensure(8);
        return this.buffer.getLong();
    }

    @Override
    public void insert(byte[] data, int offset, int len) {
        ByteBuffer bb = ByteBuffer.allocate(len + this.buffer.remaining());
        bb.put(data, offset, len);
        bb.put(this.buffer);
        bb.flip();
        this.buffer = bb;
    }

    private final void ensure(int capacity) {
        if (null != this.buffer && this.buffer.remaining() >= capacity) {
            return;
        }
        byte[] buf = null;
        int off = 0;
        if (null == this.buffer) {
            buf = new byte[Math.max(this.bufsize, capacity)];
            this.buffer = ByteBuffer.wrap(buf);
        } else {
            buf = new byte[Math.max(this.buffer.remaining() + this.bufsize, capacity)];
            ByteBuffer bb = ByteBuffer.wrap(buf);
            off = this.buffer.remaining();
            this.buffer.get(buf, 0, this.buffer.remaining());
            this.buffer = bb;
        }
        this.buffer.position(0);
        try {
            int len = this.stream.read(buf, off, this.buffer.limit());
            if (len > 0) {
                this.offset += (long)len;
            }
            this.buffer.limit(off + (len > 0 ? len : 0));
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public ByteBuffer asByteBuffer() {
        return this.buffer;
    }

    @Override
    public boolean hasRemaining() {
        return this.remaining() > 0L;
    }

    @Override
    public ByteOrder order() {
        return this.buffer.order();
    }

    @Override
    public void order(ByteOrder order) {
        this.buffer.order(order);
    }

    @Override
    public int position() {
        return this.buffer.position();
    }

    @Override
    public void position(int position) {
        throw new RuntimeException("Unimplemented");
    }

    protected void finalize() throws Throwable {
        this.stream.close();
    }

    @Override
    public long remaining() {
        return this.filelen - this.offset + (long)this.buffer.remaining();
    }

    public void close() throws IOException {
        this.stream.close();
    }
}

