/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.continuum.gts;

import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import java.nio.charset.StandardCharsets;

public class DNAUtils {
    public static GeoTimeSerie fromDNA(String dna) {
        GeoTimeSerie gts = new GeoTimeSerie(dna.length());
        long value = 0L;
        for (int i = 0; i < dna.length(); ++i) {
            int codepoint = dna.codePointAt(i);
            switch (codepoint) {
                case 65: 
                case 97: {
                    value += 2L;
                    break;
                }
                case 71: 
                case 103: {
                    ++value;
                    break;
                }
                case 67: 
                case 99: {
                    --value;
                    break;
                }
                case 84: 
                case 116: {
                    value -= 2L;
                    break;
                }
            }
            GTSHelper.setValue(gts, i, value);
        }
        return gts;
    }

    public static String toDNA(GeoTimeSerie gts) {
        if (0 == gts.size() || !GeoTimeSerie.TYPE.LONG.equals((Object)gts.getType())) {
            return "";
        }
        GTSHelper.sort(gts);
        StringBuilder sb = new StringBuilder();
        byte[] seq = new byte[gts.values];
        long value = 0L;
        block6: for (int i = 0; i < gts.values; ++i) {
            int delta = (int)(gts.longValues[i] - value);
            value = gts.longValues[i];
            switch (delta) {
                case 2: {
                    seq[i] = 65;
                    continue block6;
                }
                case 1: {
                    seq[i] = 71;
                    continue block6;
                }
                case -1: {
                    seq[i] = 67;
                    continue block6;
                }
                case -2: {
                    seq[i] = 84;
                    continue block6;
                }
                default: {
                    seq[i] = 46;
                }
            }
        }
        return new String(seq, StandardCharsets.UTF_8);
    }
}

