/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.continuum.gts;

import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.GTSStackFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class DISCORDS
extends GTSStackFunction {
    private static final String WINDOWLEN = "windowlen";
    private static final String WORDLEN = "wordlen";
    private static final String ALPHABETSIZE = "alphabetsize";
    private static final String COUNT = "count";
    private static final String OVERLAP = "overlap";
    private static final String DISTRATIO = "distratio";
    private final boolean standardizePAA;

    public DISCORDS(String name, boolean standardizePAA) {
        super(name);
        this.standardizePAA = standardizePAA;
    }

    @Override
    protected Object gtsOp(Map<String, Object> params, GeoTimeSerie gts) throws WarpScriptException {
        return DISCORDS.discords(gts, (Integer)params.get(WINDOWLEN), (Integer)params.get(WORDLEN), (Integer)params.get(ALPHABETSIZE), (Integer)params.get(COUNT), (Boolean)params.get(OVERLAP), (Double)params.get(DISTRATIO), this.standardizePAA);
    }

    @Override
    protected Map<String, Object> retrieveParameters(WarpScriptStack stack) throws WarpScriptException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        Object dratio = stack.pop();
        if (!(dratio instanceof Double)) {
            throw new WarpScriptException(this.getName() + " expects a double distance ratio.");
        }
        double dr = (Double)dratio;
        if (dr < 0.0) {
            throw new WarpScriptException(this.getName() + " expects a positive distance ratio.");
        }
        params.put(DISTRATIO, dr);
        Object overlap = stack.pop();
        if (!(overlap instanceof Boolean)) {
            throw new WarpScriptException(this.getName() + " expects a boolean flag to indicate tolerance to overlapping.");
        }
        params.put(OVERLAP, (Boolean)overlap);
        Object count = stack.pop();
        if (!(count instanceof Long)) {
            throw new WarpScriptException(this.getName() + " expects an integer discord count.");
        }
        params.put(COUNT, ((Number)count).intValue());
        Object alphabetsize = stack.pop();
        if (!(alphabetsize instanceof Long)) {
            throw new WarpScriptException(this.getName() + " expects an integer quantization scale.");
        }
        int asize = ((Number)alphabetsize).intValue();
        if (0 != (asize & asize - 1) || asize < 2) {
            throw new WarpScriptException(this.getName() + " expects a quantization scale which is a power of 2 greater or equal to 2.");
        }
        params.put(ALPHABETSIZE, asize);
        Object wordlen = stack.pop();
        Object windowlen = stack.pop();
        if (!(wordlen instanceof Long)) {
            throw new WarpScriptException(this.getName() + " expects an integer pattern length.");
        }
        if (!(windowlen instanceof Long)) {
            throw new WarpScriptException(this.getName() + " expects an integer detection window length.");
        }
        int wolen = ((Number)wordlen).intValue();
        int wilen = ((Number)windowlen).intValue();
        if (0 != wilen % wolen) {
            throw new WarpScriptException(this.getName() + " expects pattern length to divide detection window length.");
        }
        params.put(WORDLEN, wolen);
        params.put(WINDOWLEN, wilen);
        return params;
    }

    public static final GeoTimeSerie discords(GeoTimeSerie gts, int windowLen, int wordLen, int alphabetSize, int count, boolean mayOverlap, double distRatio, boolean standardizePAA) throws WarpScriptException {
        GeoTimeSerie symbols = GTSHelper.bSAX(gts, alphabetSize, wordLen, windowLen, standardizePAA);
        final TreeMap locationLists = new TreeMap();
        for (int i = 0; i < symbols.values; ++i) {
            String symbol = GTSHelper.valueAtIndex(symbols, i).toString();
            if (!locationLists.containsKey(symbol)) {
                locationLists.put(symbol, new ArrayList());
            }
            ((List)locationLists.get(symbol)).add(i);
        }
        ArrayList symbolsByOccurrences = new ArrayList();
        symbolsByOccurrences.addAll(locationLists.keySet());
        Object[] rawSymbols = symbolsByOccurrences.toArray(new String[symbolsByOccurrences.size()]);
        Collections.sort(symbolsByOccurrences, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                int n1 = ((List)locationLists.get(o1)).size();
                int n2 = ((List)locationLists.get(o2)).size();
                return n1 - n2;
            }
        });
        TreeMap<String, int[]> locations = new TreeMap<String, int[]>();
        for (Map.Entry symbolAndIlocs : locationLists.entrySet()) {
            String symbol = (String)symbolAndIlocs.getKey();
            List ilocs = (List)symbolAndIlocs.getValue();
            int[] locs = new int[ilocs.size()];
            Collections.sort(ilocs);
            for (int i = 0; i < locs.length; ++i) {
                locs[i] = (Integer)ilocs.get(i);
            }
            locations.put(symbol, locs);
        }
        final class DiscordCandidate {
            final String symbol;
            final int location;
            final double nndist;

            public DiscordCandidate(String symbol, int location, double nndist) {
                this.symbol = symbol;
                this.location = location;
                this.nndist = nndist;
            }

            public String toString() {
                return this.symbol + "@" + this.location + ":" + this.nndist;
            }
        }
        ArrayList<DiscordCandidate> discords = new ArrayList<DiscordCandidate>();
        double worstNNDist = 0.0;
        for (String symbol : symbolsByOccurrences) {
            int[] symbolLocations = (int[])locations.get(symbol);
            if (discords.size() >= count && symbolLocations.length > count + windowLen) break;
            int size = symbolLocations.length;
            for (int i = 0; i < size; ++i) {
                int k;
                double dist;
                int j;
                int[] symbolLocations2;
                int idx2;
                double nndist = Double.POSITIVE_INFINITY;
                for (int j2 = 0; j2 < size; ++j2) {
                    if (Math.abs(symbolLocations[i] - symbolLocations[j2]) < windowLen) continue;
                    double dist2 = 0.0;
                    for (int k2 = 0; k2 < windowLen; ++k2) {
                        dist2 += Math.pow(((Number)GTSHelper.valueAtIndex(gts, symbolLocations[i] + k2)).doubleValue() - ((Number)GTSHelper.valueAtIndex(gts, symbolLocations[j2] + k2)).doubleValue(), 2.0);
                    }
                    if (dist2 < nndist) {
                        nndist = dist2;
                    }
                    if (discords.size() == count && nndist < worstNNDist) break;
                }
                if (discords.size() == count && nndist < worstNNDist) continue;
                int idx = Arrays.binarySearch(rawSymbols, symbol);
                for (idx2 = idx - 1; idx2 >= 0; --idx2) {
                    symbolLocations2 = (int[])locations.get(rawSymbols[idx2]);
                    for (j = 0; j < symbolLocations2.length; ++j) {
                        if (Math.abs(symbolLocations[i] - symbolLocations2[j]) < windowLen) continue;
                        dist = 0.0;
                        for (k = 0; k < windowLen; ++k) {
                            dist += Math.pow(((Number)GTSHelper.valueAtIndex(gts, symbolLocations[i] + k)).doubleValue() - ((Number)GTSHelper.valueAtIndex(gts, symbolLocations2[j] + k)).doubleValue(), 2.0);
                        }
                        if (dist < nndist) {
                            nndist = dist;
                        }
                        if (discords.size() == count && nndist < worstNNDist) break;
                    }
                    if (Double.POSITIVE_INFINITY != nndist) break;
                }
                if (discords.size() == count && nndist < worstNNDist) continue;
                for (idx2 = rawSymbols.length + 1; idx2 < rawSymbols.length; ++idx2) {
                    symbolLocations2 = (int[])locations.get(rawSymbols[idx2]);
                    for (j = 0; j < symbolLocations2.length; ++j) {
                        if (Math.abs(symbolLocations[i] - symbolLocations2[j]) < windowLen) continue;
                        dist = 0.0;
                        for (k = 0; k < windowLen; ++k) {
                            dist += Math.pow(((Number)GTSHelper.valueAtIndex(gts, symbolLocations[i] + k)).doubleValue() - ((Number)GTSHelper.valueAtIndex(gts, symbolLocations2[j] + k)).doubleValue(), 2.0);
                        }
                        if (dist < nndist) {
                            nndist = dist;
                        }
                        if (discords.size() == count && nndist < worstNNDist) break;
                    }
                    if (Double.POSITIVE_INFINITY != nndist) break;
                }
                if (discords.size() == count && nndist < worstNNDist) continue;
                DiscordCandidate candidate = new DiscordCandidate(symbol, symbolLocations[i], nndist);
                discords.add(candidate);
                Collections.sort(discords, new Comparator<DiscordCandidate>(){

                    @Override
                    public int compare(DiscordCandidate o1, DiscordCandidate o2) {
                        return (int)Math.signum(o2.nndist - o1.nndist);
                    }
                });
                if (!mayOverlap) {
                    for (int h = discords.size() - 1; h > 0; --h) {
                        if (Math.abs(((DiscordCandidate)discords.get((int)h)).location - ((DiscordCandidate)discords.get((int)(h - 1))).location) >= windowLen) continue;
                        discords.remove(h);
                        --h;
                    }
                }
                while (discords.size() > count) {
                    discords.remove(count);
                }
                if (0.0 != distRatio) {
                    while (discords.size() > 1) {
                        if (!(((DiscordCandidate)discords.get((int)(discords.size() - 1))).nndist * distRatio < ((DiscordCandidate)discords.get((int)0)).nndist)) continue;
                        discords.remove(discords.size() - 1);
                    }
                }
                worstNNDist = ((DiscordCandidate)discords.get((int)(discords.size() - 1))).nndist;
            }
        }
        GeoTimeSerie discordsGTS = gts.cloneEmpty();
        for (DiscordCandidate discord : discords) {
            for (int i = 0; i < windowLen; ++i) {
                GTSHelper.setValue(discordsGTS, GTSHelper.tickAtIndex(gts, discord.location + i), GTSHelper.locationAtIndex(gts, discord.location + i), GTSHelper.elevationAtIndex(gts, discord.location + i), GTSHelper.valueAtIndex(gts, discord.location + i), false);
            }
        }
        return GTSHelper.dedup(discordsGTS);
    }
}

