//
//   Copyright 2018  SenX S.A.S.
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.
//

package io.warp10.script.fwt.wavelets;

import io.warp10.script.fwt.Wavelet;

public class Wavelet_db20 extends Wavelet {

  private static final int transformWavelength = 2;

  private static final double[] scalingDeComposition = new double[] { -2.998836489615753e-10, 4.05612705554717e-09, -1.814843248297622e-08, 2.0143220235374613e-10, 2.633924226266962e-07, -6.847079596993149e-07, -1.0119940100181473e-06, 7.241248287663791e-06, -4.376143862182197e-06, -3.710586183390615e-05, 6.774280828373048e-05, 0.00010153288973669777, -0.0003851047486990061, -5.349759844340453e-05, 0.0013925596193045254, -0.0008315621728772474, -0.003581494259744107, 0.00442054238676635, 0.0067216273018096935, -0.013810526137727442, -0.008789324924555765, 0.03229429953011916, 0.0058746818113949465, -0.061722899624668884, 0.005632246857685454, 0.10229171917513397, -0.024716827337521424, -0.1554587507060453, 0.039850246458519104, 0.22829105082013823, -0.016727088308801888, -0.3267868004335376, -0.13921208801128787, 0.36150229873889705, 0.6104932389378558, 0.4726961853103315, 0.21994211355113222, 0.06342378045900529, 0.010549394624937735, 0.0007799536136659112,  };
  private static final double[] waveletDeComposition = new double[] { -0.0007799536136659112, 0.010549394624937735, -0.06342378045900529, 0.21994211355113222, -0.4726961853103315, 0.6104932389378558, -0.36150229873889705, -0.13921208801128787, 0.3267868004335376, -0.016727088308801888, -0.22829105082013823, 0.039850246458519104, 0.1554587507060453, -0.024716827337521424, -0.10229171917513397, 0.005632246857685454, 0.061722899624668884, 0.0058746818113949465, -0.03229429953011916, -0.008789324924555765, 0.013810526137727442, 0.0067216273018096935, -0.00442054238676635, -0.003581494259744107, 0.0008315621728772474, 0.0013925596193045254, 5.349759844340453e-05, -0.0003851047486990061, -0.00010153288973669777, 6.774280828373048e-05, 3.710586183390615e-05, -4.376143862182197e-06, -7.241248287663791e-06, -1.0119940100181473e-06, 6.847079596993149e-07, 2.633924226266962e-07, -2.0143220235374613e-10, -1.814843248297622e-08, -4.05612705554717e-09, -2.998836489615753e-10,  };

  private static final double[] scalingReConstruction = new double[] { 0.0007799536136659112, 0.010549394624937735, 0.06342378045900529, 0.21994211355113222, 0.4726961853103315, 0.6104932389378558, 0.36150229873889705, -0.13921208801128787, -0.3267868004335376, -0.016727088308801888, 0.22829105082013823, 0.039850246458519104, -0.1554587507060453, -0.024716827337521424, 0.10229171917513397, 0.005632246857685454, -0.061722899624668884, 0.0058746818113949465, 0.03229429953011916, -0.008789324924555765, -0.013810526137727442, 0.0067216273018096935, 0.00442054238676635, -0.003581494259744107, -0.0008315621728772474, 0.0013925596193045254, -5.349759844340453e-05, -0.0003851047486990061, 0.00010153288973669777, 6.774280828373048e-05, -3.710586183390615e-05, -4.376143862182197e-06, 7.241248287663791e-06, -1.0119940100181473e-06, -6.847079596993149e-07, 2.633924226266962e-07, 2.0143220235374613e-10, -1.814843248297622e-08, 4.05612705554717e-09, -2.998836489615753e-10,  };
  private static final double[] waveletReConstruction = new double[] { -2.998836489615753e-10, -4.05612705554717e-09, -1.814843248297622e-08, -2.0143220235374613e-10, 2.633924226266962e-07, 6.847079596993149e-07, -1.0119940100181473e-06, -7.241248287663791e-06, -4.376143862182197e-06, 3.710586183390615e-05, 6.774280828373048e-05, -0.00010153288973669777, -0.0003851047486990061, 5.349759844340453e-05, 0.0013925596193045254, 0.0008315621728772474, -0.003581494259744107, -0.00442054238676635, 0.0067216273018096935, 0.013810526137727442, -0.008789324924555765, -0.03229429953011916, 0.0058746818113949465, 0.061722899624668884, 0.005632246857685454, -0.10229171917513397, -0.024716827337521424, 0.1554587507060453, 0.039850246458519104, -0.22829105082013823, -0.016727088308801888, 0.3267868004335376, -0.13921208801128787, -0.36150229873889705, 0.6104932389378558, -0.4726961853103315, 0.21994211355113222, -0.06342378045900529, 0.010549394624937735, -0.0007799536136659112,  };

  static {
    //
    // Reverse the arrays as we do convolutions
    //
    reverse(scalingDeComposition);
    reverse(waveletDeComposition);
  }

  private static final void reverse(double[] array) {
    int i = 0;
    int j = array.length - 1;
    
    while (i < j) {
      double tmp = array[i];
      array[i] = array[j];
      array[j] = tmp;
      i++;
      j--;
    }
  }

  public int getTransformWavelength() {
    return transformWavelength;
  }

  public int getMotherWavelength() {
    return waveletReConstruction.length;
  }

  public double[] getScalingDeComposition() {
    return scalingDeComposition;
  }

  public double[] getWaveletDeComposition() {
    return waveletDeComposition;
  }

  public double[] getScalingReConstruction() {
    return scalingReConstruction;
  }

  public double[] getWaveletReConstruction() {
    return waveletReConstruction;
  }
}

