/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.warp.sdk;

import io.warp10.continuum.Tokens;
import io.warp10.quasar.token.thrift.data.ReadToken;
import io.warp10.quasar.token.thrift.data.WriteToken;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Capabilities {
    protected Map<String, String> capabilities = new HashMap<String, String>();

    public static String get(WarpScriptStack stack, String name) {
        Capabilities capabilities = null;
        if (stack.getAttribute("stack.capabilities") instanceof Capabilities) {
            capabilities = (Capabilities)stack.getAttribute("stack.capabilities");
        }
        if (null != capabilities) {
            return capabilities.capabilities.get(name);
        }
        return null;
    }

    public static Map<String, String> get(WarpScriptStack stack, List<Object> names) {
        Capabilities capabilities = null;
        if (stack.getAttribute("stack.capabilities") instanceof Capabilities) {
            capabilities = (Capabilities)stack.getAttribute("stack.capabilities");
        }
        LinkedHashMap<String, String> caps = new LinkedHashMap<String, String>();
        if (null != capabilities) {
            if (null == names) {
                caps.putAll(capabilities.capabilities);
            } else {
                for (Object elt : names) {
                    if (!(elt instanceof String)) continue;
                    caps.put((String)elt, capabilities.capabilities.get((String)elt));
                }
            }
        }
        return caps;
    }

    public static void add(WarpScriptStack stack, String token) throws WarpScriptException {
        Map<String, String> attributes = null;
        try {
            ReadToken rtoken = Tokens.extractReadToken(token);
            attributes = rtoken.getAttributes();
        }
        catch (Exception e) {
            try {
                WriteToken wtoken = Tokens.extractWriteToken(token);
                attributes = wtoken.getAttributes();
            }
            catch (Exception ee) {
                throw new WarpScriptException("invalid token.");
            }
        }
        if (null != attributes && !attributes.isEmpty()) {
            Capabilities capabilities = null;
            if (stack.getAttribute("stack.capabilities") instanceof Capabilities) {
                capabilities = (Capabilities)stack.getAttribute("stack.capabilities");
            }
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                if (!entry.getKey().startsWith(".cap:")) continue;
                if (null == capabilities) {
                    capabilities = new Capabilities();
                    stack.setAttribute("stack.capabilities", capabilities);
                }
                capabilities.putIfAbsent(entry.getKey().substring(".cap:".length()), entry.getValue());
            }
        }
    }

    public void clear() {
        this.capabilities.clear();
    }

    public boolean containsKey(String key) {
        return this.capabilities.containsKey(key);
    }

    public Object remove(String key) {
        return this.capabilities.remove(key);
    }

    public Object putIfAbsent(String key, String value) {
        return this.capabilities.putIfAbsent(key, value);
    }
}

