/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.processing.typography;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.processing.ProcessingUtil;
import java.util.List;
import processing.core.PGraphics;

public class PtextAlign
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public PtextAlign(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        List<Object> params = ProcessingUtil.parseParams(stack, 1, 2);
        PGraphics pg = (PGraphics)params.get(0);
        String alignXstr = params.get(1).toString();
        int alignX = 0;
        if ("LEFT".equals(alignXstr)) {
            alignX = 37;
        } else if ("RIGHT".equals(alignXstr)) {
            alignX = 39;
        } else if ("CENTER".equals(alignXstr)) {
            alignX = 3;
        } else {
            throw new WarpScriptException(this.getName() + " invalid alignment for X, should be 'LEFT', 'RIGHT' or 'CENTER'.");
        }
        if (2 == params.size()) {
            pg.parent.textAlign(alignX);
        } else if (3 == params.size()) {
            String alignYstr = params.get(2).toString();
            int alignY = 0;
            if ("TOP".equals(alignYstr)) {
                alignY = 101;
            } else if ("BOTTOM".equals(alignYstr)) {
                alignY = 102;
            } else if ("CENTER".equals(alignYstr)) {
                alignY = 3;
            } else if ("BASELINE".equals(alignYstr)) {
                alignY = 0;
            } else {
                throw new WarpScriptException(this.getName() + " invalid alignment for Y, should be 'TOP', 'BOTTOM', 'CENTER' or 'BASELINE'.");
            }
            pg.parent.textAlign(alignX, alignY);
        }
        stack.push(pg);
        return stack;
    }
}

