/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.mapper;

import io.warp10.crypto.OrderPreservingBase64;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.SAXUtils;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptMapperFunction;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;

public class MapperbSAX
extends NamedWarpScriptFunction
implements WarpScriptMapperFunction {
    private static final int MAX_WORDLEN = 256;
    private final int wordlen;
    private final int step;
    private final int levels;

    public MapperbSAX(String name, int alphabetSize, int wordlen, int step) throws WarpScriptException {
        super(name);
        if (wordlen < 2 || wordlen > 256) {
            throw new WarpScriptException("Word length must be between 2 and 256");
        }
        this.wordlen = wordlen;
        this.step = step;
        int levels = 1;
        if (0 == alphabetSize) {
            throw new WarpScriptException("Alphabet size MUST be a power of two.");
        }
        while (0 == (alphabetSize & 1)) {
            ++levels;
            alphabetSize >>>= 1;
        }
        if (0 != alphabetSize) {
            throw new WarpScriptException("Alphabet size MUST be a power of two.");
        }
        if (levels < 2 || levels > 16) {
            throw new WarpScriptException("Alphabet size MUST be a power of two between 2 and 2^16");
        }
        this.levels = levels;
    }

    @Override
    public Object apply(Object[] args) throws WarpScriptException {
        long tick = (Long)args[0];
        long[] locations = (long[])args[4];
        long[] elevations = (long[])args[5];
        Object[] values = (Object[])args[6];
        if (0 == values.length) {
            return new Object[]{0L, 91480763316633925L, Long.MIN_VALUE, null};
        }
        int[] symbols = new int[this.wordlen];
        for (int i = 0; i < this.wordlen; ++i) {
            symbols[i] = i * this.step < values.length ? ((Number)values[i]).intValue() : symbols[i - 1];
        }
        byte[] word = SAXUtils.bSAX(this.levels, symbols);
        return new Object[]{tick, locations[0], elevations[0], new String(OrderPreservingBase64.encode(word))};
    }

    public static class Builder
    extends NamedWarpScriptFunction
    implements WarpScriptStackFunction {
        public Builder(String name) {
            super(name);
        }

        @Override
        public Object apply(WarpScriptStack stack) throws WarpScriptException {
            Object a = stack.pop();
            Object w = stack.pop();
            Object k = stack.pop();
            if (!(a instanceof Number && w instanceof Number && k instanceof Number)) {
                throw new WarpScriptException("Invalid parameters for " + this.getName());
            }
            stack.push(new MapperbSAX(this.getName(), ((Number)a).intValue(), ((Number)w).intValue(), ((Number)k).intValue()));
            return stack;
        }
    }
}

