/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.mapper;

import com.geoxp.GeoXPLib;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.StackUtils;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptMapperFunction;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.functions.GEOPACK;

public class MapperGeoFence
extends NamedWarpScriptFunction
implements WarpScriptMapperFunction {
    private final GeoXPLib.GeoXPShape shape;

    public MapperGeoFence(String name, GeoXPLib.GeoXPShape shape) {
        super(name);
        this.shape = shape;
    }

    @Override
    public Object apply(Object[] args) throws WarpScriptException {
        long tick = (Long)args[0];
        long[] locations = (long[])args[4];
        long[] elevations = (long[])args[5];
        Object[] values = (Object[])args[6];
        if (values.length < 1) {
            return new Object[]{tick, 91480763316633925L, Long.MIN_VALUE, null};
        }
        long location = locations[0];
        long elevation = elevations[0];
        if (91480763316633925L != location) {
            return new Object[]{tick, location, elevation, GeoXPLib.isGeoXPPointInGeoXPShape((long)location, (GeoXPLib.GeoXPShape)this.shape)};
        }
        return new Object[]{tick, location, elevation, null};
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        try {
            sb.append(StackUtils.toString(GEOPACK.pack(this.shape)));
        }
        catch (WarpScriptException wse) {
            throw new RuntimeException(wse);
        }
        sb.append(" ");
        sb.append("GEOUNPACK");
        sb.append(" ");
        sb.append(this.getName());
        return sb.toString();
    }

    public static class Builder
    extends NamedWarpScriptFunction
    implements WarpScriptStackFunction {
        public Builder(String name) {
            super(name);
        }

        @Override
        public Object apply(WarpScriptStack stack) throws WarpScriptException {
            Object shape = stack.pop();
            if (!(shape instanceof GeoXPLib.GeoXPShape)) {
                throw new WarpScriptException(this.getName() + " expects a Geo Shape.");
            }
            stack.push(new MapperGeoFence(this.getName(), (GeoXPLib.GeoXPShape)shape));
            return stack;
        }
    }
}

