/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.gts.GTSEncoder;
import io.warp10.continuum.gts.GTSWrapperHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.continuum.store.thrift.data.GTSWrapper;
import io.warp10.crypto.OrderPreservingBase64;
import io.warp10.script.ElementOrListStackFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import java.nio.charset.StandardCharsets;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;

public class WRAP
extends ElementOrListStackFunction {
    private final boolean opt;
    private final boolean compress;
    private final boolean raw;
    private final boolean mv;
    private final ElementOrListStackFunction.ElementStackFunction function;

    public WRAP(String name) {
        this(name, false, true, false, false);
    }

    public WRAP(String name, boolean opt) {
        this(name, opt, true, false, false);
    }

    public WRAP(String name, boolean opt, boolean compress) {
        this(name, opt, compress, false, false);
    }

    public WRAP(String name, boolean opt, boolean compress, boolean raw) {
        this(name, opt, compress, raw, false);
    }

    public WRAP(String name, boolean opt, boolean compress, boolean raw, boolean mv) {
        super(name);
        this.opt = opt;
        this.compress = compress;
        this.raw = raw;
        this.mv = mv;
        this.function = this.generateFunctionOnce();
    }

    private ElementOrListStackFunction.ElementStackFunction generateFunctionOnce() {
        return new ElementOrListStackFunction.ElementStackFunction(){

            @Override
            public Object applyOnElement(Object element) throws WarpScriptException {
                GTSWrapper wrapper;
                if (element instanceof GeoTimeSerie) {
                    wrapper = WRAP.this.opt ? GTSWrapperHelper.fromGTSToGTSWrapper((GeoTimeSerie)element, WRAP.this.compress, 1.0, true) : GTSWrapperHelper.fromGTSToGTSWrapper((GeoTimeSerie)element, WRAP.this.compress);
                } else if (element instanceof GTSEncoder) {
                    wrapper = WRAP.this.opt ? GTSWrapperHelper.fromGTSEncoderToGTSWrapper((GTSEncoder)element, WRAP.this.compress, 1.0) : GTSWrapperHelper.fromGTSEncoderToGTSWrapper((GTSEncoder)element, WRAP.this.compress);
                } else {
                    throw new WarpScriptException(WRAP.this.getName() + " expects a Geo Time Series, a GTSEncoder or a list thereof.");
                }
                if (WRAP.this.mv) {
                    wrapper.unsetMetadata();
                    wrapper.unsetCount();
                }
                TSerializer serializer = new TSerializer((TProtocolFactory)new TCompactProtocol.Factory());
                try {
                    byte[] bytes = serializer.serialize((TBase)wrapper);
                    if (WRAP.this.raw) {
                        return bytes;
                    }
                    return new String(OrderPreservingBase64.encode(bytes), StandardCharsets.US_ASCII);
                }
                catch (TException te) {
                    throw new WarpScriptException(WRAP.this.getName() + " failed to wrap GTS.", te);
                }
            }
        };
    }

    @Override
    public ElementOrListStackFunction.ElementStackFunction generateFunction(WarpScriptStack stack) throws WarpScriptException {
        return this.function;
    }
}

