/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.KafkaWebCallService;
import io.warp10.continuum.Tokens;
import io.warp10.quasar.token.thrift.data.WriteToken;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.thrift.data.WebCallMethod;
import io.warp10.script.thrift.data.WebCallRequest;
import io.warp10.standalone.StandaloneWebCallService;
import io.warp10.standalone.Warp;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;

public class WEBCALL
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public WEBCALL(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        WebCallRequest request = new WebCallRequest();
        request.setTimestamp(System.currentTimeMillis());
        request.setStackUUID(stack.getUUID());
        request.setWebCallUUID(UUID.randomUUID().toString());
        Object body = stack.pop();
        if (!(body instanceof String)) {
            throw new WarpScriptException(this.getName() + " expects a request body as a possibly empty string on top of the stack.");
        }
        request.setBody(body.toString());
        Object headers = stack.pop();
        if (!(headers instanceof Map)) {
            throw new WarpScriptException(this.getName() + " expects a map of header names to header values as second level of the stack.");
        }
        for (Map.Entry entry : ((Map)headers).entrySet()) {
            request.putToHeaders(entry.getKey().toString(), entry.getValue().toString());
        }
        Object url = stack.pop();
        if (!(url instanceof String)) {
            throw new WarpScriptException(this.getName() + " expects a URL below the headers map.");
        }
        try {
            if (!StandaloneWebCallService.getWebAccessController().checkURL(new URL(url.toString()))) {
                throw new WarpScriptException(this.getName() + " invalid host or scheme in URL.");
            }
        }
        catch (MalformedURLException mue) {
            throw new WarpScriptException(this.getName() + " invalid URL.", mue);
        }
        request.setUrl(url.toString());
        Object method = stack.pop();
        if ("GET".equals(method)) {
            request.setMethod(WebCallMethod.GET);
        } else if ("POST".equals(method)) {
            request.setMethod(WebCallMethod.POST);
        } else {
            throw new WarpScriptException(this.getName() + " given invalid method. Can be one of 'GET' or 'POST'.");
        }
        Object token = stack.pop();
        if (!(token instanceof String)) {
            throw new WarpScriptException(this.getName() + " expects a token below the URL.");
        }
        request.setToken(token.toString());
        WriteToken wtoken = Tokens.extractWriteToken(request.getToken());
        if (Warp.isStandaloneMode()) {
            if (!StandaloneWebCallService.offer((WebCallRequest)request)) {
                throw new WarpScriptException(this.getName() + " is unable to forward WebCall request.");
            }
            stack.push(request.getWebCallUUID());
        } else {
            if (!KafkaWebCallService.offer((WebCallRequest)request)) {
                throw new WarpScriptException(this.getName() + " unable to forward WebCall request.");
            }
            stack.push(request.getWebCallUUID());
        }
        AtomicLong remaining = (AtomicLong)stack.getAttribute("stack.maxwebcalls");
        if (0L > remaining.get()) {
            throw new WarpScriptException(this.getName() + " reached the maximum number of invocations.");
        }
        remaining.decrementAndGet();
        return stack;
    }
}

