/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SORTBY
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public SORTBY(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof WarpScriptStack.Macro)) {
            throw new WarpScriptException(this.getName() + " expects a macro on top of the stack.");
        }
        WarpScriptStack.Macro macro = (WarpScriptStack.Macro)top;
        top = stack.pop();
        if (top instanceof List) {
            List list = (List)top;
            Comparator comparator = this.buildComparator(stack, list, macro);
            ArrayList<Integer> indices = new ArrayList<Integer>(list.size());
            for (int i = 0; i < list.size(); ++i) {
                indices.add(i);
            }
            Collections.sort(indices, comparator);
            Object[] target = new Object[indices.size()];
            for (int i = 0; i < target.length; ++i) {
                target[i] = list.get((Integer)indices.get(i));
            }
            list.clear();
            for (Object elt : target) {
                list.add(elt);
            }
            stack.push(list);
        } else if (top instanceof LinkedHashMap) {
            LinkedHashMap linkedHashMap = (LinkedHashMap)top;
            ArrayList entryList = new ArrayList(linkedHashMap.entrySet());
            Comparator comparator = this.buildComparator(stack, entryList, macro);
            ArrayList<Integer> indices = new ArrayList<Integer>(linkedHashMap.size());
            for (int i = 0; i < linkedHashMap.size(); ++i) {
                indices.add(i);
            }
            Collections.sort(indices, comparator);
            Map.Entry[] target = new Map.Entry[indices.size()];
            for (int i = 0; i < target.length; ++i) {
                target[i] = entryList.get((Integer)indices.get(i));
            }
            linkedHashMap.clear();
            for (Map.Entry entry : target) {
                linkedHashMap.put(entry.getKey(), entry.getValue());
            }
            stack.push(linkedHashMap);
        } else {
            throw new WarpScriptException(this.getName() + " operates on a list or a map created by {} or ->MAP.");
        }
        return stack;
    }

    private Comparator buildComparator(WarpScriptStack stack, Collection collection, WarpScriptStack.Macro macro) throws WarpScriptException {
        String type = null;
        Object[] values = null;
        int idx = 0;
        for (Object elt : collection) {
            if (elt instanceof Map.Entry) {
                stack.push(((Map.Entry)elt).getKey());
                stack.push(((Map.Entry)elt).getValue());
            } else {
                stack.push(elt);
            }
            stack.exec(macro);
            Object value = stack.pop();
            String valtype = null;
            if (value instanceof Long) {
                valtype = "LONG";
            } else if (value instanceof Double) {
                valtype = "DOUBLE";
            } else if (value instanceof String) {
                valtype = "STRING";
            }
            if (null == value || null == valtype || null != type && !type.equals(valtype)) {
                throw new WarpScriptException(this.getName() + " expects its macro to return a non null double, long or string in a consistent manner.");
            }
            if (null == type) {
                switch (valtype) {
                    case "LONG": {
                        values = new long[collection.size()];
                        break;
                    }
                    case "DOUBLE": {
                        values = new double[collection.size()];
                        break;
                    }
                    case "STRING": {
                        values = new String[collection.size()];
                    }
                }
                type = valtype;
            }
            switch (type) {
                case "LONG": {
                    ((long[])values)[idx] = ((Number)value).longValue();
                    break;
                }
                case "DOUBLE": {
                    ((double[])values)[idx] = ((Number)value).doubleValue();
                    break;
                }
                case "STRING": {
                    ((String[])values)[idx] = value.toString();
                }
            }
            ++idx;
        }
        String valtype = type;
        Comparator<Integer> comparator = null;
        if ("LONG".equals(valtype)) {
            final long[] lvalues = values;
            comparator = new Comparator<Integer>(){

                @Override
                public int compare(Integer i1, Integer i2) {
                    return Long.compare(lvalues[i1], lvalues[i2]);
                }
            };
        } else if ("DOUBLE".equals(valtype)) {
            final double[] dvalues = values;
            comparator = new Comparator<Integer>(){

                @Override
                public int compare(Integer i1, Integer i2) {
                    return Double.compare(dvalues[i1], dvalues[i2]);
                }
            };
        } else if ("STRING".equals(valtype)) {
            final String[] svalues = (String[])values;
            comparator = new Comparator<Integer>(){

                @Override
                public int compare(Integer i1, Integer i2) {
                    return svalues[i1].compareTo(svalues[i2]);
                }
            };
        }
        return comparator;
    }
}

