/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.math3.fitting.PolynomialCurveFitter;
import org.apache.commons.math3.fitting.WeightedObservedPoints;

public class POLYFIT
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public POLYFIT(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        boolean useBucketId = false;
        if (top instanceof Boolean) {
            useBucketId = Boolean.TRUE.equals(top);
            top = stack.pop();
        }
        if (!(top instanceof Long)) {
            throw new WarpScriptException(this.getName() + " expects a polynomial degree on top if the stack.");
        }
        PolynomialCurveFitter fitter = PolynomialCurveFitter.create((int)((Number)top).intValue());
        top = stack.pop();
        if (!(top instanceof GeoTimeSerie)) {
            throw new WarpScriptException(this.getName() + " expects a Geo Time Series below the degree of the polynomial.");
        }
        GeoTimeSerie gts = (GeoTimeSerie)top;
        int n = GTSHelper.nvalues(gts);
        if (0 == n) {
            throw new WarpScriptException(this.getName() + " operates on a non empty Geo Time Series.");
        }
        if (useBucketId && !GTSHelper.isBucketized(gts)) {
            throw new WarpScriptException(this.getName() + " use of bucket id is only possible for bucketized Geo Time Series.");
        }
        if (GeoTimeSerie.TYPE.LONG != gts.getType() && GeoTimeSerie.TYPE.DOUBLE != gts.getType()) {
            throw new WarpScriptException(this.getName() + " can only operate on numerical Geo Time Series.");
        }
        long firsttick = GTSHelper.firsttick(gts);
        long bucketspan = GTSHelper.getBucketSpan(gts);
        WeightedObservedPoints points = new WeightedObservedPoints();
        for (int i = 0; i < n; ++i) {
            Object value = GTSHelper.valueAtIndex(gts, i);
            long tick = GTSHelper.tickAtIndex(gts, i);
            if (useBucketId) {
                int bucket = (int)((tick - firsttick) / bucketspan);
                points.add((double)bucket, ((Number)value).doubleValue());
                continue;
            }
            points.add((double)tick, ((Number)value).doubleValue());
        }
        fitter.withMaxIterations(n * 2);
        double[] coeffs = fitter.fit((Collection)points.toList());
        ArrayList<Double> lcoeffs = new ArrayList<Double>(coeffs.length);
        double[] dArray = coeffs;
        int n2 = dArray.length;
        for (int i = 0; i < n2; ++i) {
            Double coeff = dArray[i];
            lcoeffs.add(coeff);
        }
        stack.push(lcoeffs);
        return stack;
    }
}

