/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

public class PACK
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public PACK(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object o = stack.pop();
        if (!(o instanceof String)) {
            throw new WarpScriptException(this.getName() + " expects a format string on top of the stack.");
        }
        String fmt = o.toString();
        o = stack.pop();
        if (!(o instanceof List)) {
            throw new WarpScriptException(this.getName() + " operates on a list of numeric or boolean values.");
        }
        List values = (List)o;
        for (Object value : values) {
            if (value instanceof Number || value instanceof Boolean) continue;
            throw new WarpScriptException(this.getName() + " operates on a list of numeric or boolean values.");
        }
        BitSet bigendians = new BitSet();
        ArrayList<Character> types = new ArrayList<Character>();
        ArrayList<Integer> lengths = new ArrayList<Integer>();
        int totalbits = PACK.parseFormat(this, fmt, bigendians, types, lengths);
        ByteArrayOutputStream baos = new ByteArrayOutputStream((totalbits + 7) / 8);
        int nbits = 0;
        int vidx = 0;
        long curbyte = 0L;
        for (int i = 0; i < types.size(); ++i) {
            int len = (Integer)lengths.get(i);
            long value = 0L;
            if ('s' == ((Character)types.get(i)).charValue()) {
                value = 0L;
            } else if ('S' == ((Character)types.get(i)).charValue()) {
                value = -1L;
            } else {
                Object v;
                if ((v = values.get(vidx++)) instanceof Boolean) {
                    v = Boolean.TRUE.equals(v) ? Long.valueOf(1L) : Long.valueOf(0L);
                }
                if ('D' == ((Character)types.get(i)).charValue()) {
                    value = Double.doubleToRawLongBits(((Number)v).doubleValue());
                } else if ('L' == ((Character)types.get(i)).charValue() || 'U' == ((Character)types.get(i)).charValue()) {
                    value = ((Number)v).longValue();
                } else if ('B' == ((Character)types.get(i)).charValue()) {
                    long l = value = 0L != ((Number)v).longValue() ? 1L : 0L;
                }
            }
            if (bigendians.get(i)) {
                value = Long.reverse(value);
                if (len < 64) {
                    value >>>= 64 - len;
                }
            }
            for (int k = 0; k < len; ++k) {
                curbyte <<= 1;
                curbyte |= value & 1L;
                value >>= 1;
                if (0 != ++nbits % 8) continue;
                baos.write((int)(curbyte & 0xFFL));
                curbyte = 0L;
            }
        }
        if (0 != nbits % 8) {
            baos.write((int)((curbyte <<= 8 - nbits % 8) & 0xFFL));
        }
        stack.push(baos.toByteArray());
        return stack;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int parseFormat(NamedWarpScriptFunction function, String format, BitSet bigendians, List<Character> types, List<Integer> lengths) throws WarpScriptException {
        int idx = 0;
        int totalbits = 0;
        while (idx < format.length()) {
            boolean isBigendian = false;
            char type = format.charAt(idx++);
            int len = 0;
            if ('<' == type || '>' == type) {
                if (idx >= format.length()) {
                    throw new WarpScriptException(function.getName() + " encountered an invalid format specification.");
                }
                isBigendian = '>' == type;
                if ('L' == (type = format.charAt(idx++)) || 'U' == type) {
                    while (idx < format.length() && format.charAt(idx) <= '9' && format.charAt(idx) >= '0') {
                        len *= 10;
                        len += format.charAt(idx++) - 48;
                    }
                    if (0 == len) {
                        len = 64;
                    } else if (len > 64) {
                        throw new WarpScriptException(function.getName() + " encountered an invalid length for 'L', max length is 64.");
                    }
                } else {
                    if ('D' != type) throw new WarpScriptException(function.getName() + " encountered an invalid format specification '" + type + "'.");
                    len = 64;
                }
            } else if ('S' == type || 's' == type) {
                while (idx < format.length() && format.charAt(idx) <= '9' && format.charAt(idx) >= '0') {
                    len *= 10;
                    len += format.charAt(idx++) - 48;
                }
                if (0 == len) {
                    throw new WarpScriptException(function.getName() + " encountered an invalid Skip specification, length must be a strictly positive number.");
                }
            } else {
                if ('B' != type) throw new WarpScriptException(function.getName() + " encountered an invalid format specification '" + type + "'.");
                len = 1;
            }
            bigendians.set(types.size(), isBigendian);
            types.add(Character.valueOf(type));
            lengths.add(len);
            totalbits += len;
        }
        return totalbits;
    }
}

