/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;

public class NPDF
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private static final double TWOPISQRT = 1.0 / Math.sqrt(Math.PI * 2);
    private final double mu;
    private final double sigma;

    public NPDF(String name, double mu, double sigma) {
        super(name);
        this.mu = mu;
        this.sigma = sigma;
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object o = stack.pop();
        if (!(o instanceof Number)) {
            throw new WarpScriptException(this.getName() + " expects a numeric value on top of the stack.");
        }
        double x = ((Number)o).doubleValue();
        double p = TWOPISQRT / this.sigma * Math.exp(-1.0 / (2.0 * this.sigma * this.sigma) * Math.pow(x - this.mu, 2.0));
        stack.push(p);
        return stack;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.mu);
        sb.append(" ");
        sb.append(this.sigma);
        sb.append(" ");
        sb.append(this.getName());
        return sb.toString();
    }

    public static class Builder
    extends NamedWarpScriptFunction
    implements WarpScriptStackFunction {
        public Builder(String name) {
            super(name);
        }

        @Override
        public Object apply(WarpScriptStack stack) throws WarpScriptException {
            Object value = stack.pop();
            if (!(value instanceof Number) || 0.0 >= ((Number)value).doubleValue()) {
                throw new WarpScriptException(this.getName() + " expects a standard deviation (sigma) on top of the stack.");
            }
            double sigma = ((Number)value).doubleValue();
            value = stack.pop();
            if (!(value instanceof Number)) {
                throw new WarpScriptException(this.getName() + " expects a mean (mu) below the standard deviation.");
            }
            double mu = ((Number)value).doubleValue();
            stack.push(new NPDF(this.getName(), mu, sigma));
            return stack;
        }
    }
}

