/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.GTSStackFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import java.util.HashMap;
import java.util.Map;

public class FFTWINDOW
extends GTSStackFunction {
    private static final String WINDOWING_ALGORITHM = "win.alg";
    private static final String WINDOW_TRIANGULAR = "triangular";
    private static final String WINDOW_PARZEN = "parzen";
    private static final String WINDOW_WELCH = "welch";
    private static final String WINDOW_SINE = "sine";
    private static final String WINDOW_HANN = "hann";
    private static final String WINDOW_HAMMING = "hamming";
    private static final String WINDOW_BLACKMAN = "blackman";
    private static final String WINDOW_NUTTALL = "nuttall";
    private static final String WINDOW_BLACKMAN_NUTTALL = "blackman-nuttall";
    private static final String WINDOW_BLACKMAN_HARRIS = "blackman-harris";
    private static final String WINDOW_FLATTOP = "flattop";
    private static final String WINDOW_RECTANGULAR = "rectangular";

    public FFTWINDOW(String name) {
        super(name);
    }

    @Override
    protected Map<String, Object> retrieveParameters(WarpScriptStack stack) throws WarpScriptException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        Object window = stack.pop();
        if (!(window instanceof String)) {
            throw new WarpScriptException(this.getName() + " expects a STRING algorithm name.");
        }
        params.put(WINDOWING_ALGORITHM, window);
        return params;
    }

    @Override
    protected Object gtsOp(Map<String, Object> params, GeoTimeSerie gts) throws WarpScriptException {
        String algorithm = ((String)params.get(WINDOWING_ALGORITHM)).toLowerCase();
        GTSHelper.sort(gts);
        int N = gts.size();
        GeoTimeSerie windowed = new GeoTimeSerie(GTSHelper.getLastBucket(gts), GTSHelper.getBucketCount(gts), GTSHelper.getBucketSpan(gts), N);
        if (GeoTimeSerie.TYPE.DOUBLE != gts.getType() && GeoTimeSerie.TYPE.LONG != gts.getType()) {
            throw new WarpScriptException(this.getName() + " expects numeric Geo Time Series. " + GTSHelper.buildSelector(gts, false) + " is not numeric.");
        }
        double window = 0.0;
        for (int n = 0; n < N; ++n) {
            if (WINDOW_BLACKMAN.equals(algorithm)) {
                window = 0.42 - 0.5 * Math.cos(Math.PI * 2 * (double)n / ((double)N - 1.0)) + 0.08 * Math.cos(Math.PI * 4 * (double)n / ((double)N - 1.0));
            } else if (WINDOW_BLACKMAN_HARRIS.equals(algorithm)) {
                window = 0.35875 - 0.48829 * Math.cos(Math.PI * 2 * (double)n / ((double)N - 1.0)) + 0.14128 * Math.cos(Math.PI * 4 * (double)n / ((double)N - 1.0)) - 0.01168 * Math.cos(Math.PI * 6 * (double)n / ((double)N - 1.0));
            } else if (WINDOW_BLACKMAN_NUTTALL.equals(algorithm)) {
                window = 0.3635819 - 0.4891775 * Math.cos(Math.PI * 2 * (double)n / ((double)N - 1.0)) + 0.1365995 * Math.cos(Math.PI * 4 * (double)n / ((double)N - 1.0)) - 0.0106411 * Math.cos(Math.PI * 6 * (double)n / ((double)N - 1.0));
            } else if (WINDOW_FLATTOP.equals(algorithm)) {
                window = 1.0 - 1.93 * Math.cos(Math.PI * 2 * (double)n / ((double)N - 1.0)) + 1.29 * Math.cos(Math.PI * 4 * (double)n / ((double)N - 1.0)) - 0.388 * Math.cos(Math.PI * 6 * (double)n / ((double)N - 1.0)) + 0.028 * Math.cos(Math.PI * 8 * (double)n / ((double)N - 1.0));
            } else if (WINDOW_HAMMING.equals(algorithm)) {
                window = 0.54 - 0.46 * Math.cos(Math.PI * 2 * (double)n / ((double)N - 1.0));
            } else if (WINDOW_HANN.equals(algorithm)) {
                window = Math.sin(Math.PI * (double)n / ((double)N - 1.0));
                window *= window;
            } else if (WINDOW_NUTTALL.equals(algorithm)) {
                window = 0.355768 - 0.487396 * Math.cos(Math.PI * 2 * (double)n / ((double)N - 1.0)) + 0.144232 * Math.cos(Math.PI * 4 * (double)n / ((double)N - 1.0)) - 0.012604 * Math.cos(Math.PI * 6 * (double)n / ((double)N - 1.0));
            } else if (WINDOW_PARZEN.equals(algorithm)) {
                window = (double)n <= (double)N / 4.0 ? 1.0 - 6.0 * Math.pow((double)n / ((double)N / 2.0), 2.0) * (1.0 - (double)n / ((double)N / 2.0)) : 2.0 * Math.pow(1.0 - (double)n / ((double)N / 2.0), 3.0);
            } else if (WINDOW_RECTANGULAR.equals(algorithm)) {
                window = 1.0;
            } else if (WINDOW_SINE.equals(algorithm)) {
                window = Math.sin(Math.PI * (double)n / ((double)N - 1.0));
            } else if (WINDOW_TRIANGULAR.equals(algorithm)) {
                window = 1.0 - Math.abs(((double)n - ((double)N - 1.0) / 2.0) / ((double)N / 2.0));
            } else if (WINDOW_WELCH.equals(algorithm)) {
                window = 1.0 * (((double)n - ((double)N - 1.0) / 2.0) / (((double)N - 1.0) / 2.0));
            } else {
                throw new WarpScriptException(this.getName() + " given an unknown windowing function '" + algorithm + "'.");
            }
            long ts = GTSHelper.tickAtIndex(gts, n);
            long geoxppoint = GTSHelper.locationAtIndex(gts, n);
            long elevation = GTSHelper.elevationAtIndex(gts, n);
            double value = ((Number)GTSHelper.valueAtIndex(gts, n)).doubleValue();
            GTSHelper.setValue(windowed, ts, geoxppoint, elevation, value * window, false);
        }
        return windowed;
    }
}

