/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import com.geoxp.GeoXPLib;
import io.warp10.DoubleUtils;
import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.Arrays;

public class DTW
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public static final int TIMESTAMPS = 1;
    public static final int LOCATIONS = 2;
    public static final int ELEVATIONS = 4;
    public static final int VALUES = 8;
    private final boolean normalize;
    private final boolean znormalize;

    public DTW(String name, boolean normalize, boolean znormalize) {
        super(name);
        this.normalize = normalize;
        this.znormalize = znormalize;
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        double d;
        Object o = stack.pop();
        int type = 8;
        DTWDistance distance = DTW::manhattan;
        if (o instanceof String) {
            String charac;
            switch (charac = ((String)o).toLowerCase()) {
                case "values": {
                    type = 8;
                    break;
                }
                case "locations": {
                    type = 2;
                    break;
                }
                case "elevations": {
                    type = 4;
                    break;
                }
                case "timestamps": {
                    type = 1;
                    break;
                }
                default: {
                    throw new WarpScriptException(this.getName() + " expects the characteristic of the GTS to compute the DTW on to be values, locations, elevations or timestamps.");
                }
            }
            o = stack.pop();
        }
        if (o instanceof String) {
            String dist;
            switch (dist = ((String)o).toLowerCase()) {
                case "manhattan": {
                    distance = DTW::manhattan;
                    break;
                }
                case "euclidean": {
                    distance = DTW::euclidean;
                    break;
                }
                case "squaredeuclidean": {
                    distance = DTW::squaredEuclidean;
                    break;
                }
                case "loxodromic": {
                    distance = DTW::loxodromic;
                    break;
                }
                case "orthodromic": {
                    distance = DTW::orthodromic;
                    break;
                }
                default: {
                    throw new WarpScriptException(this.getName() + " expects the distance to use in the DTW to be manhattan, euclidean, loxodromic or orthodromic.");
                }
            }
            o = stack.pop();
        }
        if (!(o instanceof Number)) {
            throw new WarpScriptException(this.getName() + " expects a numeric threshold on top of the stack.");
        }
        double threshold = ((Number)o).doubleValue();
        if (threshold <= 0.0) {
            threshold = Double.POSITIVE_INFINITY;
        }
        o = stack.pop();
        int window = Integer.MAX_VALUE;
        if (o instanceof Long) {
            window = (int)Math.min(Integer.MAX_VALUE, (Long)o);
            if (window < 0) {
                window = Integer.MAX_VALUE;
            }
            o = stack.pop();
        }
        if (!(o instanceof GeoTimeSerie)) {
            throw new WarpScriptException(this.getName() + " expects two Geo Time Series below the threshold.");
        }
        GeoTimeSerie gts1 = (GeoTimeSerie)o;
        o = stack.pop();
        if (!(o instanceof GeoTimeSerie)) {
            throw new WarpScriptException(this.getName() + " expects two Geo Time Series below the threshold.");
        }
        GeoTimeSerie gts2 = (GeoTimeSerie)o;
        try {
            d = this.compute(gts1, gts2, window, threshold, type, distance);
        }
        catch (WarpScriptException wse) {
            throw new WarpScriptException(this.getName() + " failed.", wse);
        }
        stack.push(d);
        return stack;
    }

    public final double compute(GeoTimeSerie gts1, GeoTimeSerie gts2, int window, double threshold, int type, DTWDistance distance) throws WarpScriptException {
        int i;
        Object values2;
        Object values1;
        if (8 == type) {
            if (GeoTimeSerie.TYPE.LONG != gts1.getType() && GeoTimeSerie.TYPE.DOUBLE != gts1.getType()) {
                throw new WarpScriptException(this.getName() + " can only operate on numerical Geo Time Series.");
            }
            if (GeoTimeSerie.TYPE.LONG != gts2.getType() && GeoTimeSerie.TYPE.DOUBLE != gts2.getType()) {
                throw new WarpScriptException(this.getName() + " can only operate on numerical Geo Time Series.");
            }
        }
        GTSHelper.sort(gts1);
        GTSHelper.sort(gts2);
        if (8 == type) {
            values1 = new double[][]{GTSHelper.getValuesAsDouble(gts1)};
            values2 = new double[][]{GTSHelper.getValuesAsDouble(gts2)};
        } else if (2 == type) {
            long[] locations1 = GTSHelper.getOriginalLocations(gts1);
            if (null == locations1) {
                throw new WarpScriptException(this.getName() + " expects GTSs to have locations when DTW is applied to them.");
            }
            values1 = new double[2][locations1.length];
            for (int i2 = 0; i2 < locations1.length; ++i2) {
                if (91480763316633925L == locations1[i2]) {
                    throw new WarpScriptException(this.getName() + " expects GTSs to have locations when DTW is applied to them.");
                }
                double[] latLon = GeoXPLib.fromGeoXPPoint((long)locations1[i2]);
                values1[0][i2] = latLon[0];
                values1[1][i2] = latLon[1];
            }
            long[] locations2 = GTSHelper.getOriginalLocations(gts2);
            if (null == locations2) {
                throw new WarpScriptException(this.getName() + " expects GTSs to have locations when DTW is applied to them.");
            }
            values2 = new double[2][locations2.length];
            for (i = 0; i < locations2.length; ++i) {
                if (91480763316633925L == locations2[i]) {
                    throw new WarpScriptException(this.getName() + " expects GTSs to have locations when DTW is applied to them.");
                }
                double[] latLon = GeoXPLib.fromGeoXPPoint((long)locations2[i]);
                values2[0][i] = latLon[0];
                values2[1][i] = latLon[1];
            }
        } else if (4 == type) {
            long[] elev1 = GTSHelper.getOriginalElevations(gts1);
            if (null == elev1) {
                throw new WarpScriptException(this.getName() + " expects GTSs to have elevations when DTW is applied to them.");
            }
            values1 = new double[1][elev1.length];
            for (int i3 = 0; i3 < elev1.length; ++i3) {
                if (Long.MIN_VALUE == elev1[i3]) {
                    throw new WarpScriptException(this.getName() + " expects GTSs to have elevations when DTW is applied to them.");
                }
                values1[0][i3] = elev1[i3];
            }
            long[] elev2 = GTSHelper.getOriginalElevations(gts2);
            if (null == elev2) {
                throw new WarpScriptException(this.getName() + " expects GTSs to have elevations when DTW is applied to them.");
            }
            values2 = new double[1][elev2.length];
            for (i = 0; i < elev1.length; ++i) {
                if (Long.MIN_VALUE == elev2[i]) {
                    throw new WarpScriptException(this.getName() + " expects GTSs to have elevations when DTW is applied to them.");
                }
                values2[0][i] = elev2[i];
            }
        } else if (1 == type) {
            double[] timestamps1 = Arrays.stream(GTSHelper.getTicks(gts1)).asDoubleStream().toArray();
            double[] timestamps2 = Arrays.stream(GTSHelper.getTicks(gts2)).asDoubleStream().toArray();
            values1 = new double[][]{timestamps1};
            values2 = new double[][]{timestamps2};
        } else {
            throw new IllegalArgumentException("DTW type is unknown: " + type);
        }
        if (this.normalize) {
            for (int dimension = 0; dimension < ((double[][])values1).length; ++dimension) {
                int i4;
                double[] dimVal1 = values1[dimension];
                double[] dimVal2 = values2[dimension];
                if (this.znormalize) {
                    int i5;
                    double[] musigma = DoubleUtils.musigma(dimVal1, true);
                    for (i5 = 0; i5 < dimVal1.length; ++i5) {
                        dimVal1[i5] = (dimVal1[i5] - musigma[0]) / musigma[1];
                    }
                    musigma = DoubleUtils.muvar(dimVal2);
                    for (i5 = 0; i5 < dimVal2.length; ++i5) {
                        dimVal2[i5] = (dimVal2[i5] - musigma[0]) / musigma[1];
                    }
                    continue;
                }
                double min = Double.POSITIVE_INFINITY;
                double max = Double.NEGATIVE_INFINITY;
                for (int i6 = 0; i6 < dimVal1.length; ++i6) {
                    if (dimVal1[i6] < min) {
                        min = dimVal1[i6];
                    }
                    if (!(dimVal1[i6] > max)) continue;
                    max = dimVal1[i6];
                }
                double range = max - min;
                if (0.0 == range) {
                    throw new WarpScriptException(this.getName() + " cannot normalize a constant GTS.");
                }
                for (i4 = 0; i4 < dimVal1.length; ++i4) {
                    dimVal1[i4] = (dimVal1[i4] - min) / range;
                }
                min = Double.POSITIVE_INFINITY;
                max = Double.NEGATIVE_INFINITY;
                for (i4 = 0; i4 < dimVal2.length; ++i4) {
                    if (dimVal2[i4] < min) {
                        min = dimVal2[i4];
                    }
                    if (!(dimVal2[i4] > max)) continue;
                    max = dimVal2[i4];
                }
                range = max - min;
                if (0.0 == range) {
                    throw new WarpScriptException(this.getName() + " cannot normalize a constant GTS.");
                }
                for (i4 = 0; i4 < dimVal2.length; ++i4) {
                    dimVal2[i4] = (dimVal2[i4] - min) / range;
                }
            }
        }
        int len1 = values1[0].length;
        int len2 = values2[0].length;
        return DTW.compute(values1, 0, len1, values2, 0, len2, window, threshold, distance);
    }

    public static double compute(double[][] values1, int offset1, int len1, double[][] values2, int offset2, int len2, int window, double threshold, DTWDistance distance) throws WarpScriptException {
        if (values1.length != values2.length) {
            throw new IllegalArgumentException("values must have the same dimension.");
        }
        for (int dimension = 1; dimension < values1.length; ++dimension) {
            if (values1[0].length == values1[dimension].length && values2[0].length == values2[dimension].length) continue;
            throw new WarpScriptException("values must have the same number of element per dimension.");
        }
        if (len1 > len2) {
            double[][] tmp = values1;
            values1 = values2;
            values2 = tmp;
            int tmpint = offset1;
            offset1 = offset2;
            offset2 = tmpint;
            tmpint = len1;
            len1 = len2;
            len2 = tmpint;
        }
        double[] a = new double[len1];
        double[] b = new double[len1];
        boolean belowThreshold = false;
        window = Math.max(Math.min(window, len2 - 1), len2 - len1);
        for (int i = offset2; i < len2; ++i) {
            int maxWindow;
            try {
                maxWindow = Math.addExact(i + 1, window);
            }
            catch (ArithmeticException ae) {
                maxWindow = Integer.MAX_VALUE;
            }
            for (int j = Math.max(offset1, i - window); j < Math.min(len1, maxWindow); ++j) {
                double bestPreviousTotalDistance;
                if (0 == i && 0 == j) {
                    bestPreviousTotalDistance = 0.0;
                } else {
                    double left = i > 0 && i + window != j ? a[j] : Double.POSITIVE_INFINITY;
                    double bottom = j > 0 && i - window != j ? b[j - 1] : Double.POSITIVE_INFINITY;
                    double bottomLeft = j > 0 ? a[j - 1] : Double.POSITIVE_INFINITY;
                    bestPreviousTotalDistance = Math.min(left, Math.min(bottom, bottomLeft));
                }
                if (threshold >= bestPreviousTotalDistance) {
                    double d = distance.measure(values1, j, values2, i);
                    b[j] = d + bestPreviousTotalDistance;
                    if (belowThreshold || !(b[j] <= threshold)) continue;
                    belowThreshold = true;
                    continue;
                }
                b[j] = Double.POSITIVE_INFINITY;
            }
            if (!belowThreshold) {
                return -1.0;
            }
            double[] tmp = a;
            a = b;
            b = tmp;
        }
        if (a[len1 - 1] <= threshold) {
            return a[len1 - 1];
        }
        return -1.0;
    }

    public static double manhattan(double[][] values1, int index1, double[][] values2, int index2) throws WarpScriptException {
        double d = 0.0;
        for (int dimension = 0; dimension < values1.length; ++dimension) {
            d += Math.abs(values1[dimension][index1] - values2[dimension][index2]);
        }
        return d;
    }

    public static double euclidean(double[][] values1, int index1, double[][] values2, int index2) throws WarpScriptException {
        double d = 0.0;
        for (int dimension = 0; dimension < values1.length; ++dimension) {
            d += Math.pow(values1[dimension][index1] - values2[dimension][index2], 2.0);
        }
        return Math.sqrt(d);
    }

    public static double squaredEuclidean(double[][] values1, int index1, double[][] values2, int index2) throws WarpScriptException {
        double d = 0.0;
        for (int dimension = 0; dimension < values1.length; ++dimension) {
            d += Math.pow(values1[dimension][index1] - values2[dimension][index2], 2.0);
        }
        return d;
    }

    public static double loxodromic(double[][] values1, int index1, double[][] values2, int index2) throws WarpScriptException {
        if (2 != values1.length) {
            throw new WarpScriptException("Loxodromic distance must be given two dimensions: lat, lon.");
        }
        double lat1 = Math.toRadians(values1[0][index1]);
        double lon1 = Math.toRadians(values1[1][index1]);
        double lat2 = Math.toRadians(values2[0][index2]);
        double lon2 = Math.toRadians(values2[1][index2]);
        double x = (lon1 - lon2) * Math.cos((lat1 + lat2) / 2.0);
        double y = lat1 - lat2;
        return 6366707.019493707 * Math.sqrt(x * x + y * y);
    }

    public static double orthodromic(double[][] values1, int index1, double[][] values2, int index2) throws WarpScriptException {
        if (2 != values1.length) {
            throw new WarpScriptException("Orthodromic distance must be given two dimensions: lat, lon.");
        }
        double lat1 = Math.toRadians(values1[0][index1]);
        double lon1 = Math.toRadians(values1[1][index1]);
        double lat2 = Math.toRadians(values2[0][index2]);
        double lon2 = Math.toRadians(values2[1][index2]);
        return 6366707.019493707 * Math.acos(Math.sin(lat1) * Math.sin(lat2) + Math.cos(lat1) * Math.cos(lat2) * Math.cos(lon2 - lon1));
    }

    @FunctionalInterface
    public static interface DTWDistance {
        public double measure(double[][] var1, int var2, double[][] var3, int var4) throws WarpScriptException;
    }
}

