/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.standalone.AcceleratorConfig;
import java.util.ArrayList;
import java.util.LinkedHashMap;

public class ACCELREPORT
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private static final String KEY_ACCELERATED = "accelerated";
    private static final String KEY_STATUS = "status";
    private static final String KEY_CACHE = "cache";
    private static final String KEY_PERSIST = "persist";
    private static final String KEY_CHUNK_COUNT = "chunkcount";
    private static final String KEY_CHUNK_SPAN = "chunkspan";
    private static final String KEY_DEFAULTS_WRITE = "defaults.write";
    private static final String KEY_DEFAULTS_DELETE = "defaults.delete";
    private static final String KEY_DEFAULTS_READ = "defaults.read";

    public ACCELREPORT(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        LinkedHashMap<String, Object> report = new LinkedHashMap<String, Object>();
        report.put(KEY_STATUS, AcceleratorConfig.isInstantiated());
        report.put(KEY_CACHE, AcceleratorConfig.isCache());
        report.put(KEY_PERSIST, AcceleratorConfig.isPersist());
        report.put(KEY_ACCELERATED, AcceleratorConfig.accelerated());
        report.put(KEY_CHUNK_COUNT, Long.valueOf(AcceleratorConfig.getChunkCount()));
        report.put(KEY_CHUNK_SPAN, AcceleratorConfig.getChunkSpan());
        ArrayList<String> defaults = new ArrayList<String>(2);
        if (AcceleratorConfig.getDefaultReadNocache()) {
            defaults.add("nocache");
        } else {
            defaults.add(KEY_CACHE);
        }
        if (AcceleratorConfig.getDefaultReadNopersist()) {
            defaults.add("nopersist");
        } else {
            defaults.add(KEY_PERSIST);
        }
        report.put(KEY_DEFAULTS_READ, defaults);
        defaults = new ArrayList(2);
        if (AcceleratorConfig.getDefaultWriteNocache()) {
            defaults.add("nocache");
        } else {
            defaults.add(KEY_CACHE);
        }
        if (AcceleratorConfig.getDefaultWriteNopersist()) {
            defaults.add("nopersist");
        } else {
            defaults.add(KEY_PERSIST);
        }
        report.put(KEY_DEFAULTS_WRITE, defaults);
        defaults = new ArrayList(2);
        if (AcceleratorConfig.getDefaultDeleteNocache()) {
            defaults.add("nocache");
        } else {
            defaults.add(KEY_CACHE);
        }
        if (AcceleratorConfig.getDefaultDeleteNopersist()) {
            defaults.add("nopersist");
        } else {
            defaults.add(KEY_PERSIST);
        }
        report.put(KEY_DEFAULTS_DELETE, defaults);
        stack.push(report);
        return stack;
    }
}

