/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.fastdtw;

import io.warp10.script.fastdtw.CostMatrix;
import io.warp10.script.fastdtw.SearchWindow;

class MemoryResidentMatrix
implements CostMatrix {
    private static final double OUT_OF_WINDOW_VALUE = Double.POSITIVE_INFINITY;
    private final SearchWindow window;
    private double[] cellValues;
    private int[] colOffsets;

    MemoryResidentMatrix(SearchWindow searchWindow) {
        this.window = searchWindow;
        this.cellValues = new double[this.window.size()];
        this.colOffsets = new int[this.window.maxI() + 1];
        int currentOffset = 0;
        for (int i = this.window.minI(); i <= this.window.maxI(); ++i) {
            this.colOffsets[i] = currentOffset;
            currentOffset += this.window.maxJforI(i) - this.window.minJforI(i) + 1;
        }
    }

    @Override
    public void put(int col, int row, double value) {
        if (row < this.window.minJforI(col) || row > this.window.maxJforI(col)) {
            throw new RuntimeException("CostMatrix is filled in a cell (col=" + col + ", row=" + row + ") that is not in the search window");
        }
        this.cellValues[this.colOffsets[col] + row - this.window.minJforI((int)col)] = value;
    }

    @Override
    public double get(int col, int row) {
        if (row < this.window.minJforI(col) || row > this.window.maxJforI(col)) {
            return Double.POSITIVE_INFINITY;
        }
        return this.cellValues[this.colOffsets[col] + row - this.window.minJforI(col)];
    }

    @Override
    public int size() {
        return this.cellValues.length;
    }
}

