/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.ext.shm;

import io.warp10.WarpConfig;
import io.warp10.script.WarpScriptException;
import io.warp10.script.ext.shm.MUTEX;
import io.warp10.script.ext.shm.SHMDEFINED;
import io.warp10.script.ext.shm.SHMLOAD;
import io.warp10.script.ext.shm.SHMSTORE;
import io.warp10.warp.sdk.WarpScriptExtension;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;

public class SharedMemoryWarpScriptExtension
extends WarpScriptExtension
implements Runnable {
    private static final Map<String, Object> functions;
    private static final Map<String, ReentrantLock> locks;
    private static final Map<String, Long> lockUses;
    private static final Map<String, Object> shmobjects;
    private static final Map<String, String> shmobjectLocks;
    private static final Map<String, Long> shmobjectUses;
    private static Thread janitor;
    private static final long ttl;
    private static final String CONFIG_SHM_TTL = "shm.ttl";
    private static final long DEFAULT_SHM_TTL = 3600000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SharedMemoryWarpScriptExtension() {
        Map<String, Object> map = functions;
        synchronized (map) {
            if (null == janitor) {
                janitor = new Thread(this);
                janitor.setDaemon(true);
                janitor.start();
            }
        }
    }

    @Override
    public Map<String, Object> getFunctions() {
        return functions;
    }

    public static final synchronized ReentrantLock getLock(String name) {
        ReentrantLock lock = locks.get(name);
        if (null == lock) {
            lock = new ReentrantLock(true);
            locks.put(name, lock);
        }
        lockUses.put(name, System.currentTimeMillis());
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void store(String symbol, String mutex, Object o) throws WarpScriptException {
        Map<String, ReentrantLock> map = locks;
        synchronized (map) {
            if (null == o || null == mutex) {
                shmobjects.remove(symbol);
                shmobjectLocks.remove(symbol);
                shmobjectUses.remove(symbol);
                return;
            }
            if (null != shmobjectLocks.get(symbol)) {
                return;
            }
            shmobjects.put(symbol, o);
            shmobjectLocks.put(symbol, mutex);
            shmobjectUses.put(symbol, System.currentTimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Object load(String symbol) throws WarpScriptException {
        Map<String, ReentrantLock> map = locks;
        synchronized (map) {
            String mutex = shmobjectLocks.get(symbol);
            if (null == mutex) {
                throw new WarpScriptException("Unknown shared memory symbol '" + symbol + "'.");
            }
            ReentrantLock lock = locks.get(mutex);
            if (!lock.isHeldByCurrentThread()) {
                throw new WarpScriptException("Invalid access to shared memory symbol '" + symbol + "', not in a mutex section with mutex '" + mutex + "' held.");
            }
            Object value = shmobjects.get(symbol);
            shmobjectUses.put(symbol, System.currentTimeMillis());
            return value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Object defined(String symbol) throws WarpScriptException {
        Map<String, ReentrantLock> map = locks;
        synchronized (map) {
            String mutex = shmobjectLocks.get(symbol);
            return null != mutex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    LockSupport.parkNanos(Math.min(60000000000L, ttl * 500000L));
                    Map<String, ReentrantLock> map = locks;
                    synchronized (map) {
                        String mutex;
                        long now = System.currentTimeMillis();
                        for (String string : shmobjects.keySet()) {
                            ReentrantLock lock;
                            if (now - shmobjectUses.get(string) <= ttl || (lock = locks.get(mutex = shmobjectLocks.get(string))).isLocked()) continue;
                            shmobjects.remove(string);
                            shmobjectLocks.remove(string);
                            shmobjectUses.remove(string);
                        }
                        for (Map.Entry entry : locks.entrySet()) {
                            mutex = (String)entry.getKey();
                            if (now - lockUses.get(mutex) <= ttl || shmobjectLocks.containsValue(mutex) || ((ReentrantLock)entry.getValue()).isLocked()) continue;
                            locks.remove(mutex);
                            lockUses.remove(mutex);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                continue;
            }
            break;
        }
    }

    static {
        janitor = null;
        locks = new HashMap<String, ReentrantLock>();
        lockUses = new HashMap<String, Long>();
        shmobjects = new HashMap<String, Object>();
        shmobjectLocks = new HashMap<String, String>();
        shmobjectUses = new HashMap<String, Long>();
        ttl = Long.parseLong(WarpConfig.getProperty(CONFIG_SHM_TTL, String.valueOf(3600000L)));
        functions = new HashMap<String, Object>();
        functions.put("SHMSTORE", new SHMSTORE("SHMSTORE"));
        functions.put("SHMLOAD", new SHMLOAD("SHMLOAD"));
        functions.put("SHMDEFINED", new SHMDEFINED("SHMDEFINED"));
        functions.put("MUTEX", new MUTEX("MUTEX"));
    }
}

