/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.ext.sensision;

import com.geoxp.GeoXPLib;
import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.continuum.store.Constants;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.ext.sensision.SensisionWarpScriptExtension;
import io.warp10.script.functions.PARSESELECTOR;
import io.warp10.sensision.Sensision;
import io.warp10.warp.sdk.Capabilities;
import java.util.HashMap;
import java.util.Map;

public class SENSISIONGET
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public SENSISIONGET(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        HashMap<String, String> labels;
        String cls;
        if (SensisionWarpScriptExtension.useCapability() && null == Capabilities.get(stack, "sensision.read")) {
            throw new WarpScriptException(this.getName() + " missing capability '" + "sensision.read" + "'");
        }
        Object top = stack.pop();
        if (top instanceof String) {
            Object[] parsed = PARSESELECTOR.parse(top.toString());
            cls = parsed[0].toString();
            labels = new HashMap<String, String>();
            for (Map.Entry entry : ((Map)parsed[1]).entrySet()) {
                labels.put((String)entry.getKey(), ((String)entry.getValue()).substring(1));
            }
        } else {
            labels = (HashMap<String, String>)top;
            cls = stack.pop().toString();
        }
        GeoTimeSerie gts = new GeoTimeSerie();
        gts.setName(cls);
        gts.setLabels(labels);
        Object value = Sensision.getValue((String)cls, labels);
        if (null != value) {
            long timestamp = Constants.TIME_UNITS_PER_MS * (Sensision.getTimestamp((String)cls, labels) / Sensision.TIME_UNITS_PER_MS);
            float[] latlon = Sensision.getLocation((String)cls, labels);
            Long elevation = Sensision.getElevation((String)cls, labels);
            long geoxppoint = null == latlon ? 91480763316633925L : GeoXPLib.toGeoXPPoint((double)latlon[0], (double)latlon[1]);
            long elev = null == elevation ? Long.MIN_VALUE : elevation;
            GTSHelper.setValue(gts, timestamp, geoxppoint, elev, value, false);
        }
        stack.push(gts);
        return stack;
    }
}

