/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script;

import io.warp10.WarpClassLoader;
import io.warp10.script.WarpScriptException;
import io.warp10.sensision.Sensision;
import io.warp10.warp.sdk.WarpScriptJavaFunction;
import io.warp10.warp.sdk.WarpScriptJavaFunctionException;
import io.warp10.warp.sdk.WarpScriptRawJavaFunction;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.locks.LockSupport;
import org.bouncycastle.util.encoders.Hex;

public class WarpScriptJarRepository
extends Thread {
    private static final long DEFAULT_DELAY = 3600000L;
    private static final String JAR_EXTENSION = ".jar";
    private final String directory;
    private final long delay;
    private static final Map<ClassLoader, String> classLoadersFingerprints = new LinkedHashMap<ClassLoader, String>();
    private static ClassLoader classPathClassLoader = null;
    private static final Map<String, WarpScriptJavaFunction> cachedUDFs = new HashMap<String, WarpScriptJavaFunction>();

    public WarpScriptJarRepository(String directory, long delay) {
        this.directory = directory;
        this.delay = delay;
        if (null != directory) {
            this.setName("[Warp Jar Repository (" + directory + ")]");
            this.setDaemon(true);
            this.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            String rootdir = new File(this.directory).getAbsolutePath();
            File[] files = new File(rootdir).listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(WarpScriptJarRepository.JAR_EXTENSION);
                }
            });
            LinkedHashMap<ClassLoader, String> newClassLoadersFingerprints = new LinkedHashMap<ClassLoader, String>();
            byte[] buf = new byte[8192];
            if (null != files) {
                try {
                    MessageDigest md = MessageDigest.getInstance("SHA-1");
                    for (File file : files) {
                        int len;
                        FileInputStream in = new FileInputStream(file);
                        while ((len = in.read(buf)) >= 0) {
                            md.update(buf, 0, len);
                        }
                        in.close();
                        String hash = new String(Hex.encode((byte[])md.digest()), StandardCharsets.US_ASCII);
                        if (newClassLoadersFingerprints.containsValue(hash)) continue;
                        if (classLoadersFingerprints.containsValue(hash)) {
                            for (Map.Entry<ClassLoader, String> entry : classLoadersFingerprints.entrySet()) {
                                if (!entry.getValue().equals(hash)) continue;
                                newClassLoadersFingerprints.put(entry.getKey(), entry.getValue());
                            }
                            continue;
                        }
                        ClassLoader parentCL = this.getClass().getClassLoader();
                        newClassLoadersFingerprints.put(new WarpClassLoader("[WarpClassLoader for " + file + "]", file.getCanonicalPath(), parentCL), hash);
                    }
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            Map<ClassLoader, String> map = classLoadersFingerprints;
            synchronized (map) {
                classLoadersFingerprints.clear();
                classLoadersFingerprints.putAll(newClassLoadersFingerprints);
                if (null != classPathClassLoader) {
                    classLoadersFingerprints.put(classPathClassLoader, "");
                }
            }
            Sensision.set((String)"warp.script.repository.jars", (Map)Sensision.EMPTY_LABELS, (Object)classLoadersFingerprints.size());
            LockSupport.parkNanos(this.delay * 1000000L);
        }
    }

    public static WarpScriptJavaFunction load(String name, boolean cached) throws WarpScriptException {
        WarpScriptJavaFunction udf = null;
        if (cached) {
            udf = cachedUDFs.get(name);
            if (null != udf && WarpScriptJarRepository.validate(udf)) {
                return udf;
            }
            cachedUDFs.remove(name);
            udf = null;
        }
        for (Map.Entry<ClassLoader, String> entry : classLoadersFingerprints.entrySet()) {
            try {
                ClassLoader cl = entry.getKey();
                Class<?> cls = cl.loadClass(name);
                Object o = cls.newInstance();
                if (!(o instanceof WarpScriptJavaFunction)) {
                    throw new WarpScriptException(name + " does not appear to be of type " + WarpScriptJavaFunction.class.getCanonicalName());
                }
                udf = (WarpScriptJavaFunction)o;
                if (!cl.equals(classPathClassLoader)) break;
                final WarpScriptJavaFunction innerUDF = udf;
                if (udf instanceof WarpScriptRawJavaFunction) {
                    udf = new WarpScriptRawJavaFunction(){

                        @Override
                        public boolean isProtected() {
                            return false;
                        }

                        @Override
                        public int argDepth() {
                            return innerUDF.argDepth();
                        }

                        @Override
                        public List<Object> apply(List<Object> args) throws WarpScriptJavaFunctionException {
                            return innerUDF.apply(args);
                        }
                    };
                    break;
                }
                udf = new WarpScriptJavaFunction(){

                    @Override
                    public boolean isProtected() {
                        return false;
                    }

                    @Override
                    public int argDepth() {
                        return innerUDF.argDepth();
                    }

                    @Override
                    public List<Object> apply(List<Object> args) throws WarpScriptJavaFunctionException {
                        return innerUDF.apply(args);
                    }
                };
                break;
            }
            catch (Exception e) {
            }
        }
        if (cached && null != udf) {
            cachedUDFs.put(name, udf);
        }
        if (null == udf) {
            throw new WarpScriptException("Class '" + name + "' was not found in any of the current WarpScript jars.");
        }
        return udf;
    }

    private static boolean validate(WarpScriptJavaFunction func) {
        if (null == func) {
            return true;
        }
        return classLoadersFingerprints.containsKey(func.getClass().getClassLoader());
    }

    public static void init(Properties properties) {
        String dir = properties.getProperty("warpscript.jars.directory");
        if (null == dir && !"true".equals(properties.getProperty("warpscript.jars.fromclasspath"))) {
            return;
        }
        if (null == dir) {
            classPathClassLoader = WarpScriptJarRepository.class.getClassLoader();
            classLoadersFingerprints.put(classPathClassLoader, "");
            return;
        }
        long delay = 3600000L;
        String refresh = properties.getProperty("warpscript.jars.refresh");
        if (null != refresh) {
            try {
                delay = Long.parseLong(refresh.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        new WarpScriptJarRepository(dir, delay);
    }
}

