/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script;

import io.warp10.script.MemoryWarpScriptStack;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptLib;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.binary.ADD;
import io.warp10.script.binary.SUB;
import io.warp10.script.ext.warpfleet.WarpFleetWarpScriptExtension;
import io.warp10.script.functions.DROP;
import io.warp10.script.functions.HUMANDURATION;
import io.warp10.script.functions.MSGFAIL;
import io.warp10.script.functions.NOW;
import io.warp10.sensision.Sensision;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WarpFleetMacroRepository {
    private static final Logger LOG = LoggerFactory.getLogger(WarpFleetMacroRepository.class);
    private static final MSGFAIL MSGFAIL_FUNC = new MSGFAIL("MSGFAIL");
    private static final NOW NOW_FUNC = new NOW("NOW");
    private static final SUB SUB_FUNC = new SUB("-");
    private static final ADD ADD_FUNC = new ADD("+");
    private static final HUMANDURATION HUMANDURATION_FUNC = new HUMANDURATION("HUMANDURATION");
    private static final String MACRO_PLACEHOLDER = "{macro}";
    private static final String MACRO_PLACEHOLDER_ENCODED = "%7Bmacro%7D";
    private static final int FINGERPRINT_UNKNOWN = -1;
    private static ThreadLocal<List<String>> loading = new ThreadLocal<List<String>>(){

        @Override
        protected List<String> initialValue() {
            return new ArrayList<String>();
        }
    };
    private static final String ATTRIBUTE_WARPFLEET_REPOS = "warpfleet.repos";
    public static final String ATTRIBUTE_WARPFLEET_DISABLE = "warpfleet.disable";
    private static final long DEFAULT_TTL = 600000L;
    private static final long DEFAULT_TTL_MIN = 60000L;
    private static final long DEFAULT_TTL_MAX = 86400000L;
    private static final long DEFAULT_TTL_FAILED = 10000L;
    private static final long DEFAULT_TTL_UNKNOWN = 0L;
    private static final int DEFAULT_READ_TIMEOUT = 10000;
    private static final int DEFAULT_CONNECT_TIMEOUT = 5000;
    private static long ttl = 600000L;
    private static long minttl = 60000L;
    private static long maxttl = 86400000L;
    private static long failedTtl = 10000L;
    private static long unknownTtl = 0L;
    private static int readTimeout = 10000;
    private static int connectTimeout = 5000;
    private static final List<String> DEFAULT_REPOS = new ArrayList<String>();
    private static final int DEFAULT_CACHE_SIZE = 10000;
    private static Map<String, WarpScriptStack.Macro> macros = null;
    private static WarpScriptStack.Macro validator = null;
    private static AtomicBoolean initialized = new AtomicBoolean(false);

    /*
     * Exception decompiling
     */
    public static WarpScriptStack.Macro find(WarpScriptStack callingStack, String name) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [31[CATCHBLOCK]], but top level block is 8[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void init(Properties properties) {
        String repostr = properties.getProperty("warpfleet.macros.repos", "https://warpfleet.senx.io/macros");
        if (null != repostr) {
            String[] repos;
            for (String repo : repos = repostr.split(",")) {
                if (null == (repo = WarpFleetMacroRepository.validateRepo(repo))) continue;
                DEFAULT_REPOS.add(repo.trim());
            }
        }
        final int maxcachesize = Integer.parseInt(properties.getProperty("warpfleet.cache.size", Integer.toString(10000)));
        macros = new LinkedHashMap<String, WarpScriptStack.Macro>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, WarpScriptStack.Macro> eldest) {
                int size = this.size();
                Sensision.set((String)"warpfleet.macros.cached", (Map)Sensision.EMPTY_LABELS, (Object)size);
                return size > maxcachesize;
            }
        };
        minttl = Long.parseLong(properties.getProperty("warpfleet.macros.ttl.min", Long.toString(60000L)));
        maxttl = Long.parseLong(properties.getProperty("warpfleet.macros.ttl.max", Long.toString(86400000L)));
        ttl = Long.parseLong(properties.getProperty("warpfleet.macros.ttl", Long.toString(600000L)));
        failedTtl = Long.parseLong(properties.getProperty("warpfleet.macros.ttl.failed", Long.toString(10000L)));
        unknownTtl = Long.parseLong(properties.getProperty("warpfleet.macros.ttl.unknown", Long.toString(0L)));
        readTimeout = Integer.parseInt(properties.getProperty("warpfleet.timeout.read", Integer.toString(10000)));
        connectTimeout = Integer.parseInt(properties.getProperty("warpfleet.timeout.connect", Integer.toString(5000)));
        String validationMacro = properties.getProperty("warpfleet.macros.validator");
        if (null != validationMacro) {
            MemoryWarpScriptStack stack = new MemoryWarpScriptStack(null, null);
            stack.maxLimits();
            try {
                validator = stack.find(validationMacro.trim());
            }
            catch (WarpScriptException wse) {
                LOG.error("Validator macro encountered errors, no validator will be set thus refusing all URLs.", (Throwable)wse);
                validator = null;
            }
        }
        if (null == validator) {
            LOG.warn("No validator macro, default macro will reject all URLs.");
            validator = new WarpScriptStack.Macro();
            validator.add(new DROP(""));
            validator.add(false);
        }
        WarpScriptLib.register(new WarpFleetWarpScriptExtension());
        initialized.set(true);
    }

    public static List<String> getRepos(WarpScriptStack stack) {
        List<String> repos = (List<String>)stack.getAttribute(ATTRIBUTE_WARPFLEET_REPOS);
        if (null == repos) {
            repos = DEFAULT_REPOS;
        }
        ArrayList<String> reps = new ArrayList<String>();
        reps.addAll(repos);
        return reps;
    }

    public static void setRepos(WarpScriptStack stack, List<String> repos) {
        if (null == repos) {
            stack.setAttribute(ATTRIBUTE_WARPFLEET_REPOS, null);
        } else {
            MemoryWarpScriptStack chkstack = new MemoryWarpScriptStack(null, null);
            chkstack.maxLimits();
            ArrayList<String> validRepos = new ArrayList<String>();
            for (String repo : repos) {
                if (null == (repo = WarpFleetMacroRepository.validateRepo(repo))) continue;
                try {
                    chkstack.clear();
                    chkstack.push(repo);
                    chkstack.exec(validator);
                    if (!Boolean.TRUE.equals(chkstack.pop())) continue;
                    validRepos.add(repo);
                }
                catch (WarpScriptException warpScriptException) {}
            }
            stack.setAttribute(ATTRIBUTE_WARPFLEET_REPOS, validRepos);
        }
    }

    private static String validateRepo(String repo) {
        if ((repo = repo.trim()).startsWith("http://") || repo.startsWith("https://")) {
            try {
                String canonical;
                URL url = new URL(repo);
                URI uri = new URI(url.getProtocol(), url.getUserInfo(), url.getHost().toLowerCase(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
                repo = canonical = uri.toString().replaceAll(MACRO_PLACEHOLDER_ENCODED, MACRO_PLACEHOLDER);
            }
            catch (MalformedURLException | URISyntaxException e) {
                LOG.warn("Error while parsing repo URL, will be ignored.", (Throwable)e);
                return null;
            }
        } else {
            repo = null;
        }
        if (null != repo && (repo.contains("/../") || repo.contains("/./"))) {
            repo = null;
        }
        return repo;
    }
}

