/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.hadoop;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.ReflectionUtils;

public class BytesOutputFormat
extends FileOutputFormat<Writable, BytesWritable> {
    public RecordWriter<Writable, BytesWritable> getRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        FSDataOutputStream fileOut;
        String extension = "";
        boolean isCompressed = BytesOutputFormat.getCompressOutput((JobContext)context);
        Configuration conf = context.getConfiguration();
        CompressionCodec codec = null;
        if (isCompressed) {
            Class codecClass = BytesOutputFormat.getOutputCompressorClass((JobContext)context, GzipCodec.class);
            codec = (CompressionCodec)ReflectionUtils.newInstance((Class)codecClass, (Configuration)conf);
            extension = codec.getDefaultExtension();
        }
        Path file = this.getDefaultWorkFile(context, extension);
        FileSystem fs = file.getFileSystem(context.getConfiguration());
        Object out = fileOut = fs.create(file, false);
        if (isCompressed) {
            out = new DataOutputStream((OutputStream)codec.createOutputStream((OutputStream)fileOut));
        }
        return new BytesRecordWriter((DataOutputStream)out);
    }

    public static class BytesRecordWriter
    extends RecordWriter<Writable, BytesWritable> {
        private final DataOutputStream out;

        public BytesRecordWriter(DataOutputStream out) {
            this.out = out;
        }

        public void close(TaskAttemptContext context) throws IOException, InterruptedException {
            this.out.close();
        }

        public void write(Writable key, BytesWritable value) throws IOException, InterruptedException {
            this.out.write(value.getBytes(), 0, value.getLength());
        }
    }
}

