/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.crypto;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class OrderPreservingBase64 {
    private static final byte[] ALPHABET = ".0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ_abcdefghijklmnopqrstuvwxyz".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] TEBAHPLA = new byte[256];

    public static byte[] encode(byte[] data) {
        return OrderPreservingBase64.encode(data, 0, data.length);
    }

    public static String encodeToString(byte[] data) {
        return new String(OrderPreservingBase64.encode(data), StandardCharsets.UTF_8);
    }

    public static byte[] encode(byte[] data, int offset, int len) {
        byte[] encoded = new byte[4 * (len / 3) + (len % 3 != 0 ? 1 + len % 3 : 0)];
        int idx = 0;
        block9: for (int i = 0; i < len; ++i) {
            switch (i % 3) {
                case 0: {
                    encoded[idx++] = ALPHABET[data[offset + i] >> 2 & 0x3F];
                    continue block9;
                }
                case 1: {
                    encoded[idx++] = ALPHABET[(data[offset + i - 1] & 3) << 4 | data[offset + i] >> 4 & 0xF];
                    continue block9;
                }
                case 2: {
                    encoded[idx++] = ALPHABET[(data[offset + i - 1] & 0xF) << 2 | data[offset + i] >> 6 & 3];
                    encoded[idx++] = ALPHABET[data[offset + i] & 0x3F];
                }
            }
        }
        if (idx < encoded.length) {
            switch (len % 3) {
                case 1: {
                    encoded[idx] = ALPHABET[data[offset + len - 1] << 4 & 0x30];
                    break;
                }
                case 2: {
                    encoded[idx] = ALPHABET[data[offset + len - 1] << 2 & 0x3C];
                }
            }
        }
        return encoded;
    }

    public static void encodeToStream(byte[] data, OutputStream out) throws IOException {
        OrderPreservingBase64.encodeToStream(out, data, 0, data.length);
    }

    public static void encodeToStream(OutputStream out, byte[] data, int offset, int datalen) throws IOException {
        int i = 0;
        int len = 4 * (datalen / 3) + (datalen % 3 != 0 ? 1 + datalen % 3 : 0);
        int bufidx = 0;
        for (i = offset; i < offset + datalen; ++i) {
            switch (bufidx % 3) {
                case 0: {
                    out.write(ALPHABET[data[i] >> 2 & 0x3F]);
                    break;
                }
                case 1: {
                    out.write(ALPHABET[(data[i - 1] & 3) << 4 | data[i] >> 4 & 0xF]);
                    break;
                }
                case 2: {
                    out.write(ALPHABET[(data[i - 1] & 0xF) << 2 | data[i] >> 6 & 3]);
                    out.write(ALPHABET[data[i] & 0x3F]);
                }
            }
            ++bufidx;
        }
        if (bufidx < len) {
            switch (datalen % 3) {
                case 1: {
                    out.write(ALPHABET[data[offset + datalen - 1] << 4 & 0x30]);
                    break;
                }
                case 2: {
                    out.write(ALPHABET[data[offset + datalen - 1] << 2 & 0x3C]);
                }
            }
        }
    }

    public static void encodeToStream(OutputStream out, byte[] data, int offset, int datalen, int buflen) throws IOException {
        int len = 4 * (datalen / 3) + (datalen % 3 != 0 ? 1 + datalen % 3 : 0);
        if (buflen < 1024) {
            buflen = 1024;
        }
        byte[] buf = new byte[buflen > len ? len : buflen];
        OrderPreservingBase64.encodeToStream(out, data, offset, datalen, buf);
    }

    public static void encodeToStream(OutputStream out, byte[] data, int offset, int datalen, byte[] buf) throws IOException {
        int len = 4 * (datalen / 3) + (datalen % 3 != 0 ? 1 + datalen % 3 : 0);
        int dataidx = 0;
        int bufidx = 0;
        int i = 0;
        for (i = offset; i < offset + datalen; ++i) {
            if (buf.length - bufidx < 2) {
                out.write(buf, 0, bufidx);
                bufidx = 0;
            }
            switch (dataidx % 3) {
                case 0: {
                    buf[bufidx++] = ALPHABET[data[i] >> 2 & 0x3F];
                    break;
                }
                case 1: {
                    buf[bufidx++] = ALPHABET[(data[i - 1] & 3) << 4 | data[i] >> 4 & 0xF];
                    break;
                }
                case 2: {
                    buf[bufidx++] = ALPHABET[(data[i - 1] & 0xF) << 2 | data[i] >> 6 & 3];
                    buf[bufidx++] = ALPHABET[data[i] & 0x3F];
                }
            }
            ++dataidx;
        }
        if (bufidx > 0) {
            out.write(buf, 0, bufidx);
        }
        if (dataidx < len) {
            switch (datalen % 3) {
                case 1: {
                    out.write(ALPHABET[data[offset + datalen - 1] << 4 & 0x30]);
                    break;
                }
                case 2: {
                    out.write(ALPHABET[data[offset + datalen - 1] << 2 & 0x3C]);
                }
            }
        }
    }

    public static void encodeToWriter(byte[] data, Writer out) throws IOException {
        OrderPreservingBase64.encodeToWriter(out, data, 0, data.length);
    }

    public static void encodeToWriter(Writer out, byte[] data, int offset, int datalen) throws IOException {
        int i = 0;
        int len = 4 * (datalen / 3) + (datalen % 3 != 0 ? 1 + datalen % 3 : 0);
        int bufidx = 0;
        for (i = offset; i < offset + datalen; ++i) {
            switch (bufidx % 3) {
                case 0: {
                    out.write(ALPHABET[data[i] >> 2 & 0x3F]);
                    break;
                }
                case 1: {
                    out.write(ALPHABET[(data[i - 1] & 3) << 4 | data[i] >> 4 & 0xF]);
                    break;
                }
                case 2: {
                    out.write(ALPHABET[(data[i - 1] & 0xF) << 2 | data[i] >> 6 & 3]);
                    out.write(ALPHABET[data[i] & 0x3F]);
                }
            }
            ++bufidx;
        }
        if (bufidx < len) {
            switch (datalen % 3) {
                case 1: {
                    out.write(ALPHABET[data[offset + datalen - 1] << 4 & 0x30]);
                    break;
                }
                case 2: {
                    out.write(ALPHABET[data[offset + datalen - 1] << 2 & 0x3C]);
                }
            }
        }
    }

    public static void encodeToWriter(Writer out, byte[] data, int offset, int datalen, int buflen) throws IOException {
        int len = 4 * (datalen / 3) + (datalen % 3 != 0 ? 1 + datalen % 3 : 0);
        if (buflen < 1024) {
            buflen = 1024;
        }
        byte[] buf = new byte[buflen > len ? len : buflen];
        OrderPreservingBase64.encodeToWriter(out, data, offset, datalen, buf);
    }

    public static void encodeToWriter(Writer out, byte[] data, int offset, int datalen, byte[] buf) throws IOException {
        int i = 0;
        int len = 4 * (datalen / 3) + (datalen % 3 != 0 ? 1 + datalen % 3 : 0);
        int dataidx = 0;
        int bufidx = 0;
        for (i = offset; i < offset + datalen; ++i) {
            if (buf.length - bufidx < 2) {
                out.write(new String(buf, 0, bufidx, StandardCharsets.US_ASCII));
                bufidx = 0;
            }
            switch (dataidx % 3) {
                case 0: {
                    buf[bufidx++] = ALPHABET[data[i] >> 2 & 0x3F];
                    break;
                }
                case 1: {
                    buf[bufidx++] = ALPHABET[(data[i - 1] & 3) << 4 | data[i] >> 4 & 0xF];
                    break;
                }
                case 2: {
                    buf[bufidx++] = ALPHABET[(data[i - 1] & 0xF) << 2 | data[i] >> 6 & 3];
                    buf[bufidx++] = ALPHABET[data[i] & 0x3F];
                }
            }
            ++dataidx;
        }
        if (bufidx > 0) {
            out.write(new String(buf, 0, bufidx, StandardCharsets.US_ASCII));
        }
        if (dataidx < len) {
            switch (datalen % 3) {
                case 1: {
                    out.write(ALPHABET[data[offset + datalen - 1] << 4 & 0x30]);
                    break;
                }
                case 2: {
                    out.write(ALPHABET[data[offset + datalen - 1] << 2 & 0x3C]);
                }
            }
        }
    }

    public static byte[] decode(byte[] data) {
        return OrderPreservingBase64.decode(data, 0, data.length);
    }

    public static byte[] decode(byte[] data, int offset, int len) {
        byte[] decoded = new byte[3 * (len / 4) + (len % 4 != 0 ? len % 4 - 1 : 0)];
        int idx = 0;
        byte value = 0;
        block6: for (int i = 0; i < len; ++i) {
            switch (i % 4) {
                case 0: {
                    value = (byte)(TEBAHPLA[data[offset + i]] << 2);
                    continue block6;
                }
                case 1: {
                    value = (byte)(value | (byte)(TEBAHPLA[data[offset + i]] >> 4 & 3));
                    decoded[idx++] = value;
                    value = (byte)(TEBAHPLA[data[offset + i]] << 4 & 0xF0);
                    continue block6;
                }
                case 2: {
                    value = (byte)(value | (byte)(TEBAHPLA[data[offset + i]] >> 2 & 0xF));
                    decoded[idx++] = value;
                    value = (byte)(TEBAHPLA[data[offset + i]] << 6 & 0xC0);
                    continue block6;
                }
                case 3: {
                    value = (byte)(value | TEBAHPLA[data[offset + i]]);
                    decoded[idx++] = value;
                }
            }
        }
        if (idx < decoded.length) {
            decoded[idx++] = value;
        }
        return decoded;
    }

    public static byte[] decode(String data) {
        return OrderPreservingBase64.decode(data, 0, data.length());
    }

    public static byte[] decode(String data, int offset, int len) {
        byte[] decoded = new byte[3 * (len / 4) + (len % 4 != 0 ? len % 4 - 1 : 0)];
        int idx = 0;
        byte value = 0;
        block6: for (int i = 0; i < len; ++i) {
            switch (i % 4) {
                case 0: {
                    value = (byte)(TEBAHPLA[data.charAt(offset + i)] << 2);
                    continue block6;
                }
                case 1: {
                    value = (byte)(value | (byte)(TEBAHPLA[data.charAt(offset + i)] >> 4 & 3));
                    decoded[idx++] = value;
                    value = (byte)(TEBAHPLA[data.charAt(offset + i)] << 4 & 0xF0);
                    continue block6;
                }
                case 2: {
                    value = (byte)(value | (byte)(TEBAHPLA[data.charAt(offset + i)] >> 2 & 0xF));
                    decoded[idx++] = value;
                    value = (byte)(TEBAHPLA[data.charAt(offset + i)] << 6 & 0xC0);
                    continue block6;
                }
                case 3: {
                    value = (byte)(value | TEBAHPLA[data.charAt(offset + i)]);
                    decoded[idx++] = value;
                }
            }
        }
        if (idx < decoded.length) {
            decoded[idx++] = value;
        }
        return decoded;
    }

    static {
        Arrays.fill(TEBAHPLA, (byte)-1);
        for (int i = 0; i < ALPHABET.length; ++i) {
            OrderPreservingBase64.TEBAHPLA[OrderPreservingBase64.ALPHABET[i]] = (byte)i;
        }
    }
}

