/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.continuum.gts;

import com.geoxp.GeoXPLib;
import io.warp10.continuum.gts.GTSEncoder;
import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.continuum.gts.Varint;
import io.warp10.continuum.store.thrift.data.Metadata;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.hadoop.hbase.util.Bytes;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.AESWrapEngine;
import org.bouncycastle.crypto.paddings.PKCS7Padding;
import org.bouncycastle.crypto.params.KeyParameter;

public class GTSDecoder {
    private ByteBuffer buffer;
    private GeoTimeSerie.TYPE lastType = null;
    final long baseTimestamp;
    private long lastTimestamp = 0L;
    private long lastGeoXPPoint = 91480763316633925L;
    private long lastElevation = Long.MIN_VALUE;
    private long lastLongValue = Long.MAX_VALUE;
    private boolean lastBooleanValue = false;
    private double lastDoubleValue = Double.NaN;
    private BigDecimal lastBDValue = null;
    private String lastStringValue = null;
    private boolean lastStringBinary = false;
    private long previousLastTimestamp = this.lastTimestamp;
    private long previousLastGeoXPPoint = this.lastGeoXPPoint;
    private long previousLastElevation = this.lastElevation;
    private long previousLastLongValue = this.lastLongValue;
    private double previousLastDoubleValue = this.lastDoubleValue;
    private BigDecimal previousLastBDValue = this.lastBDValue;
    private String previousLastStringValue = this.lastStringValue;
    private boolean nextCalled = false;
    private boolean decodedEncrypted = false;
    private int consumingNextCalls = 0;
    private final byte[] wrappingKey;
    private Metadata metadata;
    private int position;
    private long count = 0L;

    public GTSDecoder(long baseTimestamp, ByteBuffer bb) {
        this.baseTimestamp = baseTimestamp;
        this.buffer = bb;
        this.wrappingKey = null;
    }

    public GTSDecoder(long baseTimestamp, byte[] key, ByteBuffer bb) {
        this.baseTimestamp = baseTimestamp;
        this.buffer = bb;
        this.wrappingKey = (byte[])(null != key ? Arrays.copyOfRange(key, 0, key.length) : null);
        this.position = bb.position();
    }

    public boolean next() {
        this.position = this.buffer.position();
        if (!this.buffer.hasRemaining()) {
            return false;
        }
        this.nextCalled = true;
        byte tsTypeFlag = this.buffer.get();
        if (0 == (tsTypeFlag & 0xFFFFFFFF)) {
            int enclen = (int)Varint.decodeUnsignedLong(this.buffer);
            if (null == this.wrappingKey) {
                this.buffer.position(this.buffer.position() + enclen);
                return this.next();
            }
            byte[] encrypted = new byte[enclen];
            this.buffer.get(encrypted);
            AESWrapEngine engine = new AESWrapEngine();
            KeyParameter params = new KeyParameter(this.wrappingKey);
            engine.init(false, (CipherParameters)params);
            try {
                byte[] decrypted = engine.unwrap(encrypted, 0, encrypted.length);
                PKCS7Padding padding = new PKCS7Padding();
                int padcount = padding.padCount(decrypted);
                ByteBuffer bb = ByteBuffer.allocate(decrypted.length - padcount + this.buffer.remaining());
                bb.put(decrypted, 0, decrypted.length - padcount);
                bb.put(this.buffer);
                bb.flip();
                this.buffer = bb;
                this.decodedEncrypted = true;
            }
            catch (InvalidCipherTextException decrypted) {
                // empty catch block
            }
            return this.next();
        }
        byte locElevFlag = 0;
        if (-128 == (tsTypeFlag & 0xFFFFFF80)) {
            if (!this.buffer.hasRemaining()) {
                return false;
            }
            locElevFlag = this.buffer.get();
        }
        switch (tsTypeFlag & 0x60) {
            case 96: {
                ByteOrder order = this.buffer.order();
                this.buffer.order(ByteOrder.BIG_ENDIAN);
                this.previousLastTimestamp = this.lastTimestamp;
                this.lastTimestamp = this.buffer.getLong();
                this.buffer.order(order);
                break;
            }
            case 32: {
                this.previousLastTimestamp = this.lastTimestamp;
                this.lastTimestamp = this.baseTimestamp;
                break;
            }
            case 64: {
                long delta = Varint.decodeSignedLong(this.buffer);
                this.previousLastTimestamp = this.lastTimestamp;
                this.lastTimestamp = this.baseTimestamp + delta;
                break;
            }
            case 0: {
                long delta = Varint.decodeSignedLong(this.buffer);
                this.previousLastTimestamp = this.lastTimestamp;
                this.lastTimestamp += delta;
                break;
            }
            default: {
                throw new RuntimeException("Invalid timestamp format.");
            }
        }
        if (64 == (locElevFlag & 0x40)) {
            if (16 != (locElevFlag & 0x10)) {
                if (32 == (locElevFlag & 0x20)) {
                    long delta = Varint.decodeSignedLong(this.buffer);
                    this.previousLastGeoXPPoint = this.lastGeoXPPoint;
                    this.lastGeoXPPoint += delta;
                } else {
                    ByteOrder order = this.buffer.order();
                    this.buffer.order(ByteOrder.BIG_ENDIAN);
                    this.previousLastGeoXPPoint = this.lastGeoXPPoint;
                    this.lastGeoXPPoint = this.buffer.getLong();
                    this.buffer.order(order);
                }
            }
        } else {
            this.previousLastGeoXPPoint = this.lastGeoXPPoint;
            this.lastGeoXPPoint = 91480763316633925L;
        }
        if (8 == (locElevFlag & 8)) {
            if (1 != (locElevFlag & 1)) {
                long encoded;
                boolean zigzag;
                boolean bl = zigzag = 4 == (locElevFlag & 4);
                if (zigzag) {
                    encoded = Varint.decodeSignedLong(this.buffer);
                } else {
                    ByteOrder order = this.buffer.order();
                    this.buffer.order(ByteOrder.BIG_ENDIAN);
                    encoded = this.buffer.getLong();
                    this.buffer.order(order);
                }
                if (2 == (locElevFlag & 2)) {
                    this.previousLastElevation = this.lastElevation;
                    this.lastElevation += encoded;
                } else {
                    this.previousLastElevation = this.lastElevation;
                    this.lastElevation = encoded;
                }
            }
        } else {
            this.previousLastElevation = this.lastElevation;
            this.lastElevation = Long.MIN_VALUE;
        }
        switch (tsTypeFlag & 0x18) {
            case 8: {
                this.lastType = GeoTimeSerie.TYPE.LONG;
                if (1 != (tsTypeFlag & 1)) {
                    long encoded;
                    if (4 == (tsTypeFlag & 4)) {
                        encoded = Varint.decodeSignedLong(this.buffer);
                    } else {
                        ByteOrder order = this.buffer.order();
                        this.buffer.order(ByteOrder.BIG_ENDIAN);
                        encoded = this.buffer.getLong();
                        this.buffer.order(order);
                    }
                    if (2 == (tsTypeFlag & 2)) {
                        this.previousLastLongValue = this.lastLongValue;
                        this.lastLongValue += encoded;
                        break;
                    }
                    this.previousLastLongValue = this.lastLongValue;
                    this.lastLongValue = encoded;
                    break;
                }
                this.previousLastLongValue = this.lastLongValue;
                break;
            }
            case 16: {
                this.lastType = GeoTimeSerie.TYPE.DOUBLE;
                if (1 != (tsTypeFlag & 1)) {
                    if (4 == (tsTypeFlag & 4)) {
                        ByteOrder order = this.buffer.order();
                        this.buffer.order(ByteOrder.BIG_ENDIAN);
                        this.previousLastDoubleValue = this.lastDoubleValue;
                        this.lastDoubleValue = this.buffer.getDouble();
                        this.previousLastBDValue = this.lastBDValue;
                        this.lastBDValue = null;
                        this.buffer.order(order);
                        break;
                    }
                    byte scale = this.buffer.get();
                    long unscaled = Varint.decodeSignedLong(this.buffer);
                    this.previousLastBDValue = this.lastBDValue;
                    this.lastBDValue = BigDecimal.valueOf(unscaled, scale);
                    break;
                }
                this.previousLastDoubleValue = this.lastDoubleValue;
                this.previousLastBDValue = this.lastBDValue;
                break;
            }
            case 24: {
                this.lastType = GeoTimeSerie.TYPE.STRING;
                if (1 != (tsTypeFlag & 1)) {
                    long len = Varint.decodeUnsignedLong(this.buffer);
                    if (len > (long)this.buffer.remaining()) {
                        throw new RuntimeException("Invalid string length.");
                    }
                    byte[] bytes = new byte[(int)len];
                    this.buffer.get(bytes);
                    this.previousLastStringValue = this.lastStringValue;
                    boolean binary = 2 == (tsTypeFlag & 2);
                    this.lastStringValue = new String(bytes, binary ? StandardCharsets.ISO_8859_1 : StandardCharsets.UTF_8);
                    this.lastStringBinary = binary;
                    break;
                }
                this.previousLastStringValue = this.lastStringValue;
                this.lastStringBinary = 2 == (tsTypeFlag & 2);
                break;
            }
            case 0: {
                if (7 == (tsTypeFlag & 7)) {
                    this.lastType = GeoTimeSerie.TYPE.UNDEFINED;
                    break;
                }
                this.lastType = GeoTimeSerie.TYPE.BOOLEAN;
                if (4 == (tsTypeFlag & 7)) {
                    this.lastBooleanValue = true;
                    break;
                }
                if (2 == (tsTypeFlag & 7)) {
                    this.lastBooleanValue = false;
                    break;
                }
                throw new RuntimeException("Invalid boolean value.");
            }
            default: {
                throw new RuntimeException("Invalid type encountered!");
            }
        }
        ++this.consumingNextCalls;
        return true;
    }

    public long getTimestamp() {
        return this.lastTimestamp;
    }

    public long getLocation() {
        return this.lastGeoXPPoint;
    }

    public long getElevation() {
        return this.lastElevation;
    }

    public Object getValue() {
        switch (this.lastType) {
            case BOOLEAN: {
                return this.lastBooleanValue;
            }
            case LONG: {
                return this.lastLongValue;
            }
            case DOUBLE: {
                return null == this.lastBDValue ? Double.valueOf(this.lastDoubleValue) : this.lastBDValue;
            }
            case STRING: {
                return this.lastStringValue;
            }
        }
        return null;
    }

    public boolean isBinary() {
        return GeoTimeSerie.TYPE.STRING.equals((Object)this.lastType) && this.lastStringBinary;
    }

    public Object getBinaryValue() {
        Object val = this.getValue();
        if (val instanceof String && this.lastStringBinary) {
            return ((String)val).getBytes(StandardCharsets.ISO_8859_1);
        }
        return val;
    }

    public GeoTimeSerie decode(GeoTimeSerie.TYPE type, boolean strict) {
        GeoTimeSerie gts = new GeoTimeSerie(this.count > 0L ? (int)Math.min(Integer.MAX_VALUE, this.count) : Math.max(16, this.buffer.remaining() / 10));
        if (null != type) {
            gts.setType(type);
        }
        gts.setMetadata(this.getMetadata());
        if (strict) {
            Class<Object> lastClass = null;
            while (this.next()) {
                Object value = this.getValue();
                Class<Object> valClass = value.getClass();
                if (value instanceof BigDecimal) {
                    valClass = Double.class;
                }
                if (null != lastClass && !valClass.equals(lastClass)) {
                    throw new RuntimeException("Non homogeneous GTS Encoder.");
                }
                lastClass = valClass;
                GTSHelper.setValue(gts, this.getTimestamp(), this.getLocation(), this.getElevation(), value, false);
            }
        } else {
            while (this.next()) {
                GTSHelper.setValue(gts, this.getTimestamp(), this.getLocation(), this.getElevation(), this.getValue(), false);
            }
        }
        return gts;
    }

    public GeoTimeSerie decode(GeoTimeSerie.TYPE type) {
        return this.decode(type, false);
    }

    public GeoTimeSerie decode() {
        return this.decode(null, false);
    }

    public GTSEncoder getCompatibleEncoder(long basets) {
        GTSEncoder encoder = new GTSEncoder(basets, this.wrappingKey);
        encoder.setMetadata(this.getMetadata());
        return encoder;
    }

    public long getBaseTimestamp() {
        return this.baseTimestamp;
    }

    public long getClassId() {
        return this.getMetadata().getClassId();
    }

    public void setClassId(long classId) {
        this.getMetadata().setClassId(classId);
    }

    public long getLabelsId() {
        return this.getMetadata().getLabelsId();
    }

    public void setLabelsId(long labelsId) {
        this.getMetadata().setLabelsId(labelsId);
    }

    public String getName() {
        return this.getMetadata().getName();
    }

    public void setName(String name) {
        this.getMetadata().setName(name);
    }

    public Map<String, String> getLabels() {
        return Collections.unmodifiableMap(this.getMetadata().getLabels());
    }

    public void setLabels(Map<String, String> labels) {
        this.getMetadata().setLabels(new HashMap<String, String>(labels));
    }

    public void setLabel(String key, String value) {
        this.getMetadata().getLabels().put(key, value);
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = new Metadata(metadata);
    }

    public void safeSetMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public Metadata getMetadata() {
        if (null == this.metadata) {
            this.metadata = new Metadata();
        }
        if (null == this.metadata.getLabels()) {
            this.metadata.setLabels(new HashMap<String, String>());
        }
        if (null == this.metadata.getAttributes()) {
            this.metadata.setAttributes(new HashMap<String, String>());
        }
        return this.metadata;
    }

    public Metadata getRawMetadata() {
        return this.metadata;
    }

    public GTSEncoder getEncoder(boolean safeMetadata) throws IOException {
        if (!this.nextCalled) {
            throw new IOException("Can only get an encoder for a decoder on which 'next' was called at least once.");
        }
        ByteBuffer bb = this.buffer.duplicate();
        bb.position(this.position);
        int offset = 0;
        int len = bb.remaining();
        byte[] bytes = null;
        if (bb.hasArray()) {
            bytes = bb.array();
            offset = bb.arrayOffset() + bb.position();
        } else {
            bytes = new byte[bb.remaining()];
            bb.get(bytes);
        }
        GTSEncoder encoder = new GTSEncoder(this.baseTimestamp, this.wrappingKey, bb.remaining());
        if (safeMetadata) {
            encoder.safeSetMetadata(this.getMetadata());
        } else {
            encoder.setMetadata(this.getMetadata());
        }
        encoder.initialize(this.previousLastTimestamp, this.previousLastGeoXPPoint, this.previousLastElevation, this.previousLastLongValue, this.previousLastDoubleValue, this.previousLastBDValue, this.previousLastStringValue);
        encoder.stream.write(bytes, offset, len);
        encoder.safeDelta();
        if (!this.decodedEncrypted) {
            encoder.setCount(this.count - (long)this.consumingNextCalls + 1L);
        }
        return encoder;
    }

    public GTSEncoder getEncoder() throws IOException {
        return this.getEncoder(false);
    }

    public int getRemainingSize() {
        return this.buffer.remaining();
    }

    void initialize(long initialTimestamp, long initialGeoXPPoint, long initialElevation, long initialLongValue, double initialDoubleValue, BigDecimal initialBDValue, String initialStringValue) {
        this.lastTimestamp = initialTimestamp;
        this.lastGeoXPPoint = initialGeoXPPoint;
        this.lastElevation = initialElevation;
        this.lastLongValue = initialLongValue;
        this.lastDoubleValue = initialDoubleValue;
        this.lastBDValue = initialBDValue;
        this.lastStringValue = initialStringValue;
    }

    public long getCount() {
        return this.count;
    }

    void setCount(long count) {
        this.count = count;
    }

    public GTSDecoder dedup() throws IOException {
        if (this.nextCalled) {
            throw new IOException("Unable to dedup a decoder for which next has been called.");
        }
        GTSEncoder dedupped = new GTSEncoder(0L);
        dedupped.setMetadata(this.getMetadata());
        boolean first = true;
        long timestamp = 0L;
        long location = 91480763316633925L;
        long elevation = Long.MIN_VALUE;
        Object value = null;
        boolean dup = true;
        while (this.next()) {
            dup = true;
            if (first) {
                first = false;
                dup = false;
                timestamp = this.getTimestamp();
                location = this.getLocation();
                elevation = this.getElevation();
                value = this.getBinaryValue();
                dedupped.addValue(timestamp, location, elevation, value);
                continue;
            }
            long newTimestamp = this.getTimestamp();
            long newloc = this.getLocation();
            long newelev = this.getElevation();
            Object newValue = this.getBinaryValue();
            if (location != newloc || elevation != newelev) {
                dup = false;
            }
            if (dup) {
                if (null == value) {
                    dup = false;
                } else if (value instanceof Number) {
                    if (!((Number)value).equals(newValue)) {
                        dup = false;
                    }
                } else if (value instanceof String) {
                    if (!((String)value).equals(newValue)) {
                        dup = false;
                    }
                } else if (value instanceof Boolean) {
                    if (!((Boolean)value).equals(newValue)) {
                        dup = false;
                    }
                } else if (value instanceof byte[]) {
                    if (newValue instanceof byte[]) {
                        if (0 != Bytes.compareTo((byte[])((byte[])value), (byte[])((byte[])newValue))) {
                            dup = false;
                        }
                    } else {
                        dup = false;
                    }
                }
            }
            timestamp = newTimestamp;
            location = newloc;
            elevation = newelev;
            value = newValue;
            if (dup) continue;
            dedupped.addValue(timestamp, location, elevation, value);
        }
        if (dup) {
            dedupped.addValue(timestamp, location, elevation, value);
        }
        return dedupped.getDecoder();
    }

    public ByteBuffer getBuffer() {
        return this.buffer.asReadOnlyBuffer();
    }

    public GTSDecoder duplicate() {
        GTSDecoder decoder = new GTSDecoder(this.baseTimestamp, this.wrappingKey, this.buffer.asReadOnlyBuffer());
        decoder.safeSetMetadata(new Metadata(this.getMetadata()));
        decoder.consumingNextCalls = this.consumingNextCalls;
        decoder.count = this.count;
        decoder.decodedEncrypted = this.decodedEncrypted;
        decoder.nextCalled = this.nextCalled;
        decoder.position = this.position;
        decoder.previousLastBDValue = this.previousLastBDValue;
        decoder.previousLastDoubleValue = this.previousLastDoubleValue;
        decoder.previousLastElevation = this.previousLastElevation;
        decoder.previousLastGeoXPPoint = this.previousLastGeoXPPoint;
        decoder.previousLastLongValue = this.previousLastLongValue;
        decoder.previousLastStringValue = this.previousLastStringValue;
        decoder.previousLastTimestamp = this.previousLastTimestamp;
        decoder.lastTimestamp = this.lastTimestamp;
        decoder.lastGeoXPPoint = this.lastGeoXPPoint;
        decoder.lastElevation = this.lastElevation;
        decoder.lastLongValue = this.lastLongValue;
        decoder.lastDoubleValue = this.lastDoubleValue;
        decoder.lastBDValue = this.lastBDValue;
        decoder.lastStringValue = this.lastStringValue;
        decoder.lastBooleanValue = this.lastBooleanValue;
        decoder.lastType = this.lastType;
        decoder.lastStringBinary = this.lastStringBinary;
        return decoder;
    }

    public void dump(PrintWriter pw) {
        StringBuilder sb = new StringBuilder(" ");
        GTSHelper.encodeName(sb, this.getName());
        sb.append("{");
        boolean first = true;
        for (Map.Entry<String, String> entry : this.getLabels().entrySet()) {
            if (!first) {
                sb.append(",");
            }
            GTSHelper.encodeName(sb, entry.getKey());
            sb.append("=");
            GTSHelper.encodeName(sb, entry.getValue());
            first = false;
        }
        sb.append("} ");
        String clslbs = sb.toString();
        first = true;
        while (this.next()) {
            if (!first) {
                pw.print("=");
            }
            pw.print(this.getTimestamp());
            pw.print("/");
            long l = this.getLocation();
            if (91480763316633925L != l) {
                double[] latlon = GeoXPLib.fromGeoXPPoint((long)l);
                pw.print(latlon[0]);
                pw.print(":");
                pw.print(latlon[1]);
            }
            pw.print("/");
            l = this.getElevation();
            if (Long.MIN_VALUE != l) {
                pw.print(l);
            }
            if (first) {
                pw.print(clslbs);
                first = false;
            } else {
                pw.print(" ");
            }
            sb.setLength(0);
            GTSHelper.encodeValue(sb, this.getBinaryValue());
            pw.print(sb.toString());
            pw.print("\r\n");
        }
    }

    public static GTSDecoder fromBlock(byte[] block, byte[] key) throws IOException {
        int len;
        if (block.length < 6) {
            throw new IOException("Invalid block.");
        }
        ByteBuffer buffer = ByteBuffer.wrap(block);
        buffer.order(ByteOrder.BIG_ENDIAN);
        int size = buffer.getInt();
        if (block.length != size) {
            throw new IOException("Invalid block size, expected " + size + ", block is " + block.length);
        }
        byte comp = buffer.get();
        boolean compress = false;
        if (0 == comp) {
            compress = false;
        } else if (1 == comp) {
            compress = true;
        } else {
            throw new IOException("Invalid compression flag");
        }
        long base = Varint.decodeSignedLong(buffer);
        ByteArrayInputStream bain = new ByteArrayInputStream(block, buffer.position(), buffer.remaining());
        InputStream in = compress ? new GZIPInputStream(bain) : bain;
        byte[] buf = new byte[1024];
        ByteArrayOutputStream out = new ByteArrayOutputStream(buffer.remaining());
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        GTSDecoder decoder = new GTSDecoder(base, key, ByteBuffer.wrap(out.toByteArray()));
        return decoder;
    }
}

