/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.warp.sdk;

import io.warp10.WarpURLEncoder;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;

public abstract class DirectoryPlugin {
    public static final int VERSION = 2;

    public abstract void init(Properties var1);

    public abstract boolean store(String var1, GTS var2);

    public abstract boolean delete(GTS var1);

    public abstract GTSIterator find(int var1, String var2, Map<String, String> var3);

    public boolean known(GTS gts) {
        return false;
    }

    public static abstract class GTSIterator
    implements Iterator<GTS>,
    AutoCloseable {
    }

    public static class GTS {
        private final String id;
        private UUID uuid;
        private final String name;
        private final Map<String, String> labels;
        private final Map<String, String> attributes;
        private String representation = null;

        public GTS(String id, String name, Map<String, String> labels, Map<String, String> attributes) {
            this.id = id;
            this.name = name;
            this.labels = new HashMap<String, String>(labels);
            this.attributes = new HashMap<String, String>(attributes);
        }

        @Deprecated
        public GTS(UUID uuid, String name, Map<String, String> labels, Map<String, String> attributes) {
            this.uuid = uuid;
            this.id = uuid.toString();
            this.name = name;
            this.labels = new HashMap<String, String>(labels);
            this.attributes = new HashMap<String, String>(attributes);
        }

        public String getId() {
            return this.id;
        }

        @Deprecated
        public UUID getUuid() {
            return this.uuid;
        }

        public String getName() {
            return this.name;
        }

        public Map<String, String> getLabels() {
            return Collections.unmodifiableMap(this.labels);
        }

        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public String toString() {
            if (null == this.representation) {
                StringBuilder sb = new StringBuilder();
                sb.append("[");
                sb.append(this.id.toString());
                sb.append("] ");
                this.encode(sb, this.name);
                sb.append("{");
                boolean first = true;
                for (Map.Entry<String, String> entry : this.labels.entrySet()) {
                    if (!first) {
                        sb.append(",");
                    }
                    this.encode(sb, entry.getKey());
                    sb.append("=");
                    this.encode(sb, entry.getValue());
                    first = false;
                }
                sb.append("}");
                sb.append("{");
                first = true;
                for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
                    if (!first) {
                        sb.append(",");
                    }
                    this.encode(sb, entry.getKey());
                    sb.append("=");
                    this.encode(sb, entry.getValue());
                    first = false;
                }
                sb.append("}");
                this.representation = sb.toString();
            }
            return this.representation;
        }

        private void encode(StringBuilder sb, String str) {
            try {
                String encoded = WarpURLEncoder.encode(str, StandardCharsets.UTF_8);
                sb.append(encoded);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }
}

