/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.processing.image;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import processing.core.PGraphics;
import processing.core.PImage;

public class Presize
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public Presize(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof Long)) {
            throw new WarpScriptException(this.getName() + " expects a height in pixel.");
        }
        int height = -1;
        try {
            height = Math.toIntExact((Long)top);
            if (height < 0) {
                throw new IllegalArgumentException();
            }
        }
        catch (ArithmeticException | IllegalArgumentException e) {
            throw new WarpScriptException(this.getName() + " expects the height to be positive and less than " + Integer.MAX_VALUE + ".");
        }
        top = stack.pop();
        if (!(top instanceof Long)) {
            throw new WarpScriptException(this.getName() + " expects a width in pixel.");
        }
        int width = -1;
        try {
            width = Math.toIntExact((Long)top);
            if (width < 0) {
                throw new IllegalArgumentException();
            }
        }
        catch (ArithmeticException | IllegalArgumentException e) {
            throw new WarpScriptException(this.getName() + " expects the height to be positive and less than " + Integer.MAX_VALUE + ".");
        }
        long PIXEL_LIMIT = (Long)stack.getAttribute("stack.maxpixels");
        if ((long)width * (long)height > PIXEL_LIMIT) {
            throw new WarpScriptException(this.getName() + " only allows " + "PGRAPHICS" + " or " + "PIMAGE" + " with a total number of pixels less than " + PIXEL_LIMIT + " requested size was " + width + "x" + height + " (" + (long)width * (long)height + ").");
        }
        top = stack.pop();
        if (top instanceof PGraphics) {
            PGraphics pg = (PGraphics)top;
            pg.endDraw();
            PImage img = new PImage(pg.image);
            img.resize(width, height);
            img.loadPixels();
            pg.image = img.getImage();
            pg.pixels = img.pixels;
            pg.pixelWidth = img.pixelWidth;
            pg.pixelHeight = img.pixelHeight;
            pg.width = img.width;
            pg.height = img.height;
            pg.pixelDensity = img.pixelDensity;
            pg.updatePixels();
            pg.beginDraw();
            stack.push(pg);
        } else if (top instanceof PImage) {
            PImage img = (PImage)top;
            img.resize(width, height);
            stack.push(img);
        } else {
            throw new WarpScriptException(this.getName() + " expects a " + "PIMAGE" + " or a " + "PGRAPHICS" + " instance.");
        }
        return stack;
    }
}

