/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.mapper;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.StackUtils;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptMapperFunction;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.List;

public class MapperDotProduct
extends NamedWarpScriptFunction
implements WarpScriptMapperFunction {
    private final double[] omega;

    public MapperDotProduct(String name, double[] omega) {
        super(name);
        this.omega = omega;
    }

    @Override
    public Object apply(Object[] args) throws WarpScriptException {
        long tick = (Long)args[0];
        long[] locations = (long[])args[4];
        long[] elevations = (long[])args[5];
        Object[] values = (Object[])args[6];
        long[] window = (long[])args[7];
        if (0 == values.length || this.omega.length != values.length) {
            return new Object[]{tick, 91480763316633925L, Long.MIN_VALUE, null};
        }
        if (!(values[0] instanceof Number)) {
            throw new WarpScriptException(this.getName() + " can only be applied to LONG or DOUBLE values.");
        }
        int tickidx = (int)window[4];
        long location = locations[tickidx];
        long elevation = elevations[tickidx];
        double dotproduct = 0.0;
        for (int i = 0; i < this.omega.length; ++i) {
            dotproduct += this.omega[i] * ((Number)values[i]).doubleValue();
        }
        return new Object[]{tick, location, elevation, dotproduct};
    }

    public double[] getOmega() {
        return this.omega;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append(" ");
        for (double d : this.omega) {
            sb.append(StackUtils.toString(d));
            sb.append(" ");
        }
        sb.append("]");
        sb.append(" ");
        sb.append(this.getName());
        return sb.toString();
    }

    public static class Builder
    extends NamedWarpScriptFunction
    implements WarpScriptStackFunction {
        public Builder(String name) {
            super(name);
        }

        @Override
        public Object apply(WarpScriptStack stack) throws WarpScriptException {
            Object top = stack.pop();
            if (!(top instanceof List)) {
                throw new WarpScriptException(this.getName() + " expects an input vector (list of doubles) on top of the stack.");
            }
            double[] omega = new double[((List)top).size()];
            for (int i = 0; i < omega.length; ++i) {
                double d;
                omega[i] = d = ((Double)((List)top).get(i)).doubleValue();
            }
            stack.push(new MapperDotProduct(this.getName(), omega));
            return stack;
        }
    }
}

