/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.gts.Varint;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class VARINTTO
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public VARINTTO(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        long count = Long.MAX_VALUE;
        boolean countbased = false;
        if (top instanceof Long) {
            count = (Long)top;
            countbased = true;
            top = stack.pop();
        }
        if (!(top instanceof byte[])) {
            throw new WarpScriptException(this.getName() + " operates on a byte array.");
        }
        byte[] data = (byte[])top;
        ByteBuffer bb = ByteBuffer.wrap(data);
        ArrayList<Long> values = new ArrayList<Long>();
        try {
            while (bb.hasRemaining() && count > 0L) {
                long value = Varint.decodeUnsignedLong(bb);
                values.add(value);
                --count;
            }
        }
        catch (IllegalArgumentException iae) {
            throw new WarpScriptException(this.getName() + " error while decoding values.", iae);
        }
        stack.push(values);
        if (countbased) {
            stack.push(data.length - bb.remaining());
        }
        return stack;
    }
}

