/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.gts.GTSDecoder;
import io.warp10.continuum.gts.GTSEncoder;
import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.ElementOrListStackFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import java.util.ArrayList;

public class VALUES
extends ElementOrListStackFunction {
    private final ElementOrListStackFunction.ElementStackFunction valuesFunction = new ElementOrListStackFunction.ElementStackFunction(){

        @Override
        public Object applyOnElement(Object element) throws WarpScriptException {
            if (element instanceof GeoTimeSerie) {
                GeoTimeSerie gts = (GeoTimeSerie)element;
                int nvalues = GTSHelper.nvalues(gts);
                ArrayList<Object> values = new ArrayList<Object>(nvalues);
                for (int i = 0; i < nvalues; ++i) {
                    values.add(GTSHelper.valueAtIndex(gts, i));
                }
                return values;
            }
            if (element instanceof GTSEncoder) {
                GTSEncoder encoder = (GTSEncoder)element;
                int nvalues = (int)encoder.getCount();
                ArrayList<Object> values = new ArrayList<Object>(nvalues);
                GTSDecoder decoder = encoder.getDecoder(true);
                while (decoder.next()) {
                    values.add(decoder.getBinaryValue());
                }
                return values;
            }
            throw new WarpScriptException(VALUES.this.getName() + " expects a GeoTimeSeries, a GTSEncoder or a list thereof on top of the stack.");
        }
    };

    public VALUES(String name) {
        super(name);
    }

    @Override
    public ElementOrListStackFunction.ElementStackFunction generateFunction(WarpScriptStack stack) throws WarpScriptException {
        return this.valuesFunction;
    }
}

