/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.ElementOrListStackFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;

public class TIMESCALE
extends ElementOrListStackFunction {
    public TIMESCALE(String name) {
        super(name);
    }

    @Override
    public ElementOrListStackFunction.ElementStackFunction generateFunction(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof Long) && !(top instanceof Double)) {
            throw new WarpScriptException(this.getName() + " expects a time scale on top of the stack.");
        }
        final double scale = ((Number)top).doubleValue();
        return new ElementOrListStackFunction.ElementStackFunction(){

            @Override
            public Object applyOnElement(Object element) throws WarpScriptException {
                if (element instanceof GeoTimeSerie) {
                    return GTSHelper.timescale((GeoTimeSerie)element, scale);
                }
                throw new WarpScriptException(TIMESCALE.this.getName() + " expects a Geo Time Series or a list thereof under the scale parameter.");
            }
        };
    }
}

