/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.WarpConfig;
import io.warp10.continuum.store.Constants;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.functions.DURATION;
import io.warp10.warp.sdk.Capabilities;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import org.joda.time.Instant;

public class TIMEBOX
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private static final long DEFAULT_TIMEBOX_MAXTIME = 30000L;
    private static final long TIMEBOX_MAXTIME = Long.parseLong(WarpConfig.getProperty("warpscript.timebox.maxtime", Long.toString(30000L)));
    public static final String TIMEBOX_MAXTIME_CAPNAME = WarpConfig.getProperty("warpscript.timebox.maxtime.capname");
    private final WarpScriptStack.Signal signal;
    private final boolean cap;
    private final boolean quiet;

    public TIMEBOX(String name) {
        super(name);
        this.signal = null;
        this.cap = true;
        this.quiet = false;
    }

    public TIMEBOX(String name, WarpScriptStack.Signal signal, boolean cap, boolean quiet) {
        super(name);
        this.signal = signal;
        this.cap = cap;
        this.quiet = quiet;
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof Long)) {
            throw new WarpScriptException(this.getName() + " expects a maximum execution time on top of the stack.");
        }
        long maxtimeParam = Math.max(0L, ((Number)top).longValue());
        long maxtime = !this.cap ? 0L : TIMEBOX_MAXTIME * Constants.TIME_UNITS_PER_MS;
        top = stack.pop();
        if (!(top instanceof WarpScriptStack.Macro)) {
            throw new WarpScriptException(this.getName() + " operates on a macro.");
        }
        long maxtimeCapability = 0L;
        if (this.cap && maxtime > 0L && null != TIMEBOX_MAXTIME_CAPNAME && null != Capabilities.get(stack, TIMEBOX_MAXTIME_CAPNAME)) {
            String val = Capabilities.get(stack, TIMEBOX_MAXTIME_CAPNAME).trim();
            if (val.startsWith("P")) {
                maxtimeCapability = DURATION.parseDuration(new Instant(), val, true, false);
            } else {
                try {
                    maxtimeCapability = Long.valueOf(Capabilities.get(stack, TIMEBOX_MAXTIME_CAPNAME)) * Constants.TIME_UNITS_PER_MS;
                }
                catch (NumberFormatException nfe) {
                    throw new WarpScriptException(this.getName() + " invalid value for capability '" + TIMEBOX_MAXTIME_CAPNAME + "'.");
                }
            }
            maxtimeCapability = Math.max(0L, maxtimeCapability);
            maxtime = maxtimeCapability > 0L ? Math.max(maxtime, maxtimeCapability) : 0L;
        }
        maxtime = this.cap && maxtimeParam > 0L ? (maxtime > 0L ? Math.min(maxtime, maxtimeParam) : maxtimeParam) : maxtimeParam;
        final WarpScriptStack.Macro macro = (WarpScriptStack.Macro)top;
        final WarpScriptStack fstack = stack;
        Boolean timeboxed = Boolean.TRUE.equals(fstack.getAttribute("stack.timeboxed"));
        fstack.setAttribute("stack.timeboxed", true);
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Future<Object> future = executorService.submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                fstack.exec(macro);
                return fstack;
            }
        });
        try {
            future.get(maxtime, Constants.timeunit);
        }
        catch (TimeoutException te) {
            if (null != this.signal) {
                stack.signal(this.signal);
            }
            throw new WarpScriptException(this.getName() + " reached the execution time limit (" + maxtime + " " + Constants.timeunit.name() + ").");
        }
        catch (ExecutionException ee) {
            if (this.quiet && ee.getCause() instanceof WarpScriptException) {
                throw (WarpScriptException)ee.getCause();
            }
            throw new WarpScriptException(this.getName() + " encountered an exception while executing macro", ee.getCause());
        }
        catch (Exception e) {
            throw new WarpScriptException(this.getName() + " encountered an exception", e);
        }
        finally {
            executorService.shutdown();
            executorService.shutdownNow();
            fstack.setAttribute("stack.timeboxed", timeboxed);
            if (!executorService.isShutdown()) {
                throw new WarpScriptException(this.getName() + " could not be properly shut down.");
            }
        }
        return stack;
    }
}

