/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.GTSStackFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import java.util.HashMap;
import java.util.Map;

public class RLOWESS
extends GTSStackFunction {
    private static final String BANDWIDTH_PARAM = "q";
    private static final String ROBUSTNESS_PARAM = "r";
    private static final String DELTA_PARAM = "d";
    private static final String DEGREE_PARAM = "p";

    public RLOWESS(String name) {
        super(name);
    }

    @Override
    protected Map<String, Object> retrieveParameters(WarpScriptStack stack) throws WarpScriptException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        Object top = stack.pop();
        if (!(top instanceof Long)) {
            throw new WarpScriptException(this.getName() + " expects a degree (a LONG) for the polynomial fit on top of the stack.");
        }
        params.put(DEGREE_PARAM, ((Number)top).intValue());
        top = stack.pop();
        if (!(top instanceof Long)) {
            throw new WarpScriptException(this.getName() + " expects a delta radius (a LONG in \u00b5s) within which LOWESS is computed only once, in 2nd position from the top of the stack.");
        }
        params.put(DELTA_PARAM, ((Number)top).longValue());
        top = stack.pop();
        if (!(top instanceof Long)) {
            throw new WarpScriptException(this.getName() + " expects a number of robustness iteration (a LONG) in 3rd position from the top of the stack.");
        }
        params.put(ROBUSTNESS_PARAM, ((Number)top).intValue());
        top = stack.pop();
        if (!(top instanceof Long)) {
            throw new WarpScriptException(this.getName() + " expects a bandwidth (a LONG) in 4th position from the top of the stack.");
        }
        params.put(BANDWIDTH_PARAM, ((Number)top).intValue());
        return params;
    }

    @Override
    protected Object gtsOp(Map<String, Object> params, GeoTimeSerie gts) throws WarpScriptException {
        int q = (Integer)params.get(BANDWIDTH_PARAM);
        int r = (Integer)params.get(ROBUSTNESS_PARAM);
        long d = (Long)params.get(DELTA_PARAM);
        int p = (Integer)params.get(DEGREE_PARAM);
        if (d < 0L) {
            d = (long)Math.pow(10.0, d) * (GTSHelper.lasttick(gts) - GTSHelper.firsttick(gts));
        }
        return GTSHelper.rlowess(gts, q, r, d, p);
    }
}

