/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.Revision;
import io.warp10.WarpConfig;
import io.warp10.crypto.SipHashInline;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptLib;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.sensision.Sensision;
import io.warp10.warp.sdk.AbstractWarp10Plugin;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class REPORT
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private static final Logger LOG = LoggerFactory.getLogger(REPORT.class);
    private static final String SECRET;
    private static final AtomicLong seq;
    private static final AtomicBoolean success;
    private static final String uuid;
    private static boolean initialized;

    public REPORT(String name) {
        super(name);
        if (!initialized && !"false".equals(WarpConfig.getProperty("warp10.telemetry"))) {
            REPORT.telinit();
        }
        initialized = true;
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!SECRET.equals(top.toString())) {
            throw new WarpScriptException(this.getName() + " invalid secret.");
        }
        try {
            stack.push(REPORT.genReport(true));
        }
        catch (WarpScriptException wse) {
            throw new WarpScriptException(this.getName() + " failed.", wse);
        }
        return stack;
    }

    /*
     * WARNING - void declaration
     */
    public static String genReport(boolean includeConf) throws WarpScriptException {
        try {
            void var5_12;
            StringBuilder sb = new StringBuilder();
            sb.append("\n[revision]\n");
            sb.append(Revision.REVISION);
            sb.append("\n");
            sb.append("\n[jvm]\n");
            sb.append("free=");
            sb.append(Runtime.getRuntime().freeMemory());
            sb.append("\n");
            sb.append("total=");
            sb.append(Runtime.getRuntime().totalMemory());
            sb.append("\n");
            sb.append("max=");
            sb.append(Runtime.getRuntime().maxMemory());
            sb.append("\n");
            sb.append("cpus=");
            sb.append(Runtime.getRuntime().availableProcessors());
            sb.append("\n");
            sb.append("\n[sensision]\n");
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            Sensision.dump((PrintWriter)pw);
            pw.close();
            sb.append(sw.toString());
            sb.append("\n[extensions]\n");
            for (String string : WarpScriptLib.extensions()) {
                sb.append(string);
                sb.append("\n");
            }
            sb.append("\n[plugins]\n");
            for (String string : AbstractWarp10Plugin.plugins()) {
                sb.append(string);
                sb.append("\n");
            }
            if (includeConf) {
                sb.append("\n[config]\n");
                Properties properties = WarpConfig.getProperties();
                for (Object entry : properties.entrySet()) {
                    String key = entry.getKey().toString();
                    if (key.contains(".key") || key.contains(".aes") || key.contains(".hash") || key.contains(".mac") || key.contains(".psk") || key.contains(".secret") || properties.contains("warp.secret." + key)) continue;
                    sb.append(key);
                    sb.append("=");
                    String value = entry.getValue().toString();
                    sb.append(value);
                    sb.append("\n");
                }
            }
            byte[] data = sb.toString().getBytes(StandardCharsets.UTF_8);
            boolean bl = false;
            for (byte b : data) {
                if (10 != b) continue;
                ++var5_12;
            }
            long sip = SipHashInline.hash24(data.length, data.length, data, 0, data.length);
            sb.insert(0, "\n");
            sb.insert(0, Long.toHexString(sip));
            sb.insert(0, ".");
            sb.insert(0, (int)var5_12);
            sb.insert(0, ".");
            sb.insert(0, System.currentTimeMillis());
            sb.insert(0, "[report]\n");
            return sb.toString();
        }
        catch (Exception e) {
            throw new WarpScriptException("Error while generating report.", e);
        }
    }

    private static final void telinit() {
        try {
            Thread telemetry = new Thread(){

                @Override
                public void run() {
                    boolean first = true;
                    long delay = 28800000000000L;
                    while (true) {
                        if (!first) {
                            LockSupport.parkNanos(delay);
                        }
                        first = false;
                        long newdelay = REPORT.telemetry();
                        if (newdelay <= 0L) continue;
                        delay = newdelay;
                    }
                }
            };
            telemetry.setDaemon(true);
            telemetry.setName("Warp Telemetry Thread");
            telemetry.start();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    seq.set(Long.MIN_VALUE);
                    if (success.get()) {
                        REPORT.telemetry();
                    }
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static long telemetry() {
        block21: {
            HttpURLConnection conn = null;
            try {
                String report = REPORT.genReport(false);
                success.set(false);
                conn = (HttpURLConnection)new URL("https://telemetry.senx.io/report").openConnection();
                conn.setDoOutput(true);
                if (0L == seq.get()) {
                    conn.addRequestProperty("X-Warp10-Telemetry-Event", "start");
                } else if (seq.get() < 0L) {
                    conn.addRequestProperty("X-Warp10-Telemetry-Event", "stop");
                } else {
                    conn.addRequestProperty("X-Warp10-Telemetry-Event", "report");
                }
                seq.addAndGet(1L);
                conn.addRequestProperty("X-Warp10-Telemetry-UUID", uuid);
                conn.addRequestProperty("Content-Type", "application/gzip");
                OutputStream out = conn.getOutputStream();
                GZIPOutputStream zout = new GZIPOutputStream(out);
                ((OutputStream)zout).write(report.getBytes(StandardCharsets.UTF_8));
                ((OutputStream)zout).close();
                out.close();
                String newdelay = conn.getHeaderField("X-Warp10-Telemetry-Delay");
                success.set(true);
                if (null != newdelay) {
                    try {
                        long l = Long.parseLong(newdelay);
                        return l;
                    }
                    catch (Throwable throwable) {}
                }
                break block21;
                {
                    catch (Throwable throwable2) {
                    }
                }
            }
            finally {
                if (null != conn) {
                    try {
                        conn.disconnect();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        return 0L;
    }

    static {
        seq = new AtomicLong(0L);
        success = new AtomicBoolean(false);
        uuid = UUID.randomUUID().toString();
        initialized = false;
        String defaultSecret = UUID.randomUUID().toString();
        if (defaultSecret.equals(SECRET = WarpConfig.getProperty("warp10.report.secret", defaultSecret))) {
            LOG.info("REPORT secret not set, using '" + defaultSecret + "'.");
        }
    }
}

