/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.StackUtils;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.HashMap;
import java.util.Map;

public class PROBABILITY
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private final Map<Object, Double> probabilities;

    public PROBABILITY(String name, Map<Object, Double> probabilities) {
        super(name);
        this.probabilities = probabilities;
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object o = stack.pop();
        if (!this.probabilities.containsKey(o)) {
            stack.push(0.0);
        } else {
            stack.push(this.probabilities.get(o));
        }
        return stack;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append(" ");
        for (Map.Entry<Object, Double> entry : this.probabilities.entrySet()) {
            sb.append(StackUtils.toString(entry.getKey()));
            sb.append(" ");
            sb.append(StackUtils.toString(entry.getValue()));
            sb.append(" ");
        }
        sb.append(" ");
        sb.append("}");
        sb.append(" ");
        sb.append(this.getName());
        return sb.toString();
    }

    public static class Builder
    extends NamedWarpScriptFunction
    implements WarpScriptStackFunction {
        public Builder(String name) {
            super(name);
        }

        @Override
        public Object apply(WarpScriptStack stack) throws WarpScriptException {
            Object histogram = stack.pop();
            if (!(histogram instanceof Map)) {
                throw new WarpScriptException(this.getName() + " expects a value histogram on top of the stack.");
            }
            HashMap<Object, Double> probabilities = new HashMap<Object, Double>();
            double total = 0.0;
            for (Number number : ((Map)histogram).values()) {
                total += number.doubleValue();
            }
            for (Map.Entry entry : ((Map)histogram).entrySet()) {
                probabilities.put(entry.getKey(), ((Number)entry.getValue()).doubleValue() / total);
            }
            stack.push(new PROBABILITY(this.getName(), probabilities));
            return stack;
        }
    }
}

