/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import com.geoxp.GeoXPLib;
import io.warp10.continuum.gts.GTSDecoder;
import io.warp10.continuum.gts.GTSEncoder;
import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GTSWrapperHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.continuum.store.thrift.data.GTSWrapper;
import io.warp10.script.ElementOrListStackFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;

public class MVEXTRACT
extends ElementOrListStackFunction
implements ElementOrListStackFunction.ElementStackFunction {
    private final ELEMENT elementType;

    public MVEXTRACT(String name, ELEMENT element) {
        super(name);
        this.elementType = element;
    }

    @Override
    public ElementOrListStackFunction.ElementStackFunction generateFunction(WarpScriptStack stack) throws WarpScriptException {
        return this;
    }

    @Override
    public Object applyOnElement(Object element) throws WarpScriptException {
        if (!(element instanceof GTSEncoder) && !(element instanceof GeoTimeSerie)) {
            throw new WarpScriptException(this.getName() + " can only be applied on Geo Time Series\u2122 or GTS Encoders.");
        }
        try {
            return this.mvextract(element);
        }
        catch (WarpScriptException wse) {
            throw new WarpScriptException(this.getName() + " failed.", wse);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<Object> mvextract(Object element) throws WarpScriptException {
        ArrayList<Object> values = new ArrayList<Object>();
        GTSDecoder decoder = null;
        GeoTimeSerie gts = null;
        int nvalues = 0;
        if (element instanceof GTSEncoder) {
            decoder = ((GTSEncoder)element).getDecoder();
        } else {
            gts = (GeoTimeSerie)element;
            nvalues = GTSHelper.nvalues(gts);
        }
        int idx = -1;
        TDeserializer deser = new TDeserializer((TProtocolFactory)new TCompactProtocol.Factory());
        GTSWrapper wrapper = new GTSWrapper();
        while (true) {
            boolean done;
            boolean bl = !(null != decoder ? decoder.next() : ++idx < nvalues) ? true : (done = false);
            if (done) return values;
            Object value = null;
            value = null != decoder ? decoder.getBinaryValue() : GTSHelper.valueAtIndex(gts, idx);
            if (value instanceof Number || value instanceof Boolean) {
                values.add(this.elt(decoder, gts, idx, value));
                continue;
            }
            if (value instanceof byte[]) {
                try {
                    wrapper.clear();
                    deser.deserialize((TBase)wrapper, (byte[])value);
                    if (ELEMENT.VALUE == this.elementType) {
                        values.add(this.mvextract(GTSWrapperHelper.fromGTSWrapperToGTSEncoder(wrapper)));
                    }
                    ArrayList<Object> elt = new ArrayList<Object>();
                    elt.add(this.elt(decoder, gts, idx, value));
                    elt.add(this.mvextract(GTSWrapperHelper.fromGTSWrapperToGTSEncoder(wrapper)));
                    values.add(elt);
                }
                catch (IOException e) {
                    throw new WarpScriptException("Error decoding.", e);
                }
                catch (TException te) {
                    values.add(this.elt(decoder, gts, idx, value));
                }
                continue;
            }
            if (!(value instanceof String)) continue;
            if (null != decoder) {
                values.add(this.elt(decoder, null, idx, value));
                continue;
            }
            try {
                byte[] bytes = value.toString().getBytes(StandardCharsets.ISO_8859_1);
                wrapper.clear();
                deser.deserialize((TBase)wrapper, bytes);
                if (ELEMENT.VALUE == this.elementType) {
                    values.add(this.mvextract(GTSWrapperHelper.fromGTSWrapperToGTSEncoder(wrapper)));
                    continue;
                }
                ArrayList<Object> elt = new ArrayList<Object>();
                elt.add(this.elt(null, gts, idx, value));
                elt.add(this.mvextract(GTSWrapperHelper.fromGTSWrapperToGTSEncoder(wrapper)));
                values.add(elt);
                continue;
            }
            catch (IOException e) {
                throw new WarpScriptException("Error decoding.", e);
            }
            catch (TException te) {
                values.add(this.elt(null, gts, idx, value));
                continue;
            }
            break;
        }
    }

    private Object elt(GTSDecoder decoder, GeoTimeSerie gts, int idx, Object value) {
        switch (this.elementType) {
            case VALUE: {
                if (value instanceof BigDecimal) {
                    value = ((BigDecimal)value).doubleValue();
                }
                return value;
            }
            case TICK: {
                return null != decoder ? decoder.getTimestamp() : GTSHelper.tickAtIndex(gts, idx);
            }
            case LATLON: {
                long location = null != decoder ? decoder.getLocation() : GTSHelper.locationAtIndex(gts, idx);
                ArrayList<Double> latlon = new ArrayList<Double>(2);
                if (91480763316633925L == location) {
                    latlon.add(Double.NaN);
                    latlon.add(Double.NaN);
                } else {
                    double[] latlonArray = GeoXPLib.fromGeoXPPoint((long)location);
                    latlon.add(latlonArray[0]);
                    latlon.add(latlonArray[1]);
                }
                return latlon;
            }
            case ELEVATION: {
                return null != decoder ? decoder.getElevation() : GTSHelper.elevationAtIndex(gts, idx);
            }
            case LOCATION: {
                return null != decoder ? decoder.getLocation() : GTSHelper.locationAtIndex(gts, idx);
            }
        }
        throw new RuntimeException("Invalid element type.");
    }

    public static enum ELEMENT {
        TICK,
        LOCATION,
        LATLON,
        ELEVATION,
        VALUE;

    }
}

