/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;

public class MSIG
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public static final String SIGALG = "SHA256WITHECDSA";

    public MSIG(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (top instanceof WarpScriptStack.Macro) {
            WarpScriptStack.Macro macro = (WarpScriptStack.Macro)top;
            stack.push(macro);
            stack.push(MSIG.getSignature(macro));
        } else {
            if (!(top instanceof String)) {
                throw new WarpScriptException(this.getName() + " expects a hex encoded signature.");
            }
            top = stack.pop();
            if (!(top instanceof String)) {
                throw new WarpScriptException(this.getName() + " expects a hex encoded ECC public key.");
            }
            top = stack.pop();
            if (!(top instanceof String)) {
                throw new WarpScriptException(this.getName() + " expects an ECC curve name.");
            }
        }
        return stack;
    }

    public static WarpScriptStack.Macro getSignature(WarpScriptStack.Macro macro) {
        int size = macro.size();
        WarpScriptStack.Macro sigmacro = new WarpScriptStack.Macro();
        if (size >= 4 && macro.get(size - 1) instanceof MSIG && macro.get(size - 2) instanceof String && macro.get(size - 3) instanceof String && macro.get(size - 4) instanceof String) {
            sigmacro.add(macro.get(size - 4));
            sigmacro.add(macro.get(size - 3));
            sigmacro.add(macro.get(size - 2));
            sigmacro.add(macro.get(size - 1));
        }
        return sigmacro;
    }
}

