/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.Revision;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;

public class MINREV
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public MINREV(String name) {
        super(name);
    }

    private static int[] SplitRev(String revision, String errorMessage) throws WarpScriptException {
        if (null == revision || "".equals(revision)) {
            throw new WarpScriptException(errorMessage);
        }
        String[] gitSplit = revision.split("-");
        if (0 == gitSplit.length) {
            throw new WarpScriptException(errorMessage);
        }
        String[] revSplit = gitSplit[0].split("\\.");
        if (0 == revSplit.length) {
            throw new WarpScriptException(errorMessage);
        }
        int[] revIntSplit = new int[revSplit.length];
        for (int revIndex = 0; revIndex < revSplit.length; ++revIndex) {
            try {
                revIntSplit[revIndex] = Integer.valueOf(revSplit[revIndex]);
                continue;
            }
            catch (NumberFormatException nfe) {
                throw new WarpScriptException(errorMessage);
            }
        }
        return revIntSplit;
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object o = stack.pop();
        if (!(o instanceof String)) {
            throw new WarpScriptException(this.getName() + " expects a revision string on top of the stack.");
        }
        int[] givenRev = MINREV.SplitRev((String)o, this.getName() + " expects the given revision to be of the form 'X', 'X.Y' or 'X.Y.Z'. X, Y and Z are integers.");
        int[] currentRev = MINREV.SplitRev(Revision.REVISION, this.getName() + " expects the revision to be set on the platform to a string of the form 'X.Y.Z'. X, Y and Z are integers.");
        int revComp = 0;
        for (int revIndex = 0; revIndex < Math.min(givenRev.length, currentRev.length) && 0 == (revComp = Integer.compare(currentRev[revIndex], givenRev[revIndex])); ++revIndex) {
        }
        if (0 == revComp && givenRev.length > currentRev.length) {
            revComp = -1;
        }
        stack.push(0 <= revComp);
        return stack;
    }
}

