/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.WarpConfig;
import io.warp10.continuum.gts.GTSEncoder;
import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.continuum.store.Constants;
import io.warp10.continuum.store.thrift.data.Metadata;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.zip.GZIPOutputStream;

public class META
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private URL url = null;
    private final boolean delta;

    public META(String name) {
        this(name, false);
    }

    public META(String name, boolean delta) {
        super(name);
        this.delta = delta;
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object otoken = stack.pop();
        if (!(otoken instanceof String)) {
            throw new WarpScriptException(this.getName() + " expects a token.");
        }
        String token = (String)otoken;
        ArrayList<Metadata> metas = new ArrayList<Metadata>();
        Object o = stack.pop();
        if (o instanceof GeoTimeSerie) {
            metas.add(((GeoTimeSerie)o).getMetadata());
        } else if (o instanceof GTSEncoder) {
            metas.add(((GTSEncoder)o).getMetadata());
        } else if (o instanceof List) {
            for (Object oo : (List)o) {
                if (oo instanceof GeoTimeSerie) {
                    metas.add(((GeoTimeSerie)oo).getMetadata());
                    continue;
                }
                if (oo instanceof GTSEncoder) {
                    metas.add(((GTSEncoder)oo).getMetadata());
                    continue;
                }
                throw new WarpScriptException(this.getName() + " can only operate on Geo Time Series, GTS Encoders or a list thereof.");
            }
        } else {
            throw new WarpScriptException(this.getName() + " can only operate on Geo Time Series, GTS Encoders or a list thereof");
        }
        if (0 == metas.size()) {
            return stack;
        }
        for (Metadata meta : metas) {
            if (null == meta.getName() || "".equals(meta.getName())) {
                throw new WarpScriptException(this.getName() + " can only set attributes of Geo Time Series or GTS Encoders which have a non empty name.");
            }
            if (null != meta.getAttributes()) continue;
            throw new WarpScriptException(this.getName() + " can only operate on Geo Time Series or GTS Encoders which have attributes.");
        }
        HttpURLConnection conn = null;
        try {
            if (null == this.url) {
                String url_property = WarpConfig.getProperty("warpscript.meta.endpoint");
                if (null != url_property) {
                    try {
                        this.url = new URL(url_property);
                    }
                    catch (MalformedURLException mue) {
                        throw new WarpScriptException(this.getName() + " configuration parameter '" + "warpscript.meta.endpoint" + "' does not define a valid URL.");
                    }
                } else {
                    throw new WarpScriptException(this.getName() + " configuration parameter '" + "warpscript.meta.endpoint" + "' not set.");
                }
            }
            conn = (HttpURLConnection)this.url.openConnection();
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setRequestMethod("POST");
            if (this.delta) {
                conn.setRequestProperty(Constants.getHeader("http.header.attributes"), "delta");
            }
            conn.setRequestProperty(Constants.getHeader("http.header.token.META"), token);
            conn.setRequestProperty("Content-Type", "application/gzip");
            conn.setChunkedStreamingMode(16384);
            conn.connect();
            OutputStream os = conn.getOutputStream();
            GZIPOutputStream out = new GZIPOutputStream(os);
            PrintWriter pw = new PrintWriter(out);
            StringBuilder sb = new StringBuilder();
            for (Metadata meta : metas) {
                sb.setLength(0);
                GTSHelper.metadataToString(sb, meta.getName(), meta.getLabels(), true);
                HashMap<String, String> attributes = null != meta.getAttributes() ? meta.getAttributes() : new HashMap<String, String>();
                GTSHelper.labelsToString(sb, attributes, true);
                pw.println(sb.toString());
                stack.handleSignal();
            }
            pw.close();
            if (200 != conn.getResponseCode()) {
                throw new WarpScriptException(this.getName() + " failed to complete successfully (" + conn.getResponseMessage() + ")");
            }
            conn.disconnect();
            conn = null;
        }
        catch (IOException ioe) {
            throw new WarpScriptException(this.getName() + " failed.", ioe);
        }
        finally {
            if (null != conn) {
                conn.disconnect();
            }
        }
        return stack;
    }
}

